/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLock;
import com.webobjects.foundation.NSLocking;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NSMultiReaderLock
implements NSLocking {
    public static final Class<NSMultiReaderLock> _CLASS = _NSUtilities._classWithClassLiteral(NSMultiReaderLock.class);
    NSMutableDictionary<Thread, LockRecord> _lockTable = new NSMutableDictionary(8);
    private static final Logger log = LoggerFactory.getLogger(NSMultiReaderLock.class);
    volatile Thread _writerLockThread = null;
    volatile int _writerLockCount = 0;
    volatile int _totalReaderCount = 0;
    NSLock _instanceLock = new NSLock();
    ConditionLock _writerFinished = new ConditionLock(this._instanceLock);
    ConditionLock _readerFinished = new ConditionLock(this._instanceLock);
    private static final int EOEnabled = 0;
    private static final int EOPromoted = 1;
    private static final int EOSuspended = 2;

    private void _gcLockTable() {
        if (this._lockTable.count() == 0) {
            return;
        }
        NSArray threads = this._lockTable.allKeys();
        int i = threads.count() - 1;
        while (i >= 0) {
            Thread aThread = (Thread)threads.objectAtIndex(i);
            if (!aThread.isAlive()) {
                this._lockTable.removeObjectForKey(aThread);
            }
            --i;
        }
    }

    public void lockForReading() {
        this._instanceLock.lock();
        this._lockForReading();
        this._instanceLock.unlock();
    }

    private void _lockForReading() {
        Thread currentThread = Thread.currentThread();
        LockRecord lockInfo = (LockRecord)this._lockTable.objectForKey(currentThread);
        if (lockInfo == null) {
            lockInfo = new LockRecord();
            this._gcLockTable();
            this._lockTable.setObjectForKey(lockInfo, currentThread);
        }
        if (lockInfo.readerLockCount() == 0L && this._writerLockThread != currentThread) {
            while (this._writerLockThread != null) {
                this._writerFinished.await();
            }
        }
        lockInfo.incrementLockCount();
    }

    public void unlockForReading() {
        Thread currentThread = Thread.currentThread();
        this._instanceLock.lock();
        LockRecord lockInfo = (LockRecord)this._lockTable.objectForKey(currentThread);
        if (lockInfo == null || lockInfo.readerLockCount() == 0L) {
            this._instanceLock.unlock();
            return;
        }
        lockInfo.decrementLockCount();
        this._instanceLock.unlock();
        if (lockInfo.readerLockCount() == 0L) {
            this._readerFinished.signal();
        }
    }

    @Override
    public void lock() {
        this.lockForWriting();
    }

    public void lockForWriting() {
        this._instanceLock.lock();
        this._lockForWriting();
        this._instanceLock.unlock();
    }

    private void _lockForWriting() {
        Thread currentThread = Thread.currentThread();
        if (this._writerLockThread == currentThread) {
            ++this._writerLockCount;
            return;
        }
        LockRecord lockInfo = (LockRecord)this._lockTable.objectForKey(currentThread);
        if (lockInfo == null) {
            lockInfo = new LockRecord();
            this._gcLockTable();
            this._lockTable.setObjectForKey(lockInfo, currentThread);
        }
        if (lockInfo.readerLockCount() != 0L) {
            lockInfo.promote();
            this._readerFinished.signal();
        }
        while (this._writerLockThread != null) {
            this._writerFinished.await();
        }
        this._writerLockThread = currentThread;
        while (this._totalReaderCount > 0) {
            this._readerFinished.await();
        }
        ++this._writerLockCount;
    }

    @Override
    public void unlock() {
        this.unlockForWriting();
    }

    public void unlockForWriting() {
        this._instanceLock.lock();
        if (this._writerLockThread == null || this._writerLockCount == 0) {
            this._instanceLock.unlock();
            return;
        }
        --this._writerLockCount;
        if (this._writerLockCount > 0) {
            this._instanceLock.unlock();
        } else {
            LockRecord lockInfo = (LockRecord)this._lockTable.objectForKey(Thread.currentThread());
            if (lockInfo != null) {
                lockInfo.demote();
            }
            this._writerLockThread = null;
            this._instanceLock.unlock();
            this._writerFinished.broadcast();
        }
    }

    public void suspendReaderLocks() {
        this._instanceLock.lock();
        LockRecord lockInfo = (LockRecord)this._lockTable.objectForKey(Thread.currentThread());
        if (lockInfo != null) {
            lockInfo.suspend();
        }
        this._instanceLock.unlock();
        this._readerFinished.signal();
    }

    public void retrieveReaderLocks() {
        Thread currentThread = Thread.currentThread();
        this._instanceLock.lock();
        LockRecord lockInfo = (LockRecord)this._lockTable.objectForKey(currentThread);
        if (lockInfo != null) {
            lockInfo.retrieve();
        }
        if (currentThread == this._writerLockThread) {
            if (lockInfo != null) {
                lockInfo.promote();
            }
            this._instanceLock.unlock();
            return;
        }
        if (this._writerLockThread != null) {
            this._writerFinished.await();
        }
        this._instanceLock.unlock();
    }

    public boolean tryLockForWriting() {
        Thread currentThread = Thread.currentThread();
        if (this._writerLockCount > 0 && this._writerLockThread == currentThread) {
            this._instanceLock.lock();
            if (this._writerLockCount > 0 && this._writerLockThread == currentThread) {
                ++this._writerLockCount;
                this._instanceLock.unlock();
                return true;
            }
            this._instanceLock.unlock();
        }
        if (this._writerLockCount == 0 && this._totalReaderCount == 0) {
            this._instanceLock.lock();
            if (this._writerLockCount == 0 && this._totalReaderCount == 0) {
                this._lockForWriting();
                this._instanceLock.unlock();
                return true;
            }
            this._instanceLock.unlock();
        }
        return false;
    }

    public boolean tryLockForReading() {
        Thread currentThread = Thread.currentThread();
        if (this._writerLockThread != null && currentThread != this._writerLockThread) {
            return false;
        }
        this._instanceLock.lock();
        if (this._writerLockThread == null || currentThread == this._writerLockThread) {
            this._lockForReading();
            this._instanceLock.unlock();
            return true;
        }
        this._instanceLock.unlock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer lockTableString = new StringBuffer();
        int index = 0;
        NSMultiReaderLock nSMultiReaderLock = this;
        synchronized (nSMultiReaderLock) {
            this._gcLockTable();
            Enumeration enumr = this._lockTable.keyEnumerator();
            while (enumr.hasMoreElements()) {
                Thread aThread = (Thread)enumr.nextElement();
                LockRecord info = (LockRecord)this._lockTable.objectForKey(aThread);
                String status = "        ";
                switch (info.readerStatus()) {
                    case 0: {
                        if (aThread != this._writerLockThread) break;
                        status = " WRT:" + this._padString(this._writerLockCount, 3);
                        break;
                    }
                    case 1: {
                        status = " pmt:" + this._padString(this._writerLockCount, 3);
                        break;
                    }
                    case 2: {
                        status = " ssp:" + this._padString(this._writerLockCount, 3);
                    }
                }
                lockTableString.append(String.valueOf(this._padString(aThread.getName(), 13, true)) + ":" + this._padString(info.readerLockCount(), 3) + status);
                if (++index % 3 != 0) continue;
                lockTableString.append("\n");
            }
        }
        return "<NSMultiReaderLock (from " + Thread.currentThread().getName() + ")>\n" + lockTableString;
    }

    protected String _padString(long num, int fieldWidth) {
        return this._padString(String.valueOf(num), fieldWidth, false);
    }

    protected String _padString(String val, int fieldWidth, boolean truncate) {
        String padding = "                                   ";
        String paddedString = val;
        int valLength = paddedString.length();
        if (truncate && valLength > fieldWidth) {
            paddedString = paddedString.substring(valLength - fieldWidth);
        }
        if (valLength >= fieldWidth) {
            return paddedString;
        }
        return String.valueOf(padding.substring(35 - fieldWidth + valLength)) + paddedString;
    }

    synchronized void validateLockCounts() {
        long cummTotal = 0L;
        NSArray threads = this._lockTable.allValues();
        Enumeration enumr = threads.objectEnumerator();
        while (enumr.hasMoreElements()) {
            LockRecord lockInfo = (LockRecord)enumr.nextElement();
            if (lockInfo.readerStatus() != 0) continue;
            cummTotal += lockInfo.readerLockCount();
        }
        if (cummTotal != (long)this._totalReaderCount) {
            throw new Error("_totalReaderCount (" + this._totalReaderCount + ") does not match locking table count (" + cummTotal + "). Current state :" + this.toString());
        }
    }

    private class ConditionLock {
        private NSLock _lock;

        public ConditionLock(NSLock lock) {
            this._lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            try {
                ConditionLock conditionLock = this;
                synchronized (conditionLock) {
                    this._lock.unlock();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        log.debug("An exception occurred", (Throwable)ex);
                        this.notify();
                    }
                }
            }
            finally {
                this._lock.lock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(long msecs) {
            boolean success = false;
            try {
                ConditionLock conditionLock = this;
                synchronized (conditionLock) {
                    this._lock.unlock();
                    try {
                        if (msecs > 0L) {
                            long start = System.currentTimeMillis();
                            this.wait(msecs);
                            success = System.currentTimeMillis() - start <= msecs;
                        }
                    }
                    catch (InterruptedException ex) {
                        log.debug("An exception occurred", (Throwable)ex);
                        this.notify();
                    }
                }
            }
            finally {
                this._lock.lock();
            }
            return success;
        }

        public synchronized void signal() {
            this.notify();
        }

        public synchronized void broadcast() {
            this.notifyAll();
        }
    }

    private class LockRecord {
        private long _readerLockCount = 0L;
        private int _readerStatus = 0;

        public long readerLockCount() {
            return this._readerLockCount;
        }

        public void incrementLockCount() {
            ++this._readerLockCount;
            if (this._readerStatus == 0) {
                ++NSMultiReaderLock.this._totalReaderCount;
            }
        }

        public void decrementLockCount() {
            --this._readerLockCount;
            if (this._readerStatus == 0) {
                --NSMultiReaderLock.this._totalReaderCount;
            }
        }

        public int readerStatus() {
            return this._readerStatus;
        }

        public void promote() {
            if (this._readerStatus == 0) {
                this._readerStatus = 1;
                NSMultiReaderLock.this._totalReaderCount = (int)((long)NSMultiReaderLock.this._totalReaderCount - this._readerLockCount);
            }
        }

        public void demote() {
            if (this._readerStatus == 1) {
                this._readerStatus = 0;
                NSMultiReaderLock.this._totalReaderCount = (int)((long)NSMultiReaderLock.this._totalReaderCount + this._readerLockCount);
            }
        }

        public void suspend() {
            if (this._readerStatus != 2) {
                this._readerStatus = 2;
                NSMultiReaderLock.this._totalReaderCount = (int)((long)NSMultiReaderLock.this._totalReaderCount - this._readerLockCount);
            }
        }

        public void retrieve() {
            if (this._readerStatus == 2) {
                this._readerStatus = 0;
                NSMultiReaderLock.this._totalReaderCount = (int)((long)NSMultiReaderLock.this._totalReaderCount + this._readerLockCount);
            }
        }
    }
}

