/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public final class NSLog {
    public static final long DebugGroupEnterpriseObjects = 2L;
    public static final long DebugGroupWebObjects = 4L;
    public static final long DebugGroupApplicationGeneration = 8L;
    public static final long DebugGroupMultithreading = 16L;
    public static final long DebugGroupResources = 32L;
    public static final long DebugGroupArchiving = 64L;
    public static final long DebugGroupValidation = 128L;
    public static final long DebugGroupKeyValueCoding = 256L;
    public static final long DebugGroupComponentBindings = 512L;
    public static final long DebugGroupFormatting = 1024L;
    public static final long DebugGroupQualifiers = 2048L;
    public static final long DebugGroupIO = 8192L;
    public static final long DebugGroupTiming = 16384L;
    public static final long DebugGroupModel = 32768L;
    public static final long DebugGroupDatabaseAccess = 65536L;
    public static final long DebugGroupSQLGeneration = 131072L;
    public static final long DebugGroupUserInterface = 262144L;
    public static final long DebugGroupAssociations = 524288L;
    public static final long DebugGroupControllers = 0x100000L;
    public static final long DebugGroupRules = 0x200000L;
    public static final long DebugGroupDeployment = 0x400000L;
    public static final long DebugGroupParsing = 0x800000L;
    public static final long DebugGroupReflection = 0x1000000L;
    public static final long DebugGroupRequestHandling = 0x2000000L;
    public static final long DebugGroupComponents = 0x4000000L;
    public static final long DebugGroupJSPServlets = 0x8000000L;
    public static final long DebugGroupWebServices = 0x10000000L;
    private static final long _DebugGroupAll = -1L;
    private static final long _DefaultDebugGroups = -8388609L;
    public static final int DebugLevelOff = 0;
    public static final int DebugLevelCritical = 1;
    public static final int DebugLevelInformational = 2;
    public static final int DebugLevelDetailed = 3;
    public static final String _D2WTraceRuleFiringEnabledKey = "D2WTraceRuleFiringEnabled";
    public static final String _D2WTraceRuleModificationsEnabledKey = "D2WTraceRuleModificationsEnabled";
    private static final String EOAdaptorDebugEnabled = "EOAdaptorDebugEnabled";
    private static final String NSDebugGroups = "NSDebugGroups";
    private static final String NSDebugLevel = "NSDebugLevel";
    private static final int debugGroupMaxBitPos = 63;
    private static final int debugGroupMinBitPos = 0;
    private static final char debugGroupRangeChar = ':';
    private static final int notFound = -1;
    public static volatile Logger debug = new PrintStreamLogger(System.err);
    public static volatile Logger err = new PrintStreamLogger(System.err);
    public static volatile Logger out = new PrintStreamLogger(System.out);
    private static volatile long debugGroups = 0L;
    private static volatile boolean PRIVATE_DEBUGGING_ENABLED;
    private static volatile boolean _inInitPhase;
    public static volatile String _WODebuggingEnabledKey;

    static {
        _inInitPhase = false;
        _WODebuggingEnabledKey = "WODebuggingEnabled";
        out.setIsVerbose(false);
        debug.setIsVerbose(true);
        err.setIsVerbose(true);
        NSLog._initDebugDefaults();
    }

    private NSLog() {
    }

    public static void _conditionallyLogPrivateException(Throwable t) {
        if (NSLog._debugLoggingAllowedForLevel(3)) {
            debug.appendln(t);
        }
    }

    public static boolean _debugLoggingAllowedForGroups(long aDebugGroups) {
        return PRIVATE_DEBUGGING_ENABLED && NSLog.debugLoggingAllowedForGroups(aDebugGroups);
    }

    public static boolean _debugLoggingAllowedForLevel(int aDebugLevel) {
        return PRIVATE_DEBUGGING_ENABLED && NSLog.debugLoggingAllowedForLevel(aDebugLevel);
    }

    public static boolean _debugLoggingAllowedForLevelAndGroups(int aDebugLevel, long aDebugGroups) {
        return PRIVATE_DEBUGGING_ENABLED && NSLog.debugLoggingAllowedForLevelAndGroups(aDebugLevel, aDebugGroups);
    }

    public static void _initDebugDefaults() {
        block32: {
            try {
                String value = NSProperties.getProperty("NSPrivateDebuggingEnabled");
                PRIVATE_DEBUGGING_ENABLED = NSPropertyListSerialization.booleanForString(value);
                value = NSProperties.getProperty(NSDebugLevel);
                if (value != null) {
                    int parsedValue = NSLog.parseIntValueFromString(value);
                    NSLog.setAllowedDebugLevel(parsedValue);
                }
                if (NSPropertyListSerialization.booleanForString(value = NSProperties.getProperty(EOAdaptorDebugEnabled))) {
                    if (NSLog.allowedDebugLevel() < 2) {
                        NSLog.setAllowedDebugLevel(2);
                    }
                    NSLog.allowDebugLoggingForGroups(65536L);
                }
                if (NSPropertyListSerialization.booleanForString(value = NSProperties.getProperty(_WODebuggingEnabledKey))) {
                    if (NSLog.allowedDebugLevel() < 2) {
                        NSLog.setAllowedDebugLevel(2);
                    }
                    NSLog.allowDebugLoggingForGroups(4L);
                }
                if (NSPropertyListSerialization.booleanForString(value = NSProperties.getProperty(_D2WTraceRuleFiringEnabledKey))) {
                    if (NSLog.allowedDebugLevel() < 3) {
                        NSLog.setAllowedDebugLevel(3);
                    }
                    NSLog.allowDebugLoggingForGroups(0x200000L);
                }
                if (NSPropertyListSerialization.booleanForString(value = NSProperties.getProperty(_D2WTraceRuleModificationsEnabledKey))) {
                    if (NSLog.allowedDebugLevel() < 3) {
                        NSLog.setAllowedDebugLevel(3);
                    }
                    NSLog.allowDebugLoggingForGroups(8L);
                }
                if ((value = NSProperties.getProperty(NSDebugGroups)) != null && value.length() > 0) {
                    long parsedLongValue = 0L;
                    Object plistValue = null;
                    try {
                        plistValue = NSPropertyListSerialization.propertyListFromString(value);
                    }
                    catch (RuntimeException runtimeException) {}
                    if (plistValue == null) {
                        try {
                            parsedLongValue = Long.parseLong(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            err.appendln("<NSLog> Unable to parse a property list from the following string -- using default instead!  String: " + value);
                        }
                    } else if (plistValue instanceof String) {
                        String unparsedValue = (String)plistValue;
                        if (unparsedValue.indexOf(58) == -1 && unparsedValue.toLowerCase().equals(unparsedValue.toUpperCase())) {
                            try {
                                parsedLongValue = Long.parseLong(unparsedValue);
                            }
                            catch (NumberFormatException numberFormatException) {
                                err.appendln("<NSLog> Unable to parse a long value from the following string: \"" + unparsedValue + "\"");
                            }
                        } else {
                            parsedLongValue = NSLog.parseLongValueFromString(unparsedValue);
                        }
                    } else if (plistValue instanceof NSArray) {
                        NSArray debugGroupBitIDs = (NSArray)plistValue;
                        int count = debugGroupBitIDs.count();
                        int i = 0;
                        while (i < count) {
                            Object debugGroupBitID = debugGroupBitIDs.objectAtIndex(i);
                            if (debugGroupBitID instanceof String) {
                                parsedLongValue |= NSLog.parseLongValueFromString((String)debugGroupBitID);
                            } else {
                                err.appendln("<NSLog> Unable to parse an NSArray member of type '" + debugGroupBitID.getClass().getName() + "' -- skipping that value!  member: " + debugGroupBitID.toString());
                            }
                            ++i;
                        }
                    } else {
                        err.appendln("<NSLog> Unable to parse an NSArray or String from the following string -- using default instead!  String: " + value);
                    }
                    if (parsedLongValue == 0L) {
                        NSLog.setAllowedDebugGroups(-8388609L);
                    } else {
                        NSLog.setAllowedDebugGroups(parsedLongValue);
                    }
                    break block32;
                }
                if (NSLog.allowedDebugLevel() > 0 && debugGroups == 0L) {
                    NSLog.setAllowedDebugGroups(-8388609L);
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    private static int parseIntValueFromString(String aDebugLevel) {
        int parsedIntValue = 0;
        if (aDebugLevel.charAt(0) >= '0' && aDebugLevel.charAt(0) <= '9') {
            try {
                parsedIntValue = Integer.parseInt(aDebugLevel);
            }
            catch (NumberFormatException numberFormatException) {
                err.appendln("<NSLog> Unable to parse Integer value from the following string -- skipping!  String: " + aDebugLevel);
            }
        } else {
            int delimiter = aDebugLevel.lastIndexOf(46);
            if (delimiter == -1) {
                err.appendln("<NSLog> The given symbol is not in the form of [className].[fieldName] -- skipping!  String: " + aDebugLevel);
            } else {
                String className = aDebugLevel.substring(0, delimiter);
                String fieldName = aDebugLevel.substring(delimiter + 1);
                Class<?> specifiedClass = _NSUtilities.classWithName(className);
                if (specifiedClass == null) {
                    err.appendln("<NSLog> The given symbol does not indicate a loaded class -- skipping!  String: " + aDebugLevel + "; class: " + className + "; field: " + fieldName);
                } else {
                    try {
                        Field specifiedField = specifiedClass.getField(fieldName);
                        if (specifiedField.getType() == Integer.TYPE) {
                            parsedIntValue = specifiedField.getInt(null);
                        } else {
                            err.appendln("<NSLog> The given symbol does not indicate an int value -- skipping!  String: " + aDebugLevel + "; class: " + className + "; field: " + fieldName);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        err.appendln("<NSLog> The underlying constructor for the specified class is inaccessible, perhaps because it isn't public -- skipping!  String: " + aDebugLevel + "; class: " + className + "; field: " + fieldName);
                    }
                    catch (NullPointerException nullPointerException) {
                        err.appendln("<NSLog> The specified field of the specified class is an instance field, not a class field -- skipping!  String: " + aDebugLevel + "; class: " + className + "; field: " + fieldName);
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                        err.appendln("<NSLog> The specified class failed during class initialization.  Perhaps the class has a circular dependency on NSLog itself, or else there's a general problem initializing that class at this time -- skipping!  String: " + aDebugLevel + "; class: " + className + "; field: " + fieldName);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        err.appendln("<NSLog> Unable to find the specified field for the loaded class, because it doesn't exist or because of Java security restrictions -- skipping!  String: " + aDebugLevel + "; class: " + className + "; field: " + fieldName);
                    }
                    catch (SecurityException securityException) {
                        err.appendln("<NSLog> Unable to gather the specified field due to Java security restrictions -- skipping!  String: " + aDebugLevel + "; class: " + className + "; field: " + fieldName);
                    }
                }
            }
        }
        return parsedIntValue;
    }

    private static long parseLongValueFromString(String aDebugGroup) {
        long parsedLongValue;
        block34: {
            parsedLongValue = 0L;
            int rangeDelimiter = aDebugGroup.indexOf(58);
            if (rangeDelimiter == -1) {
                if (aDebugGroup.charAt(0) >= '0' && aDebugGroup.charAt(0) <= '9') {
                    try {
                        int bitPosition = Integer.parseInt(aDebugGroup);
                        if (bitPosition < 0 || bitPosition > 63) {
                            err.appendln("<NSLog> Invalid literal bit position -- skipping!  String: " + aDebugGroup);
                            break block34;
                        }
                        parsedLongValue = 1L << bitPosition;
                    }
                    catch (NumberFormatException numberFormatException) {
                        err.appendln("<NSLog> Unable to parse Integer value from the following string -- skipping!  String: " + aDebugGroup);
                    }
                } else {
                    int delimiter = aDebugGroup.lastIndexOf(46);
                    if (delimiter == -1) {
                        err.appendln("<NSLog> The given symbol is not in the form of [className].[fieldName] -- skipping!  String: " + aDebugGroup);
                    } else {
                        String className = aDebugGroup.substring(0, delimiter);
                        String fieldName = aDebugGroup.substring(delimiter + 1);
                        Class<?> specifiedClass = _NSUtilities.classWithName(className);
                        if (specifiedClass == null) {
                            err.appendln("<NSLog> The given symbol does not indicate a loaded class -- skipping!  String: " + aDebugGroup + "; class: " + className + "; field: " + fieldName);
                        } else {
                            try {
                                Field specifiedField = specifiedClass.getField(fieldName);
                                if (specifiedField.getType() == Long.TYPE) {
                                    parsedLongValue = specifiedField.getLong(null);
                                    break block34;
                                }
                                err.appendln("<NSLog> The given symbol does not indicate a long value -- skipping!  String: " + aDebugGroup + "; class: " + className + "; field: " + fieldName);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                err.appendln("<NSLog> The underlying constructor for the specified class is inaccessible, perhaps because it isn't public -- skipping!  String: " + aDebugGroup + "; class: " + className + "; field: " + fieldName);
                            }
                            catch (NullPointerException nullPointerException) {
                                err.appendln("<NSLog> The specified field of the specified class is an instance field, not a class field -- skipping!  String: " + aDebugGroup + "; class: " + className + "; field: " + fieldName);
                            }
                            catch (ExceptionInInitializerError exceptionInInitializerError) {
                                err.appendln("<NSLog> The specified class failed during class initialization.  Perhaps the class has a circular dependency on NSLog itself, or else there's a general problem initializing that class at this time -- skipping!  String: " + aDebugGroup + "; class: " + className + "; field: " + fieldName);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                err.appendln("<NSLog> Unable to find the specified field for the loaded class, because it doesn't exist or because of Java security restrictions -- skipping!  String: " + aDebugGroup + "; class: " + className + "; field: " + fieldName);
                            }
                            catch (SecurityException securityException) {
                                err.appendln("<NSLog> Unable to gather the specified field due to Java security restrictions -- skipping!  String: " + aDebugGroup + "; class: " + className + "; field: " + fieldName);
                            }
                        }
                    }
                }
            } else {
                String literal;
                int highEndOfRange = 63;
                int lowEndOfRange = 0;
                if (rangeDelimiter == 0) {
                    literal = aDebugGroup.substring(1);
                    try {
                        highEndOfRange = Integer.parseInt(literal);
                    }
                    catch (NumberFormatException numberFormatException) {
                        err.appendln("<NSLog> Unable to parse Integer value from the following high string value -- skipping!  String: " + aDebugGroup + "; high: " + literal);
                        highEndOfRange = -1;
                    }
                } else if (rangeDelimiter == aDebugGroup.length() - 1) {
                    literal = aDebugGroup.substring(0, rangeDelimiter);
                    try {
                        lowEndOfRange = Integer.parseInt(literal);
                    }
                    catch (NumberFormatException numberFormatException) {
                        err.appendln("<NSLog> Unable to parse Integer value from the following low string value -- skipping!  String: " + aDebugGroup + "; low: " + literal);
                        lowEndOfRange = -1;
                    }
                } else {
                    String literal1 = aDebugGroup.substring(0, rangeDelimiter);
                    String literal2 = aDebugGroup.substring(rangeDelimiter + 1);
                    try {
                        lowEndOfRange = Integer.parseInt(literal1);
                        highEndOfRange = Integer.parseInt(literal2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        err.appendln("<NSLog> Unable to parse Integer value from one or both of the following string values -- skipping!  String: " + aDebugGroup + "; low: " + literal1 + "; high: " + literal2);
                        lowEndOfRange = -1;
                        highEndOfRange = -1;
                    }
                }
                if (highEndOfRange != -1 && lowEndOfRange != -1) {
                    if (highEndOfRange < lowEndOfRange) {
                        err.appendln("<NSLog> Invalid range: low end value is greater than the high end value -- skipping!  String: " + aDebugGroup + "; low: " + lowEndOfRange + "; high: " + highEndOfRange);
                    } else if (lowEndOfRange < 0 || lowEndOfRange > 63 || highEndOfRange < 0 || highEndOfRange > 63) {
                        err.appendln("<NSLog> One or both of these literal bit positions are invalid (must be in range 0-63) -- skipping!  String: " + aDebugGroup + "; low: " + lowEndOfRange + "; high: " + highEndOfRange);
                    } else {
                        int i = lowEndOfRange;
                        while (i <= highEndOfRange) {
                            parsedLongValue |= 1L << i;
                            ++i;
                        }
                    }
                }
            }
        }
        return parsedLongValue;
    }

    public static void _setInInitPhase(boolean flag) {
        if (!flag && _inInitPhase) {
            NSLog._initDebugDefaults();
        }
        _inInitPhase = flag;
    }

    public static synchronized void allowDebugLoggingForGroups(long aDebugGroups) {
        debugGroups |= aDebugGroups;
    }

    @Deprecated
    public static int allowedDebugLevel() {
        return debug.allowedDebugLevel();
    }

    public static boolean debugLoggingAllowedForGroups(long aDebugGroups) {
        return _inInitPhase || debug.allowedDebugLevel() > 0 && (debugGroups & aDebugGroups) != 0L;
    }

    public static boolean debugLoggingAllowedForLevel(int aDebugLevel) {
        return _inInitPhase && aDebugLevel <= 1 || aDebugLevel > 0 && aDebugLevel <= NSLog.allowedDebugLevel();
    }

    public static boolean debugLoggingAllowedForLevelAndGroups(int aDebugLevel, long aDebugGroups) {
        return NSLog.debugLoggingAllowedForLevel(aDebugLevel) && NSLog.debugLoggingAllowedForGroups(aDebugGroups);
    }

    public static PrintStream printStreamForPath(String aPath) {
        PrintStream aStream = null;
        if (aPath != null) {
            File aFile = new File(aPath);
            try {
                aStream = new PrintStream(new FileOutputStream(aFile), true);
            }
            catch (IOException iOException) {}
        }
        return aStream;
    }

    public static synchronized void refuseDebugLoggingForGroups(long aDebugGroups) {
        debugGroups &= aDebugGroups ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void setAllowedDebugGroups(long aDebugGroups) {
        debugGroups = aDebugGroups;
    }

    @Deprecated
    public static void setAllowedDebugLevel(int aDebugLevel) {
        debug.setAllowedDebugLevel(aDebugLevel);
    }

    public static void setDebug(Logger instance) {
        if (instance != null) {
            debug = instance;
        }
    }

    public static void setDebug(Logger instance, int aDebugLevel) {
        if (instance != null) {
            instance.setAllowedDebugLevel(aDebugLevel);
            debug = instance;
        }
    }

    public static void setErr(Logger instance) {
        if (instance != null) {
            err = instance;
        }
    }

    public static void setOut(Logger instance) {
        if (instance != null) {
            out = instance;
        }
    }

    public static String throwableAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static class Log4JLogger
    extends Logger {
        protected org.apache.log4j.Logger logger;
        protected Level logLevel;

        public Log4JLogger() {
        }

        public Log4JLogger(org.apache.log4j.Logger aLogger, int level) {
            if (aLogger == null) {
                throw new IllegalArgumentException("<" + this.getClass().getName() + "> org.apache.log4j.Logger parameter cannot be null.");
            }
            this.logger = aLogger;
            this.setAllowedDebugLevel(level);
        }

        protected static int convertLog4JLevelToNSLogLevel(int aLog4JDebugLevel) {
            int nsLogDebugLevel;
            switch (aLog4JDebugLevel) {
                case 0x7FFFFFFF: {
                    nsLogDebugLevel = 0;
                    break;
                }
                case 30000: 
                case 40000: 
                case 50000: {
                    nsLogDebugLevel = 1;
                    break;
                }
                case 20000: {
                    nsLogDebugLevel = 2;
                    break;
                }
                case -2147483648: 
                case 10000: {
                    nsLogDebugLevel = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("<NSLog> Invalid Log4J debug level: " + aLog4JDebugLevel);
                }
            }
            return nsLogDebugLevel;
        }

        protected static int convertNSLogLevelToLog4JLevel(int anNSLogDebugLevel) {
            int log4jDebugLevel;
            switch (anNSLogDebugLevel) {
                case 0: {
                    log4jDebugLevel = Integer.MAX_VALUE;
                    break;
                }
                case 1: {
                    log4jDebugLevel = 40000;
                    break;
                }
                case 2: {
                    log4jDebugLevel = 20000;
                    break;
                }
                case 3: {
                    log4jDebugLevel = 10000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("<NSLog> Invalid NSLog debug level: " + anNSLogDebugLevel);
                }
            }
            return log4jDebugLevel;
        }

        @Override
        public int allowedDebugLevel() {
            Level level = this.logger.getLevel();
            return level == null ? 0 : Log4JLogger.convertLog4JLevelToNSLogLevel(level.toInt());
        }

        @Override
        public void appendln() {
            this.appendln("");
        }

        @Override
        public void appendln(Object aValue) {
            this.logger.log((Priority)this.logLevel, aValue);
        }

        @Override
        public void flush() {
        }

        public org.apache.log4j.Logger log4jLogger() {
            return this.logger;
        }

        @Override
        public void setAllowedDebugLevel(int aDebugLevel) {
            int loggerDebugLevel = Log4JLogger.convertNSLogLevelToLog4JLevel(aDebugLevel);
            this.logLevel = Level.toLevel((int)loggerDebugLevel);
        }

        public void setLog4jLogger(org.apache.log4j.Logger aLogger) {
            if (aLogger != null) {
                this.logger = aLogger;
            }
        }
    }

    public static abstract class Logger {
        protected int debugLevel = 0;
        protected boolean isEnabled = true;
        protected boolean isVerbose = true;

        public int allowedDebugLevel() {
            return this.debugLevel;
        }

        public void appendln(boolean aValue) {
            this.appendln((Object)aValue);
        }

        public void appendln(byte aValue) {
            this.appendln((Object)aValue);
        }

        public void appendln(byte[] aValue) {
            this.appendln(new String(aValue));
        }

        public void appendln(char aValue) {
            this.appendln(Character.valueOf(aValue));
        }

        public void appendln(char[] aValue) {
            this.appendln(new String(aValue));
        }

        public void appendln(double aValue) {
            this.appendln((Object)aValue);
        }

        public void appendln(float aValue) {
            this.appendln(Float.valueOf(aValue));
        }

        public void appendln(int aValue) {
            this.appendln(_NSUtilities.IntegerForInt(aValue));
        }

        public void appendln(long aValue) {
            this.appendln((Object)aValue);
        }

        public void appendln(short aValue) {
            this.appendln((Object)aValue);
        }

        public void appendln(Throwable aValue) {
            this.appendln(NSLog.throwableAsString(aValue));
        }

        public abstract void appendln(Object var1);

        public abstract void appendln();

        public abstract void flush();

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public boolean isVerbose() {
            return this.isVerbose;
        }

        public void setAllowedDebugLevel(int aDebugLevel) {
            if (aDebugLevel < 0 || aDebugLevel > 3) {
                throw new IllegalArgumentException("<" + this.getClass().getName() + "> Invalid debug level: " + aDebugLevel);
            }
            this.debugLevel = aDebugLevel;
        }

        public void setIsEnabled(boolean aBool) {
            this.isEnabled = aBool;
        }

        public void setIsVerbose(boolean aBool) {
            this.isVerbose = aBool;
        }
    }

    public static class PrintStreamLogger
    extends Logger {
        protected String _prefixInfo = null;
        protected PrintStream _stream;
        private static final String _defaultFormatString = "yyyy-M-d H:m:s z";
        private static final TimeZone _tz;
        private long _lastVerboseLogTime;
        private String _lastTimestampText;

        static {
            try {
                _tz = TimeZone.getDefault();
            }
            catch (Exception e) {
                System.err.println("unable to initialize NSLog");
                e.printStackTrace(System.err);
                throw new RuntimeException(e);
            }
        }

        public PrintStreamLogger() {
            this(System.out);
        }

        public PrintStreamLogger(PrintStream ps) {
            if (ps == null) {
                throw new IllegalArgumentException("<" + this.getClass().getName() + "> java.io.PrintStream argument must be non-null");
            }
            this._stream = ps;
            this._lastVerboseLogTime = NSTimestamp.DistantPast.getTime();
        }

        public void _setPrefixInfo(String s) {
            this._prefixInfo = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String _verbosePrefix() {
            String threadName = Thread.currentThread().getName();
            NSTimestamp now = new NSTimestamp();
            long offset = now.getTime();
            String prefixInfo = this._prefixInfo;
            StringBuffer sb = new StringBuffer(50);
            PrintStreamLogger printStreamLogger = this;
            synchronized (printStreamLogger) {
                if (offset - this._lastVerboseLogTime >= 1000L) {
                    SimpleDateFormat formatter = new SimpleDateFormat(_defaultFormatString);
                    formatter.setTimeZone(_tz);
                    this._lastTimestampText = formatter.format(now);
                    this._lastVerboseLogTime = offset;
                }
            }
            if (prefixInfo != null) {
                sb.append("<");
                sb.append(this._prefixInfo);
                sb.append(">");
            }
            sb.append("[");
            sb.append(this._lastTimestampText);
            sb.append("] <");
            sb.append(threadName);
            sb.append("> ");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void appendln() {
            if (this.isEnabled) {
                PrintStream printStream = this._stream;
                synchronized (printStream) {
                    this._stream.println();
                    this._stream.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void appendln(Throwable aValue) {
            if (this.isEnabled) {
                PrintStream printStream = this._stream;
                synchronized (printStream) {
                    StringBuffer stackTrace = new StringBuffer();
                    if (this.isVerbose) {
                        stackTrace.append(this._verbosePrefix());
                    }
                    stackTrace.append(NSLog.throwableAsString(aValue));
                    this._stream.println(stackTrace.toString());
                    this._stream.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void appendln(Object aValue) {
            if (this.isEnabled) {
                PrintStream printStream = this._stream;
                synchronized (printStream) {
                    if (this.isVerbose) {
                        this._stream.println(String.valueOf(this._verbosePrefix()) + aValue);
                    } else {
                        this._stream.println(aValue);
                    }
                    this._stream.flush();
                }
            }
        }

        @Override
        public void flush() {
            this._stream.flush();
        }

        public PrintStream printStream() {
            return this._stream;
        }

        public void setPrintStream(PrintStream aStream) {
            if (aStream != null) {
                this._stream = aStream;
            }
        }
    }

    public static class _DevNullPrintStream
    extends PrintStream {
        public OutputStream originalOutputStream = null;

        public _DevNullPrintStream(OutputStream os) {
            super(os);
            this.originalOutputStream = os;
        }

        public _DevNullPrintStream(OutputStream os, boolean aBOOL) {
            super(os, aBOOL);
            this.originalOutputStream = os;
        }

        @Override
        protected void setError() {
        }

        @Override
        public boolean checkError() {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void print(boolean b) {
        }

        @Override
        public void print(char c) {
        }

        @Override
        public void print(char[] s) {
        }

        @Override
        public void print(double d) {
        }

        @Override
        public void print(float f) {
        }

        @Override
        public void print(int i) {
        }

        @Override
        public void print(long l) {
        }

        @Override
        public void print(Object obj) {
        }

        @Override
        public void print(String s) {
        }

        @Override
        public void println() {
        }

        @Override
        public void println(boolean x) {
        }

        @Override
        public void println(char x) {
        }

        @Override
        public void println(char[] x) {
        }

        @Override
        public void println(double x) {
        }

        @Override
        public void println(float x) {
        }

        @Override
        public void println(int x) {
        }

        @Override
        public void println(long x) {
        }

        @Override
        public void println(Object x) {
        }

        @Override
        public void println(String x) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
        }
    }
}

