/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation._NSReflectionUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NSKeyValueCodingAdditions
extends NSKeyValueCoding {
    public static final Class<NSKeyValueCodingAdditions> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSKeyValueCodingAdditions.class);
    public static final String KeyPathSeparator = ".";
    public static final char _KeyPathSeparatorChar = '.';

    public Object valueForKeyPath(String var1);

    public void takeValueForKeyPath(Object var1, String var2);

    public static class DefaultImplementation {
        public static final Class<DefaultImplementation> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(DefaultImplementation.class);
        private static final Logger log = LoggerFactory.getLogger(DefaultImplementation.class);

        protected static void filterStackTraceElements(String kvcMethodName, String kvcDisplayMethodName, Object object, String key, Throwable throwable) {
            block14: {
                try {
                    StackTraceElement[] elements;
                    if (!NSProperties.booleanForKeyWithDefault("NSFilterStackTraces", true) || (elements = throwable.getStackTrace()) == null || elements.length <= 0) break block14;
                    LinkedList<StackTraceElement> newElements = new LinkedList<StackTraceElement>();
                    boolean kvcInternalFailure = false;
                    boolean thisKVCStackTraceElementAdded = false;
                    int elementNum = 0;
                    while (elementNum < elements.length) {
                        StackTraceElement element = elements[elementNum];
                        if (!thisKVCStackTraceElementAdded) {
                            String elementClassName = element.getClassName();
                            if (elementClassName.equals(DefaultImplementation.class.getName()) && kvcMethodName.equals(element.getMethodName())) {
                                StackTraceElement peekElement;
                                String objectToString;
                                try {
                                    objectToString = String.valueOf(object);
                                }
                                catch (Throwable throwable2) {
                                    String string = objectToString = object == null ? "<null>" : object.getClass().getName();
                                }
                                if (objectToString.length() > 500) {
                                    objectToString = String.valueOf(objectToString.substring(0, 100)) + " ...";
                                }
                                newElements.add(new StackTraceElement("[KVC] " + (object == null ? "<null>" : object.getClass().getSimpleName()), String.valueOf(kvcDisplayMethodName) + " \"" + key + "\" ", objectToString, -1));
                                thisKVCStackTraceElementAdded = true;
                                if (elementNum + 1 < elements.length && (peekElement = elements[elementNum + 1]).getClassName().equals(Utility.class.getName()) && kvcMethodName.equals(peekElement.getMethodName())) {
                                    ++elementNum;
                                }
                            } else if (!(!kvcInternalFailure && (elementClassName.startsWith("sun.reflect.") || elementClassName.startsWith("java.lang.reflect.") || elementClassName.equals("com.webobjects.foundation.NSKeyValueCoding") || elementClassName.equals("com.webobjects.foundation.NSKeyValueCodingAdditions") || elementClassName.startsWith("com.webobjects.foundation.NSKeyValueCoding$") || elementClassName.startsWith("com.webobjects.foundation.NSKeyValueCodingAdditions$") || elementClassName.endsWith(".KeyValueCodingProtectedAccessor") || elementClassName.startsWith("com.webobjects.foundation._NSKeyBindingCreation$") || elementClassName.endsWith("$kvc_" + key + "_field") || elementClassName.endsWith("$kvc_" + key + "_get") || elementClassName.endsWith("$kvc_" + key + "_set")))) {
                                newElements.add(element);
                            } else if (elementNum == 0) {
                                kvcInternalFailure = true;
                                newElements.add(element);
                            }
                        } else {
                            newElements.add(element);
                        }
                        ++elementNum;
                    }
                    throwable.setStackTrace(newElements.toArray(new StackTraceElement[newElements.size()]));
                }
                catch (Throwable t) {
                    log.debug("An exception occurred", t);
                }
            }
        }

        public static Object valueForKeyPath(Object object, String keyPath) {
            Object value = null;
            String key = keyPath;
            if (keyPath == null) {
                return null;
            }
            int index = keyPath.indexOf(46);
            try {
                value = index < 0 ? NSKeyValueCoding.Utility.valueForKey(object, keyPath) : ((value = NSKeyValueCoding.Utility.valueForKey(object, key = keyPath.substring(0, index))) == null ? null : Utility.valueForKeyPath(value, keyPath.substring(index + 1)));
            }
            catch (RuntimeException e) {
                DefaultImplementation.filterStackTraceElements("valueForKeyPath", index < 0 ? "valueForKey" : "valueForKeyPath", object, keyPath, e);
                throw e;
            }
            return value;
        }

        public static void takeValueForKeyPath(Object object, Object value, String keyPath) {
            if (keyPath == null) {
                throw new IllegalArgumentException("Key path cannot be null");
            }
            String key = keyPath;
            int index = keyPath.indexOf(46);
            try {
                if (index < 0) {
                    NSKeyValueCoding.Utility.takeValueForKey(object, value, keyPath);
                } else {
                    key = keyPath.substring(0, index);
                    Object targetObject = NSKeyValueCoding.Utility.valueForKey(object, key);
                    if (targetObject != null) {
                        Utility.takeValueForKeyPath(targetObject, value, keyPath.substring(index + 1));
                    }
                }
            }
            catch (RuntimeException e) {
                DefaultImplementation.filterStackTraceElements("takeValueForKeyPath", index < 0 ? "takeValueForKey" : "takeValueForKeyPath", object, keyPath, e);
                throw e;
            }
        }

        DefaultImplementation() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }
    }

    public static class Statics
    implements NSKeyValueCodingAdditions {
        public static final String StaticKeyPathPrefix = "static.";
        public static final String StaticKeyPathClassNameSeparator = "#";
        private static final Statics _sharedInstance = new Statics();

        private Statics() {
        }

        public static Statics getInstance() {
            return _sharedInstance;
        }

        @Override
        public Object valueForKey(String key) {
            return this.valueForKeyPath(key);
        }

        @Override
        public void takeValueForKey(Object value, String key) {
            this.takeValueForKeyPath(value, key);
        }

        @Override
        public Object valueForKeyPath(String keyPath) {
            ClassKey clazz = Statics.resolveClassFromKeyPath(keyPath);
            if (clazz == null) {
                throw new IllegalStateException("Could not resolve class from static key path: '" + keyPath + "'.");
            }
            String key = keyPath.substring(keyPath.indexOf(StaticKeyPathClassNameSeparator) + 1);
            return Utility.valueForKeyPath(clazz, key);
        }

        @Override
        public void takeValueForKeyPath(Object value, String keyPath) {
            ClassKey clazz = Statics.resolveClassFromKeyPath(keyPath);
            if (clazz == null) {
                throw new IllegalStateException("Could not resolve class from static key path: '" + keyPath + "'.");
            }
            String key = keyPath.substring(keyPath.indexOf(StaticKeyPathClassNameSeparator) + 1);
            Utility.takeValueForKeyPath(clazz, value, key);
        }

        protected static ClassKey resolveClassFromKeyPath(String keyPath) {
            String className = keyPath.startsWith(StaticKeyPathPrefix) ? keyPath.substring(StaticKeyPathPrefix.length()) : keyPath;
            className = className.contains(StaticKeyPathClassNameSeparator) ? className.substring(0, className.indexOf(StaticKeyPathClassNameSeparator)) : className;
            Class<?> clazz = className.contains(NSKeyValueCodingAdditions.KeyPathSeparator) ? _NSReflectionUtilities.ClassUtil.forName(className) : _NSReflectionUtilities.ClassUtil.classFromSimpleName(className);
            return clazz == null ? null : new ClassKey(clazz);
        }

        public static class ClassKey {
            private Class<?> clazz;

            public ClassKey(Class<?> clazz) {
                this.clazz = clazz;
            }

            public Class<?> clazz() {
                return this.clazz;
            }

            public String toString() {
                return "ClassKey[" + this.clazz + "]";
            }
        }
    }

    public static class Utility {
        public static final Class<Utility> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(Utility.class);

        public static Object valueForKeyPath(Object object, String keyPath) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSKeyValueCodingAdditions) {
                return ((NSKeyValueCodingAdditions)object).valueForKeyPath(keyPath);
            }
            return DefaultImplementation.valueForKeyPath(object, keyPath);
        }

        public static void takeValueForKeyPath(Object object, Object value, String keyPath) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSKeyValueCodingAdditions) {
                ((NSKeyValueCodingAdditions)object).takeValueForKeyPath(value, keyPath);
            } else {
                DefaultImplementation.takeValueForKeyPath(object, value, keyPath);
            }
        }

        Utility() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }
    }
}

