/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation._NSKeyBindingGenerator;
import com.webobjects.foundation._NSReflectionUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NSKeyValueCoding {
    public static final Class<NSKeyValueCoding> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSKeyValueCoding.class);
    public static final Null NullValue = new Null();

    public Object valueForKey(String var1);

    public void takeValueForKey(Object var1, String var2);

    public static class DefaultImplementation {
        public static final Class<DefaultImplementation> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(DefaultImplementation.class);
        private static PluggableImplementation pluggableImplementation = new MapImplementation();
        private static _KeyBindingCreation._KeyBindingFactory _bindingFactory = new _ReflectionKeyBindingCreation();
        private static final _KeyBindingCache _keyGetBindings = new _KeyBindingCache();
        private static final _KeyBindingCache _keySetBindings = new _KeyBindingCache();
        private static final _KeyBindingCache _staticKeyGetBindings = new _KeyBindingCache();
        private static final _KeyBindingCache _staticKeySetBindings = new _KeyBindingCache();

        static {
            DefaultImplementation._initializeBindingFactory();
        }

        public static void _initializeBindingFactory() {
            if (NSProperties.booleanForKeyWithDefault("NSKVCBytecodeGenerationEnabled", false)) {
                DefaultImplementation._setBindingFactory(new _NSKeyBindingGenerator.BytecodeKeyBindingFactory());
            } else {
                DefaultImplementation._setBindingFactory(new _ReflectionKeyBindingCreation());
            }
        }

        public static void _setBindingFactory(_KeyBindingCreation._KeyBindingFactory bindingFactory) {
            _bindingFactory = bindingFactory;
            _keyGetBindings.clear();
            _keySetBindings.clear();
        }

        public static void setPluggableImplementation(PluggableImplementation value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            pluggableImplementation = value;
        }

        public static void _flushCaches() {
            _keyGetBindings.clear();
            _keySetBindings.clear();
        }

        public static void logBindingCacheSizing() {
            System.out.println("_keyGetBindings size: " + _keyGetBindings.size());
            System.out.println("_keySetBindings size: " + _keySetBindings.size());
        }

        static Object _valueForKey(Object object, String key) {
            _KeyBinding binding = object instanceof _KeyBindingCreation ? ((_KeyBindingCreation)object)._keyGetBindingForKey(key) : DefaultImplementation._keyGetBindingForKey(object, key);
            return binding.valueInObject(object);
        }

        public static Object valueForKey(Object object, String key) {
            if (key == null) {
                return null;
            }
            return pluggableImplementation.valueForKey(object, key);
        }

        static void _takeValueForKey(Object object, Object value, String key) {
            _KeyBinding binding = object instanceof _KeyBindingCreation ? ((_KeyBindingCreation)object)._keySetBindingForKey(key) : DefaultImplementation._keySetBindingForKey(object, key);
            binding.setValueInObject(value, object);
        }

        public static void takeValueForKey(Object object, Object value, String key) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            pluggableImplementation.takeValueForKey(object, value, key);
        }

        private static String _identityString(Object object) {
            return "<" + object.getClass().getName() + " 0x" + Integer.toHexString(System.identityHashCode(object)) + ">";
        }

        static Object _handleQueryWithUnboundKey(Object object, String key) {
            String capitalizedKey = _NSStringUtilities.capitalizedString(key);
            throw new UnknownKeyException(String.valueOf(DefaultImplementation._identityString(object)) + " valueForKey(): lookup of unknown key: '" + key + "'.\nThis class does not have an instance variable of the name " + key + " or _" + key + ", nor a method of the name " + key + ", _" + key + ", get" + capitalizedKey + ", or _get" + capitalizedKey, object, key);
        }

        public static Object handleQueryWithUnboundKey(Object object, String key) {
            return pluggableImplementation.handleQueryWithUnboundKey(object, key);
        }

        static void _handleTakeValueForUnboundKey(Object object, Object value, String key) {
            String capitalizedKey = _NSStringUtilities.capitalizedString(key);
            throw new UnknownKeyException(String.valueOf(DefaultImplementation._identityString(object)) + " takeValueForKey(): attempt to assign value to unknown key: '" + key + "'.\nThis class does not have an instance variable of the name " + key + " or _" + key + ", nor a method of the name set" + capitalizedKey + " or _set" + capitalizedKey, object, key);
        }

        public static void handleTakeValueForUnboundKey(Object object, Object value, String key) {
            pluggableImplementation.handleTakeValueForUnboundKey(object, value, key);
        }

        static void _unableToSetNullForKey(Object object, String key) {
            throw new IllegalArgumentException("KeyValueCoding: Failed to assign null to key '" + key + "' in object of class '" + object.getClass().getName() + "'.  If you want to handle assignments of null to properties of primitive types, implement the interface NSKeyValueCoding.ErrorHandling with 'public void unableToSetNullForKey(String key)' on your object class.");
        }

        public static void unableToSetNullForKey(Object object, String key) {
            pluggableImplementation.unableToSetNullForKey(object, key);
        }

        public static _KeyBinding _keyGetBindingForKey(Object object, String key) {
            Class<?> objectClass;
            boolean isStatic;
            _KeyBindingCache bindings = isStatic ? _staticKeyGetBindings : _keyGetBindings;
            _KeyBinding keyBinding = bindings.get(objectClass = (isStatic = object instanceof NSKeyValueCodingAdditions.Statics.ClassKey) ? ((NSKeyValueCodingAdditions.Statics.ClassKey)object).clazz() : object.getClass(), key);
            if (keyBinding == null) {
                _KeyBinding _KeyBinding2 = keyBinding = object instanceof _KeyBindingCreation ? ((_KeyBindingCreation)object)._createKeyGetBindingForKey(key) : DefaultImplementation._createKeyGetBindingForKey(object, key);
                if (keyBinding == null && !isStatic && (keyBinding = DefaultImplementation._keyGetBindingForKey(new NSKeyValueCodingAdditions.Statics.ClassKey(objectClass), key)) != null) {
                    return keyBinding;
                }
                if (keyBinding == null) {
                    keyBinding = new _KeyBinding(objectClass, key);
                }
                bindings.put(keyBinding);
            }
            return keyBinding;
        }

        public static _KeyBinding _keySetBindingForKey(Object object, String key) {
            Class<?> objectClass;
            boolean isStatic;
            _KeyBindingCache bindings = isStatic ? _staticKeySetBindings : _keySetBindings;
            _KeyBinding keyBinding = bindings.get(objectClass = (isStatic = object instanceof NSKeyValueCodingAdditions.Statics.ClassKey) ? ((NSKeyValueCodingAdditions.Statics.ClassKey)object).clazz() : object.getClass(), key);
            if (keyBinding == null) {
                _KeyBinding _KeyBinding2 = keyBinding = object instanceof _KeyBindingCreation ? ((_KeyBindingCreation)object)._createKeySetBindingForKey(key) : DefaultImplementation._createKeySetBindingForKey(object, key);
                if (keyBinding == null && !isStatic && (keyBinding = DefaultImplementation._keySetBindingForKey(new NSKeyValueCodingAdditions.Statics.ClassKey(objectClass), key)) != null) {
                    return keyBinding;
                }
                if (keyBinding == null) {
                    keyBinding = new _KeyBinding(objectClass, key);
                }
                bindings.put(keyBinding);
            }
            return keyBinding;
        }

        public static _KeyBinding _createKeyGetBindingForKey(Object object, String key) {
            return _bindingFactory._createKeyGetBindingForKey(object, key, _KeyBindingCreation._KeyBindingFactory._ValueForKeyLookupOrder);
        }

        public static _KeyBinding _createKeySetBindingForKey(Object object, String key) {
            return _bindingFactory._createKeySetBindingForKey(object, key, _KeyBindingCreation._KeyBindingFactory._ValueForKeyLookupOrder);
        }

        public static _KeyBinding _createKeyGetBindingForKey(Object object, String key, int[] lookupOrder) {
            return _bindingFactory._createKeyGetBindingForKey(object, key, lookupOrder);
        }

        public static _KeyBinding _createKeySetBindingForKey(Object object, String key, int[] lookupOrder) {
            return _bindingFactory._createKeySetBindingForKey(object, key, lookupOrder);
        }

        DefaultImplementation() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }
    }

    public static class DefaultPluggableImplementation
    implements PluggableImplementation {
        @Override
        public Object valueForKey(Object object, String key) {
            return DefaultImplementation._valueForKey(object, key);
        }

        @Override
        public void takeValueForKey(Object object, Object value, String key) {
            DefaultImplementation._takeValueForKey(object, value, key);
        }

        @Override
        public Object handleQueryWithUnboundKey(Object object, String key) {
            return DefaultImplementation._handleQueryWithUnboundKey(object, key);
        }

        @Override
        public void handleTakeValueForUnboundKey(Object object, Object value, String key) {
            DefaultImplementation._handleTakeValueForUnboundKey(object, value, key);
        }

        @Override
        public void unableToSetNullForKey(Object object, String key) {
            DefaultImplementation._unableToSetNullForKey(object, key);
        }
    }

    public static interface ErrorHandling {
        public static final Class<ErrorHandling> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(ErrorHandling.class);

        public Object handleQueryWithUnboundKey(String var1);

        public void handleTakeValueForUnboundKey(Object var1, String var2);

        public void unableToSetNullForKey(String var1);
    }

    public static class MapImplementation
    extends DefaultPluggableImplementation {
        public static final Class<MapImplementation> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(MapImplementation.class);

        @Override
        public Object valueForKey(Object object, String key) {
            if (!(object instanceof Map)) {
                return super.valueForKey(object, key);
            }
            if (key == null) {
                return null;
            }
            Map map = (Map)object;
            Object value = map.get(key);
            if (value == null) {
                if ("values".equals(key)) {
                    value = map.values();
                } else if ("keySet".equals(key)) {
                    value = map.keySet();
                } else {
                    if ("size".equals(key)) {
                        return _NSUtilities.IntegerForInt(map.size());
                    }
                    if ("entrySet".equals(key)) {
                        value = map.entrySet();
                    } else {
                        try {
                            value = super.valueForKey(object, key);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                }
            }
            return value;
        }

        @Override
        public void takeValueForKey(Object object, Object value, String key) {
            if (!(object instanceof Map)) {
                super.takeValueForKey(object, value, key);
                return;
            }
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            Map map = (Map)object;
            boolean exceptionThrown = false;
            try {
                super.takeValueForKey(object, value, key);
            }
            catch (Exception exception) {
                exceptionThrown = true;
            }
            if (exceptionThrown) {
                map.put(key, value);
            }
        }
    }

    public static final class Null
    implements Serializable,
    Cloneable,
    NSCoding {
        private static final long serialVersionUID = 8311844716729190443L;
        public static final Class<Null> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(Null.class);

        Null() {
        }

        public String toString() {
            return "<" + this.getClass().getName() + ">";
        }

        public Object clone() {
            return this;
        }

        @Override
        public Class<?> classForCoder() {
            return _CLASS;
        }

        public static Object decodeObject(NSCoder coder) {
            return NullValue;
        }

        @Override
        public void encodeWithCoder(NSCoder coder) {
        }

        Object readResolve() throws ObjectStreamException {
            return NullValue;
        }
    }

    public static interface PluggableImplementation {
        public Object valueForKey(Object var1, String var2);

        public void takeValueForKey(Object var1, Object var2, String var3);

        public Object handleQueryWithUnboundKey(Object var1, String var2);

        public void handleTakeValueForUnboundKey(Object var1, Object var2, String var3);

        public void unableToSetNullForKey(Object var1, String var2);
    }

    public static class UnknownKeyException
    extends RuntimeException {
        private static final long serialVersionUID = 1685186287717318279L;
        public static final Class<UnknownKeyException> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(UnknownKeyException.class);
        @Deprecated
        public static final String TargetObjectUserInfoKey = "NSTargetObjectUserInfoKey";
        @Deprecated
        public static final String UnknownUserInfoKey = "NSUnknownUserInfoKey";
        private NSDictionary<?, ?> _userInfo;
        private String _objectDescription;

        public UnknownKeyException(String message, Object object, String objectDescription, String key) {
            super(message);
            NSMutableDictionary dictionary = new NSMutableDictionary(2);
            if (object != null) {
                dictionary.setObjectForKey(object, TargetObjectUserInfoKey);
            }
            if (key != null) {
                dictionary.setObjectForKey(key, UnknownUserInfoKey);
            }
            this._userInfo = dictionary;
            this._objectDescription = objectDescription;
        }

        public UnknownKeyException(String message, Object object, String key) {
            this(message, object, null, key);
        }

        @Deprecated
        public UnknownKeyException(String message, NSDictionary<?, ?> userInfo) {
            super(message);
            this._userInfo = userInfo != null ? (NSDictionary)userInfo.clone() : NSDictionary.EmptyDictionary;
        }

        public Object object() {
            return this.userInfo().objectForKey(TargetObjectUserInfoKey);
        }

        public String key() {
            return (String)this.userInfo().objectForKey(UnknownUserInfoKey);
        }

        public String objectDescription() {
            return this._objectDescription == null ? String.valueOf(this.object()) : this._objectDescription;
        }

        @Deprecated
        public NSDictionary<?, ?> userInfo() {
            return this._userInfo;
        }

        @Override
        public String toString() {
            try {
                return String.valueOf(this.getClass().getName()) + ": '" + this.getMessage() + "' (object '" + this.objectDescription() + "', key '" + this.key() + "')";
            }
            catch (Throwable throwable) {
                return String.valueOf(this.getClass().getName()) + ": '" + this.getMessage() + "' (object of type " + (this.object() == null ? "null" : this.object().getClass().getSimpleName()) + ", key '" + this.key() + "')";
            }
        }
    }

    public static final class Utility {
        public static final Class<Utility> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(Utility.class);

        public static final <T> T nullValue() {
            return (T)NullValue;
        }

        public static Object valueForKey(Object object, String key) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSKeyValueCoding) {
                return ((NSKeyValueCoding)object).valueForKey(key);
            }
            return DefaultImplementation.valueForKey(object, key);
        }

        public static void takeValueForKey(Object object, Object value, String key) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSKeyValueCoding) {
                ((NSKeyValueCoding)object).takeValueForKey(value, key);
            } else {
                DefaultImplementation.takeValueForKey(object, value, key);
            }
        }

        public static Object handleQueryWithUnboundKey(Object object, String key) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof ErrorHandling) {
                return ((ErrorHandling)object).handleQueryWithUnboundKey(key);
            }
            return DefaultImplementation.handleQueryWithUnboundKey(object, key);
        }

        public static void handleTakeValueForUnboundKey(Object object, Object value, String key) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof ErrorHandling) {
                ((ErrorHandling)object).handleTakeValueForUnboundKey(value, key);
            } else {
                DefaultImplementation.handleTakeValueForUnboundKey(object, value, key);
            }
        }

        public static void unableToSetNullForKey(Object object, String key) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof ErrorHandling) {
                ((ErrorHandling)object).unableToSetNullForKey(key);
            } else {
                DefaultImplementation.unableToSetNullForKey(object, key);
            }
        }

        private Utility() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }
    }

    public static abstract class ValueAccessor {
        public static final Class<ValueAccessor> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(ValueAccessor.class);
        private static final Logger log = LoggerFactory.getLogger(ValueAccessor.class);
        private static final ConcurrentHashMap<String, ValueAccessor> _packageNameToValueAccessorMapTable = new ConcurrentHashMap(256);
        private static final String _PackageProtectedAccessorClassName = "KeyValueCodingProtectedAccessor";
        static final ValueAccessor _defaultValueAccessor = new ValueAccessor(){

            @Override
            public Object fieldValue(Object object, Field field) throws IllegalArgumentException, IllegalAccessException {
                return field.get(object);
            }

            @Override
            public void setFieldValue(Object object, Field field, Object value) throws IllegalArgumentException, IllegalAccessException {
                field.set(object, value);
            }

            @Override
            public Object methodValue(Object object, Method method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                return method.invoke(object, new Object[0]);
            }

            @Override
            public void setMethodValue(Object object, Method method, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                method.invoke(object, value);
            }

            public String toString() {
                return "<DEFAULT VALUE ACCESSOR>";
            }
        };

        public static void _flushCaches() {
            _packageNameToValueAccessorMapTable.clear();
        }

        public static void setProtectedAccessorForPackageNamed(ValueAccessor valueAccessor, String packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException("No package name specified");
            }
            if (valueAccessor == null) {
                throw new IllegalArgumentException("No value accessor specified for package " + packageName);
            }
            _packageNameToValueAccessorMapTable.put(packageName, valueAccessor);
        }

        public static ValueAccessor protectedAccessorForPackageNamed(String packageName) {
            ValueAccessor valueAccessor = _packageNameToValueAccessorMapTable.get(packageName);
            if (valueAccessor == null) {
                Class<?> valueAccessorClass;
                String valueAccessorClassName = _PackageProtectedAccessorClassName;
                if (packageName.length() > 0) {
                    StringBuilder temp = new StringBuilder(64);
                    temp.append(packageName);
                    temp.append(".");
                    temp.append(valueAccessorClassName);
                    valueAccessorClassName = temp.toString();
                }
                try {
                    valueAccessorClass = Class.forName(valueAccessorClassName);
                    if (!ValueAccessor.class.isAssignableFrom(valueAccessorClass)) {
                        valueAccessorClass = null;
                    }
                }
                catch (ClassNotFoundException exception) {
                    log.debug("An exception occurred", (Throwable)exception);
                    valueAccessorClass = null;
                }
                catch (ClassFormatError exception) {
                    log.debug("An exception occurred", (Throwable)exception);
                    valueAccessorClass = null;
                }
                catch (SecurityException exception) {
                    log.debug("An exception occurred", (Throwable)exception);
                    valueAccessorClass = null;
                }
                if (valueAccessorClass != null) {
                    try {
                        valueAccessor = (ValueAccessor)valueAccessorClass.newInstance();
                    }
                    catch (Throwable throwable) {
                        throw new IllegalStateException("Cannot instantiate protected accessor of class " + valueAccessorClassName + " (make sure that it is a subclass of NSKeyValueCoding.ValueAccessor and has a constructor without arguments)");
                    }
                }
                if (valueAccessor == null) {
                    valueAccessor = _defaultValueAccessor;
                }
                _packageNameToValueAccessorMapTable.put(packageName, valueAccessor);
            }
            return valueAccessor == _defaultValueAccessor ? null : valueAccessor;
        }

        public static void removeProtectedAccessorForPackageNamed(String packageName) {
            if (packageName != null) {
                _packageNameToValueAccessorMapTable.put(packageName, _defaultValueAccessor);
            }
        }

        public static ValueAccessor _valueAccessorForClass(Class<?> objectClass) {
            String className = objectClass.getName();
            int index = className.lastIndexOf(46);
            String packageName = index > 0 ? className.substring(0, index) : "";
            return ValueAccessor.protectedAccessorForPackageNamed(packageName);
        }

        public abstract Object fieldValue(Object var1, Field var2) throws IllegalArgumentException, IllegalAccessException;

        public abstract void setFieldValue(Object var1, Field var2, Object var3) throws IllegalArgumentException, IllegalAccessException;

        public abstract Object methodValue(Object var1, Method var2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public abstract void setMethodValue(Object var1, Method var2, Object var3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;
    }

    public static class _BooleanFieldBinding
    extends _FieldBinding {
        public _BooleanFieldBinding(Class<?> targetClass, String key, Field field, ValueAccessor valueAccessor) {
            super(targetClass, key, field, valueAccessor);
        }

        @Override
        public Class<?> valueType() {
            return _NSUtilities._BooleanClass;
        }

        @Override
        public void setValueInObject(Object value, Object object) {
            super.setValueInObject(this._convertValueIntoBoolean(value), object);
        }
    }

    public static class _BooleanMethodBinding
    extends _MethodBinding {
        public _BooleanMethodBinding(Class<?> targetClass, String key, Method method, ValueAccessor valueAccessor) {
            super(targetClass, key, method, valueAccessor);
        }

        @Override
        public Class<?> valueType() {
            return _NSUtilities._BooleanClass;
        }

        @Override
        public void setValueInObject(Object value, Object object) {
            super.setValueInObject(this._convertValueIntoBoolean(value), object);
        }
    }

    public static class _FieldBinding
    extends _KeyBinding {
        protected Field _field;
        protected boolean _isScalar;
        protected ValueAccessor _valueAccessor;

        public _FieldBinding(Class<?> targetClass, String key, Field field, ValueAccessor valueAccessor) {
            super(targetClass, key);
            this._field = field;
            this._isScalar = this._field.getType().isPrimitive();
            ValueAccessor valueAccessor2 = this._valueAccessor = valueAccessor != null ? valueAccessor : ValueAccessor._defaultValueAccessor;
            if (Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
        }

        @Override
        public Class<?> valueType() {
            return this._field.getType();
        }

        @Override
        public boolean isScalarProperty() {
            return this._isScalar;
        }

        @Override
        public Object valueInObject(Object object) {
            try {
                return this._valueAccessor.fieldValue(object, this._field);
            }
            catch (IllegalAccessException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
        }

        protected void _setValidatedValueInObject(Object value, Object object) throws IllegalAccessException {
            this._valueAccessor.setFieldValue(object, this._field, value);
        }

        @Override
        public void setValueInObject(Object value, Object object) {
            if (value == null && this._isScalar) {
                this._unableToSetNull(object);
            } else {
                try {
                    this._setValidatedValueInObject(value, object);
                }
                catch (IllegalAccessException exception) {
                    throw new NSForwardException(exception, "Could not set the field \"" + this._field.getName() + "\" on an object of type " + object.getClass().getName() + ".");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("While trying to set the field \"" + this._field.getName() + "\" on an object of type " + object.getClass().getName() + " we expected a " + this._field.getType().getName() + " but received a " + (value == null ? "null" : value.getClass().getName()) + " with a value of " + value + ". This often happens if you forget to use a formatter.");
                }
            }
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", field = " + (this._field != null ? this._field.toString() : "<NULL>") + ", is scalar = " + this._isScalar + ", value accessor = " + (this._valueAccessor != null ? this._valueAccessor.toString() : "<NULL>");
        }
    }

    public static class _ForwardingBinding
    extends _KeyBinding {
        public _ForwardingBinding(Class<?> targetClass, String key) {
            super(targetClass, key);
        }

        @Override
        public Object valueInObject(Object object) {
            return ((NSKeyValueCoding)object).valueForKey(this._key);
        }

        @Override
        public void setValueInObject(Object value, Object object) {
            ((NSKeyValueCoding)object).takeValueForKey(value, this._key);
        }
    }

    public static class _KeyBinding {
        public static final Class<_KeyBinding> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(_KeyBinding.class);
        private static final Logger log = LoggerFactory.getLogger(_KeyBinding.class);
        protected static final Short _shortFalse = 0;
        protected static final Short _shortTrue = 1;
        protected Class<?> _targetClass;
        protected String _key;
        private int _hashCode;

        public static int _hash(Class<?> targetClass, String key) {
            return targetClass == null || key == null ? 0 : 31 * targetClass.hashCode() + key.hashCode();
        }

        public _KeyBinding(Class<?> targetClass, String key) {
            this._targetClass = targetClass;
            this._key = key;
            this._hashCode = _KeyBinding._hash(targetClass, key);
        }

        public final Class<?> targetClass() {
            return this._targetClass;
        }

        public final String key() {
            return this._key;
        }

        public final int hashCode() {
            return this._hashCode;
        }

        public final boolean isEqualToKeyBinding(_KeyBinding otherKeyBinding) {
            if (otherKeyBinding == null) {
                return false;
            }
            if (otherKeyBinding == this) {
                return true;
            }
            return this._targetClass == otherKeyBinding._targetClass && (this._key == otherKeyBinding._key || this._key.equals(otherKeyBinding._key));
        }

        public final boolean equals(Class<?> targetClass, String key) {
            if (targetClass == null || key == null) {
                return false;
            }
            return this._targetClass == targetClass && (this._key == key || this._key.equals(key));
        }

        public final boolean equals(Object object) {
            return object instanceof _KeyBinding ? this.isEqualToKeyBinding((_KeyBinding)object) : false;
        }

        public Class<?> valueType() {
            return _NSUtilities._ObjectClass;
        }

        public boolean isScalarProperty() {
            return false;
        }

        public Object valueInObject(Object object) {
            return Utility.handleQueryWithUnboundKey(object, this._key);
        }

        public void setValueInObject(Object value, Object object) {
            Utility.handleTakeValueForUnboundKey(object, value, this._key);
        }

        protected void _unableToSetNull(Object object) {
            Utility.unableToSetNullForKey(object, this._key);
        }

        protected <T> Constructor<T> _numberStringConstructorForValueClass(Class<T> valueClass) {
            Class<T> aValueClass = _NSUtilities.classObjectForClass(valueClass);
            if (_NSUtilities._isClassANumber(aValueClass)) {
                try {
                    return _NSUtilities.classObjectForClass(aValueClass).getConstructor(_NSUtilities._StringClassArray);
                }
                catch (NoSuchMethodException otherException) {
                    log.debug("Exception while getting constructor: {}", (Object)aValueClass.getName(), (Object)otherException);
                }
            }
            return null;
        }

        protected Object _convertValueIntoBoolean(Object value) {
            if (value instanceof Number) {
                return _NSUtilities.convertNumberIntoBooleanValue((Number)value);
            }
            return value;
        }

        protected Object _convertValueIntoNumberOfValueType(Object value, Class<?> numberType) {
            if (value instanceof Number) {
                return _NSUtilities.convertNumberIntoCompatibleValue((Number)value, numberType);
            }
            if (value instanceof Boolean) {
                return _NSUtilities.convertBooleanIntoCompatibleNumberValue((Boolean)value, numberType);
            }
            return value;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ": target class = " + (this._targetClass != null ? this._targetClass.getName() : "<NULL>") + ", key = " + (this._key != null ? this._key : "<NULL>");
        }
    }

    public static class _KeyBindingCache {
        private Map<_KeyBinding, _KeyBinding> _store;
        private _KeyBinding[] _storeCache = new _KeyBinding[4096];

        public _KeyBindingCache() {
            this(256);
        }

        public _KeyBindingCache(int size) {
            this._store = new ConcurrentHashMap<_KeyBinding, _KeyBinding>(size);
        }

        public void clear() {
            this._store.clear();
            this._storeCache = new _KeyBinding[4096];
        }

        public _KeyBinding get(_KeyBinding binding) {
            return this._store.get(binding);
        }

        public _KeyBinding get(Class<?> targetClass, String key) {
            _KeyBinding binding = this._storeCache[_KeyBinding._hash(targetClass, key) & 0xFFF];
            if (binding != null && binding.equals(targetClass, key)) {
                return binding;
            }
            binding = this._store.get(new _KeyBinding(targetClass, key));
            if (binding != null) {
                this._storeCache[binding.hashCode() & 0xFFF] = binding;
            }
            return binding;
        }

        public void put(_KeyBinding binding) {
            this._store.put(binding, binding);
            this._storeCache[binding.hashCode() & 0xFFF] = binding;
        }

        public int size() {
            return this._store.size();
        }
    }

    public static interface _KeyBindingCreation {
        public static final Class<_KeyBindingCreation> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(_KeyBindingCreation.class);

        public _KeyBinding _createKeyGetBindingForKey(String var1);

        public _KeyBinding _createKeySetBindingForKey(String var1);

        public _KeyBinding _keyGetBindingForKey(String var1);

        public _KeyBinding _keySetBindingForKey(String var1);

        public static interface _KeyBindingFactory {
            public static final int MethodLookup = 0;
            public static final int UnderbarMethodLookup = 1;
            public static final int FieldLookup = 2;
            public static final int UnderbarFieldLookup = 3;
            public static final int OtherStorageLookup = 4;
            public static final int[] _ValueForKeyLookupOrder;
            public static final int[] _StoredValueForKeyLookupOrder;

            static {
                int[] nArray = new int[5];
                nArray[1] = 1;
                nArray[2] = 3;
                nArray[3] = 2;
                nArray[4] = 4;
                _ValueForKeyLookupOrder = nArray;
                int[] nArray2 = new int[5];
                nArray2[0] = 1;
                nArray2[1] = 3;
                nArray2[2] = 2;
                nArray2[3] = 4;
                _StoredValueForKeyLookupOrder = nArray2;
            }

            public _KeyBinding _createKeyGetBindingForKey(Object var1, String var2, int[] var3);

            public _KeyBinding _createKeySetBindingForKey(Object var1, String var2, int[] var3);

            public static interface Callback {
                public _KeyBinding _fieldKeyBinding(String var1, String var2);

                public _KeyBinding _methodKeyGetBinding(String var1, String var2);

                public _KeyBinding _methodKeySetBinding(String var1, String var2);

                public _KeyBinding _otherStorageBinding(String var1);
            }

            public static class _BindingStorage {
                _KeyBinding[] _keyGetBindings = new _KeyBinding[4];
                _KeyBinding[] _keySetBindings = new _KeyBinding[4];

                public String toString() {
                    int i;
                    StringBuilder aLog = new StringBuilder();
                    aLog.append("( ");
                    if (this._keyGetBindings != null) {
                        aLog.append("Key Get Bindings: ");
                        aLog.append("( ");
                        i = 0;
                        while (i < this._keyGetBindings.length) {
                            if (i > 0) {
                                aLog.append(",");
                            }
                            aLog.append(this._keyGetBindings[i]);
                            ++i;
                        }
                        aLog.append(")");
                    } else {
                        aLog.append("NULL");
                    }
                    aLog.append(", ");
                    if (this._keyGetBindings != null) {
                        aLog.append("Key Set Bindings: ");
                        aLog.append("( ");
                        i = 0;
                        while (i < this._keySetBindings.length) {
                            if (i > 0) {
                                aLog.append(",");
                            }
                            aLog.append(this._keySetBindings[i]);
                            ++i;
                        }
                        aLog.append(")");
                    } else {
                        aLog.append("NULL");
                    }
                    aLog.append(")");
                    return aLog.toString();
                }
            }
        }
    }

    public static class _MethodBinding
    extends _KeyBinding {
        protected Method _method;
        protected boolean _isScalar;
        protected ValueAccessor _valueAccessor;
        protected Class<?> _valueType;

        public _MethodBinding(Class<?> targetClass, String key, Method method, ValueAccessor valueAccessor) {
            super(targetClass, key);
            Class<?>[] types = method.getParameterTypes();
            this._method = method;
            if (Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            this._isScalar = types.length == 1 && types[0].isPrimitive();
            this._valueType = types.length == 1 ? types[0] : method.getReturnType();
            this._valueAccessor = valueAccessor != null ? valueAccessor : ValueAccessor._defaultValueAccessor;
        }

        @Override
        public Class<?> valueType() {
            return this._valueType;
        }

        @Override
        public boolean isScalarProperty() {
            return this._isScalar;
        }

        private RuntimeException throwMethodExceptionWithDescription(Throwable exception, Object object, Object newValue, boolean isSetMethod) {
            StringBuilder message = new StringBuilder(64);
            if (isSetMethod) {
                message.append("While trying to invoke the set method \"");
            } else {
                message.append("While trying to invoke the get method \"");
            }
            message.append(this._method.toString());
            message.append("\" on an object of type ");
            if (object == null) {
                message.append("null");
            } else {
                message.append(object.getClass().getName());
            }
            message.append(" we received ");
            if (isSetMethod) {
                message.append("an argument of type ");
                if (newValue == null) {
                    message.append("null");
                } else {
                    message.append(newValue.getClass().getName());
                }
            } else {
                message.append("no arguments");
            }
            message.append(". This often happens if you forget to use a formatter.");
            return new IllegalArgumentException(new String(message));
        }

        @Override
        public Object valueInObject(Object object) {
            try {
                return this._valueAccessor.methodValue(object, this._method);
            }
            catch (IllegalArgumentException exception) {
                throw this.throwMethodExceptionWithDescription(exception, object, null, false);
            }
            catch (IllegalAccessException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
            catch (InvocationTargetException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
        }

        @Override
        public void setValueInObject(Object value, Object object) {
            if (value == null && this._isScalar) {
                this._unableToSetNull(object);
            } else {
                try {
                    this._valueAccessor.setMethodValue(object, this._method, value);
                }
                catch (IllegalArgumentException exception) {
                    throw this.throwMethodExceptionWithDescription(exception, object, value, true);
                }
                catch (IllegalAccessException exception) {
                    throw NSForwardException._runtimeExceptionForThrowable(exception);
                }
                catch (InvocationTargetException exception) {
                    throw NSForwardException._runtimeExceptionForThrowable(exception);
                }
            }
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", method = " + (this._method != null ? this._method.toString() : "<NULL>") + ", is scalar = " + this._isScalar + ", value accessor = " + (this._valueAccessor != null ? this._valueAccessor.toString() : "<NULL>");
        }
    }

    public static class _NumberFieldBinding
    extends _FieldBinding {
        protected Class<?> _valueClass;

        public _NumberFieldBinding(Class<?> targetClass, String key, Field field, Class<?> valueClass, ValueAccessor valueAccessor) {
            super(targetClass, key, field, valueAccessor);
            this._valueClass = valueClass;
        }

        @Override
        public Class<?> valueType() {
            return this._valueClass;
        }

        @Override
        public void setValueInObject(Object value, Object object) {
            super.setValueInObject(this._convertValueIntoNumberOfValueType(value, this._valueClass), object);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", value class = " + (this._valueClass != null ? this._valueClass.getName() : "<NULL>");
        }
    }

    public static class _NumberMethodBinding
    extends _MethodBinding {
        protected Class<?> _valueClass;

        public _NumberMethodBinding(Class<?> targetClass, String key, Method method, Class<?> valueClass, ValueAccessor valueAccessor) {
            super(targetClass, key, method, valueAccessor);
            this._valueClass = valueClass;
        }

        @Override
        public Class<?> valueType() {
            return this._valueClass;
        }

        @Override
        public void setValueInObject(Object value, Object object) {
            super.setValueInObject(this._convertValueIntoNumberOfValueType(value, this._valueClass), object);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", value class = " + (this._valueClass != null ? this._valueClass.getName() : "<NULL>");
        }
    }

    public static class _ReflectionKeyBindingCreation
    implements _KeyBindingCreation._KeyBindingFactory {
        public static final Class<_ReflectionKeyBindingCreation> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(_ReflectionKeyBindingCreation.class);
        private static final _KeyBinding _NotAvailableIndicator = new _KeyBinding(null, null);
        private static final ConcurrentHashMap<_KeyBinding, _KeyBindingCreation._KeyBindingFactory._BindingStorage> _bindingStorageMapTable = new ConcurrentHashMap(256);
        private static final ConcurrentHashMap<_KeyBinding, _KeyBindingCreation._KeyBindingFactory._BindingStorage> _staticBindingStorageMapTable = new ConcurrentHashMap(256);

        public static void _flushCaches() {
            _bindingStorageMapTable.clear();
            _staticBindingStorageMapTable.clear();
        }

        public static boolean _canAccessFieldsDirectlyForClass(Class<?> objectClass) {
            return _NSReflectionUtilities._staticBooleanMethodValue("canAccessFieldsDirectly", null, null, objectClass, _CLASS, true);
        }

        public static _KeyBinding _fieldKeyBinding(Object object, String key, String fieldName) {
            ValueAccessor valueAccessor;
            boolean publicFieldOnly;
            boolean isStatic = object instanceof NSKeyValueCodingAdditions.Statics.ClassKey;
            Class<?> objectClass = isStatic ? ((NSKeyValueCodingAdditions.Statics.ClassKey)object).clazz() : object.getClass();
            Field field = _NSReflectionUtilities._fieldForClass(objectClass, fieldName, publicFieldOnly = (valueAccessor = ValueAccessor._valueAccessorForClass(objectClass)) == null, isStatic);
            if (field != null) {
                Class<?> valueType = field.getType();
                if (valueType == Boolean.TYPE) {
                    return new _primitivebooleanFieldBinding(objectClass, key, field, valueAccessor);
                }
                Class<?> valueClass = _NSUtilities.classObjectForClass(valueType);
                if (_NSUtilities._isClassANumber(valueClass)) {
                    return new _NumberFieldBinding(objectClass, key, field, valueClass, valueAccessor);
                }
                if (_NSUtilities._isClassABoolean(valueClass)) {
                    return new _BooleanFieldBinding(objectClass, key, field, valueAccessor);
                }
                return new _FieldBinding(objectClass, key, field, valueAccessor);
            }
            return null;
        }

        public static _KeyBinding _methodKeyGetBinding(Object object, String key, String methodName) {
            ValueAccessor valueAccessor;
            boolean publicMethodOnly;
            boolean isStatic = object instanceof NSKeyValueCodingAdditions.Statics.ClassKey;
            Class<?> objectClass = isStatic ? ((NSKeyValueCodingAdditions.Statics.ClassKey)object).clazz() : object.getClass();
            Method method = _NSReflectionUtilities._methodForClass(objectClass, methodName, null, publicMethodOnly = (valueAccessor = ValueAccessor._valueAccessorForClass(objectClass)) == null, isStatic);
            if (method != null) {
                Class<?> valueType = method.getReturnType();
                if (valueType == Boolean.TYPE) {
                    return new _primitivebooleanMethodBinding(objectClass, key, method, valueAccessor);
                }
                Class<?> valueClass = _NSUtilities.classObjectForClass(valueType);
                if (_NSUtilities._isClassANumber(valueClass)) {
                    return new _NumberMethodBinding(objectClass, key, method, valueClass, valueAccessor);
                }
                if (_NSUtilities._isClassABoolean(valueClass)) {
                    return new _BooleanMethodBinding(objectClass, key, method, valueAccessor);
                }
                return new _MethodBinding(objectClass, key, method, valueAccessor);
            }
            return null;
        }

        public static _KeyBinding _methodKeySetBinding(Object object, String key, String methodName) {
            ValueAccessor valueAccessor;
            boolean publicMethodOnly;
            boolean isStatic = object instanceof NSKeyValueCodingAdditions.Statics.ClassKey;
            Class<?> objectClass = isStatic ? ((NSKeyValueCodingAdditions.Statics.ClassKey)object).clazz() : object.getClass();
            Method method = _NSReflectionUtilities._methodWithOneArgumentOfUnknownType(objectClass, methodName, key, publicMethodOnly = (valueAccessor = ValueAccessor._valueAccessorForClass(objectClass)) == null, false, objectClass, true, isStatic);
            if (method != null) {
                Class<?> valueType = method.getParameterTypes()[0];
                if (valueType == Boolean.TYPE) {
                    return new _primitivebooleanMethodBinding(objectClass, key, method, valueAccessor);
                }
                Class<?> valueClass = _NSUtilities.classObjectForClass(valueType);
                if (_NSUtilities._isClassANumber(valueClass)) {
                    return new _NumberMethodBinding(objectClass, key, method, valueClass, valueAccessor);
                }
                if (_NSUtilities._isClassABoolean(valueClass)) {
                    return new _BooleanMethodBinding(objectClass, key, method, valueAccessor);
                }
                return new _MethodBinding(objectClass, key, method, valueAccessor);
            }
            return null;
        }

        private _KeyBinding _createKeyBindingForKey(Object object, String key, int[] lookupOrder, boolean trueForSetAndFalseForGet) {
            _KeyBinding lookupBinding;
            if (key == null || key.length() == 0) {
                return null;
            }
            boolean isStatic = object instanceof NSKeyValueCodingAdditions.Statics.ClassKey;
            Class<?> objectClass = isStatic ? ((NSKeyValueCodingAdditions.Statics.ClassKey)object).clazz() : object.getClass();
            boolean canAccessFieldsDirectlyTestPerformed = false;
            boolean canAccessFieldsDirectly = false;
            ConcurrentHashMap<_KeyBinding, _KeyBindingCreation._KeyBindingFactory._BindingStorage> storageMap = isStatic ? _staticBindingStorageMapTable : _bindingStorageMapTable;
            _KeyBindingCreation._KeyBindingFactory._BindingStorage bindingStorage = (_KeyBindingCreation._KeyBindingFactory._BindingStorage)storageMap.get(lookupBinding = new _KeyBinding(objectClass, key));
            if (bindingStorage == null) {
                bindingStorage = new _KeyBindingCreation._KeyBindingFactory._BindingStorage();
                storageMap.put(lookupBinding, bindingStorage);
            }
            Callback keyBindingCreationCallbackObject = object instanceof Callback ? (Callback)object : null;
            _KeyBinding[] keyBindings = trueForSetAndFalseForGet ? bindingStorage._keySetBindings : bindingStorage._keyGetBindings;
            int i = 0;
            while (i < lookupOrder.length) {
                _KeyBinding keyBinding;
                int lookup = lookupOrder[i];
                _KeyBinding _KeyBinding2 = keyBinding = lookup >= 0 && lookup <= 3 ? keyBindings[lookup] : null;
                if (keyBinding == null) {
                    switch (lookup) {
                        case 0: {
                            StringBuilder methodNameBuffer = new StringBuilder(key.length() + 3);
                            methodNameBuffer.append(trueForSetAndFalseForGet ? "set" : "get");
                            methodNameBuffer.append(Character.toUpperCase(key.charAt(0)));
                            methodNameBuffer.append(key.substring(1));
                            String methodName = methodNameBuffer.toString();
                            if (trueForSetAndFalseForGet) {
                                keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeySetBinding(key, methodName) : _ReflectionKeyBindingCreation._methodKeySetBinding(object, key, methodName);
                                break;
                            }
                            _KeyBinding _KeyBinding3 = keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeyGetBinding(key, methodName) : _ReflectionKeyBindingCreation._methodKeyGetBinding(object, key, methodName);
                            if (keyBinding == null) {
                                _KeyBinding _KeyBinding4 = keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeyGetBinding(key, key) : _ReflectionKeyBindingCreation._methodKeyGetBinding(object, key, key);
                            }
                            if (keyBinding != null) break;
                            methodNameBuffer.setLength(0);
                            methodNameBuffer.append("is");
                            methodNameBuffer.append(Character.toUpperCase(key.charAt(0)));
                            methodNameBuffer.append(key.substring(1));
                            methodName = new String(methodNameBuffer);
                            keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeyGetBinding(key, methodName) : _ReflectionKeyBindingCreation._methodKeyGetBinding(object, key, methodName);
                            break;
                        }
                        case 1: {
                            StringBuilder underbarMethodNameBuffer = new StringBuilder(key.length() + 4);
                            underbarMethodNameBuffer.append(trueForSetAndFalseForGet ? "_set" : "_get");
                            underbarMethodNameBuffer.append(Character.toUpperCase(key.charAt(0)));
                            underbarMethodNameBuffer.append(key.substring(1));
                            String underbarMethodName = new String(underbarMethodNameBuffer);
                            if (trueForSetAndFalseForGet) {
                                keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeySetBinding(key, underbarMethodName) : _ReflectionKeyBindingCreation._methodKeySetBinding(object, key, underbarMethodName);
                                break;
                            }
                            _KeyBinding _KeyBinding5 = keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeyGetBinding(key, underbarMethodName) : _ReflectionKeyBindingCreation._methodKeyGetBinding(object, key, underbarMethodName);
                            if (keyBinding == null) {
                                underbarMethodNameBuffer.setLength(0);
                                underbarMethodNameBuffer.append("_");
                                underbarMethodNameBuffer.append(key);
                                underbarMethodName = new String(underbarMethodNameBuffer);
                                _KeyBinding _KeyBinding6 = keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeyGetBinding(key, underbarMethodName) : _ReflectionKeyBindingCreation._methodKeyGetBinding(object, key, underbarMethodName);
                            }
                            if (keyBinding != null) break;
                            underbarMethodNameBuffer.setLength(0);
                            underbarMethodNameBuffer.append("_is");
                            underbarMethodNameBuffer.append(Character.toUpperCase(key.charAt(0)));
                            underbarMethodNameBuffer.append(key.substring(1));
                            underbarMethodName = new String(underbarMethodNameBuffer);
                            keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._methodKeyGetBinding(key, underbarMethodName) : _ReflectionKeyBindingCreation._methodKeyGetBinding(object, key, underbarMethodName);
                            break;
                        }
                        case 2: {
                            if (!canAccessFieldsDirectlyTestPerformed) {
                                canAccessFieldsDirectlyTestPerformed = true;
                                canAccessFieldsDirectly = _ReflectionKeyBindingCreation._canAccessFieldsDirectlyForClass(objectClass);
                            }
                            if (!canAccessFieldsDirectly) break;
                            _KeyBinding _KeyBinding7 = keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._fieldKeyBinding(key, key) : _ReflectionKeyBindingCreation._fieldKeyBinding(object, key, key);
                            if (keyBinding != null) break;
                            StringBuilder fieldNameBuffer = new StringBuilder(key.length() + 2);
                            fieldNameBuffer.append("is");
                            fieldNameBuffer.append(Character.toUpperCase(key.charAt(0)));
                            fieldNameBuffer.append(key.substring(1));
                            String fieldName = new String(fieldNameBuffer);
                            keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._fieldKeyBinding(key, fieldName) : _ReflectionKeyBindingCreation._fieldKeyBinding(object, key, fieldName);
                            break;
                        }
                        case 3: {
                            if (!canAccessFieldsDirectlyTestPerformed) {
                                canAccessFieldsDirectlyTestPerformed = true;
                                canAccessFieldsDirectly = _ReflectionKeyBindingCreation._canAccessFieldsDirectlyForClass(objectClass);
                            }
                            if (!canAccessFieldsDirectly) break;
                            StringBuilder underbarFieldNameBuffer = new StringBuilder(key.length() + 3);
                            underbarFieldNameBuffer.append("_");
                            underbarFieldNameBuffer.append(key);
                            String underbarFieldName = new String(underbarFieldNameBuffer);
                            _KeyBinding _KeyBinding8 = keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._fieldKeyBinding(key, underbarFieldName) : _ReflectionKeyBindingCreation._fieldKeyBinding(object, key, underbarFieldName);
                            if (keyBinding != null) break;
                            underbarFieldNameBuffer.setLength(0);
                            underbarFieldNameBuffer.append("_is");
                            underbarFieldNameBuffer.append(Character.toUpperCase(key.charAt(0)));
                            underbarFieldNameBuffer.append(key.substring(1));
                            underbarFieldName = new String(underbarFieldNameBuffer);
                            keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._fieldKeyBinding(key, underbarFieldName) : _ReflectionKeyBindingCreation._fieldKeyBinding(object, key, underbarFieldName);
                            break;
                        }
                        case 4: {
                            _KeyBinding _KeyBinding9 = keyBinding = keyBindingCreationCallbackObject != null ? keyBindingCreationCallbackObject._otherStorageBinding(key) : null;
                        }
                    }
                    if (keyBinding == null) {
                        keyBinding = _NotAvailableIndicator;
                    }
                    if (lookup == 2 || lookup == 3) {
                        bindingStorage._keySetBindings[lookup] = bindingStorage._keyGetBindings[lookup] = keyBinding;
                    } else if (lookup == 0 || lookup == 1) {
                        keyBindings[lookup] = keyBinding;
                    }
                }
                if (keyBinding != null && keyBinding != _NotAvailableIndicator) {
                    return keyBinding;
                }
                ++i;
            }
            return null;
        }

        @Override
        public _KeyBinding _createKeyGetBindingForKey(Object object, String key, int[] lookupOrder) {
            return this._createKeyBindingForKey(object, key, lookupOrder, false);
        }

        @Override
        public _KeyBinding _createKeySetBindingForKey(Object object, String key, int[] lookupOrder) {
            return this._createKeyBindingForKey(object, key, lookupOrder, true);
        }

        public static interface Callback
        extends _KeyBindingCreation._KeyBindingFactory.Callback {
        }
    }

    public static class _primitivebooleanFieldBinding
    extends _BooleanFieldBinding {
        public _primitivebooleanFieldBinding(Class<?> targetClass, String key, Field field, ValueAccessor valueAccessor) {
            super(targetClass, key, field, valueAccessor);
        }

        @Override
        public Object valueInObject(Object object) {
            return (Boolean)super.valueInObject(object) != false ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class _primitivebooleanMethodBinding
    extends _BooleanMethodBinding {
        public _primitivebooleanMethodBinding(Class<?> targetClass, String key, Method method, ValueAccessor valueAccessor) {
            super(targetClass, key, method, valueAccessor);
        }

        @Override
        public Object valueInObject(Object object) {
            return (Boolean)super.valueInObject(object) != false ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

