/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableIndexSet;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSRange;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public class NSIndexSet
implements Iterable<Integer> {
    protected boolean _isEmpty;
    protected boolean _hasSingleRange;
    protected NSRange _singleRange;
    protected int _capacity;
    protected int _rangeCount;
    protected int _integerCount;
    protected int _cachedIndexValue;
    protected int _cachedRangeIndex;
    protected int _cachedRangeOffset;
    protected AtomicReference<Thread> _cacheOwner;
    protected NSRange[] _ranges;

    protected static final int GET_CAPACITY(NSIndexSet indexSet) {
        if (indexSet._hasSingleRange) {
            return 1;
        }
        return indexSet._capacity;
    }

    protected static final int GET_RANGE_COUNT(NSIndexSet indexSet) {
        if (indexSet._isEmpty) {
            return 0;
        }
        if (indexSet._hasSingleRange) {
            return 1;
        }
        return indexSet._rangeCount;
    }

    protected static final int GET_INTEGER_COUNT(NSIndexSet indexSet) {
        if (indexSet._isEmpty) {
            return 0;
        }
        if (indexSet._hasSingleRange) {
            return indexSet._singleRange.length();
        }
        return indexSet._integerCount;
    }

    protected static final NSRange[] RANGES(NSIndexSet indexSet) {
        if (indexSet._hasSingleRange) {
            return new NSRange[]{indexSet._singleRange};
        }
        return indexSet._ranges;
    }

    protected void _init() {
        this._isEmpty = true;
        this._hasSingleRange = true;
        this._cacheOwner = new AtomicReference();
    }

    public NSIndexSet() {
        this(new NSRange(0, 0));
    }

    public NSIndexSet(int value) {
        this(new NSRange(value, 1));
    }

    public NSIndexSet(NSRange range) {
        this._init();
        if (range.length() > 0) {
            this._isEmpty = false;
            this._singleRange = range.getClass() == NSRange.class ? range : new NSRange(range);
        }
    }

    protected void _setContentToContentFromIndexSet(NSIndexSet indexSet) {
        if (indexSet != null) {
            Class<?> indexSetClass = indexSet.getClass();
            if (indexSetClass == NSIndexSet.class || indexSetClass == NSMutableIndexSet.class) {
                this._isEmpty = true;
                this._hasSingleRange = true;
                if (indexSet._isEmpty) {
                    return;
                }
                if (indexSet._hasSingleRange) {
                    this._singleRange = indexSet._singleRange;
                    this._isEmpty = false;
                } else {
                    this._isEmpty = false;
                    int count = NSIndexSet.GET_RANGE_COUNT(indexSet);
                    this._hasSingleRange = false;
                    this._ranges = new NSRange[count];
                    this._cacheOwner.set(null);
                    this._capacity = count;
                    this._rangeCount = count;
                    this._integerCount = 0;
                    System.arraycopy(NSIndexSet.RANGES(indexSet), 0, this._ranges, 0, count);
                    NSRange[] nSRangeArray = this._ranges;
                    int n = this._ranges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        NSRange range = nSRangeArray[n2];
                        this._integerCount += range.length();
                        ++n2;
                    }
                }
            } else {
                NSMutableIndexSet temporaryIndexSet = new NSMutableIndexSet();
                temporaryIndexSet.addIndexes(indexSet);
                this._setContentToContentFromIndexSet(temporaryIndexSet);
            }
        }
    }

    public NSIndexSet(NSIndexSet indexSet) {
        this._init();
        this._setContentToContentFromIndexSet(indexSet);
    }

    protected static NSArray<NSRange> _NSGroupIndexesIntoSimpleRanges(int[] indexList) {
        NSMutableArray<NSRange> ranges = new NSMutableArray<NSRange>();
        int currentRange_location = 0;
        int currentRange_length = 0;
        int i = 0;
        while (i < indexList.length) {
            int currentIndex = indexList[i];
            if (currentRange_location + currentRange_length == currentIndex) {
                ++currentRange_length;
            } else {
                if (currentRange_length > 0) {
                    ranges.addObject(new NSRange(currentRange_location, currentRange_length));
                }
                currentRange_location = currentIndex;
                currentRange_length = 1;
            }
            ++i;
        }
        if (currentRange_length > 0) {
            ranges.addObject(new NSRange(currentRange_location, currentRange_length));
        }
        return ranges;
    }

    public NSIndexSet(int[] indexList) {
        NSArray<NSRange> ranges = NSIndexSet._NSGroupIndexesIntoSimpleRanges(indexList);
        NSMutableIndexSet indexSet = new NSMutableIndexSet();
        for (NSRange value : ranges) {
            indexSet.addIndexesInRange(value);
        }
        this._init();
        this._setContentToContentFromIndexSet(indexSet);
    }

    public Object clone() {
        return this.immutableClone();
    }

    public NSIndexSet immutableClone() {
        return this;
    }

    public NSMutableIndexSet mutableClone() {
        return new NSMutableIndexSet(this);
    }

    protected int _indexOfRangeContainingIndex(int value) {
        int count = NSIndexSet.GET_RANGE_COUNT(this);
        if (count > 0) {
            NSRange range;
            NSRange[] ranges = NSIndexSet.RANGES(this);
            int min = 0;
            int max = count - 1;
            while (min < max) {
                int idx = (max + min) / 2;
                range = ranges[idx];
                if (range.location() > value) {
                    max = idx;
                    continue;
                }
                if (range.location() + range.length() - 1 < value) {
                    min = idx + 1;
                    continue;
                }
                return idx;
            }
            range = ranges[min];
            if (range.location() <= value && range.location() + range.length() - 1 >= value) {
                return min;
            }
        }
        return -1;
    }

    protected int _indexOfRangeBeforeOrContainingIndex(int value) {
        int count = NSIndexSet.GET_RANGE_COUNT(this);
        if (count > 0) {
            NSRange range;
            NSRange[] ranges = NSIndexSet.RANGES(this);
            int min = 0;
            int max = count - 1;
            while (min < max) {
                int idx = (max + min) / 2;
                range = ranges[idx];
                if (range.location() > value) {
                    max = idx;
                    continue;
                }
                if (range.location() + range.length() - 1 < value) {
                    min = idx + 1;
                    continue;
                }
                return idx;
            }
            range = ranges[min];
            if (range.location() <= value) {
                return min;
            }
            if (min > 0) {
                return min - 1;
            }
        }
        return -1;
    }

    protected int _indexOfRangeAfterOrContainingIndex(int value) {
        int count = NSIndexSet.GET_RANGE_COUNT(this);
        if (count > 0) {
            NSRange range;
            NSRange[] ranges = NSIndexSet.RANGES(this);
            int min = 0;
            int max = count - 1;
            while (min < max) {
                int idx = (max + min) / 2;
                range = ranges[idx];
                if (range.location() > value) {
                    max = idx;
                    continue;
                }
                if (range.location() + range.length() - 1 < value) {
                    min = idx + 1;
                    continue;
                }
                return idx;
            }
            range = ranges[min];
            if (range.location() + range.length() - 1 >= value) {
                return min;
            }
            if (min < count - 1) {
                return min + 1;
            }
        }
        return -1;
    }

    public int hashCode() {
        int hash = NSIndexSet.GET_INTEGER_COUNT(this);
        if (hash > 0) {
            hash += this.firstIndex() + this.lastIndex();
        }
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEqualToIndexSet(NSIndexSet indexSet) {
        if (indexSet == this) return true;
        if (indexSet == null) {
            return false;
        }
        Class<?> objectClass = this.getClass();
        Class<?> indexSetClass = indexSet.getClass();
        if (!(objectClass != NSIndexSet.class && objectClass != NSMutableIndexSet.class || indexSetClass != NSIndexSet.class && indexSetClass != NSMutableIndexSet.class)) {
            int count = NSIndexSet.GET_RANGE_COUNT(this);
            if (count != NSIndexSet.GET_RANGE_COUNT(indexSet) || NSIndexSet.GET_INTEGER_COUNT(this) != NSIndexSet.GET_INTEGER_COUNT(indexSet)) return false;
            NSRange[] ranges = NSIndexSet.RANGES(this);
            NSRange[] compareRanges = NSIndexSet.RANGES(indexSet);
            int i = 0;
            while (i < count) {
                NSRange range = ranges[i];
                NSRange compareRange = compareRanges[i];
                if (!range.equals(compareRange)) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            int count = this.count();
            if (count != indexSet.count()) return false;
            if (count <= 0) return true;
            int idx = this.firstIndex();
            int compareIndex = indexSet.firstIndex();
            int i = 0;
            while (i < count) {
                if (idx != compareIndex) {
                    return false;
                }
                idx = this.indexGreaterThanIndex(idx);
                compareIndex = indexSet.indexGreaterThanIndex(compareIndex);
                ++i;
            }
        }
        return true;
    }

    public boolean equals(Object indexSet) {
        if (indexSet == this) {
            return true;
        }
        if (indexSet == null || indexSet.getClass() != NSIndexSet.class) {
            return false;
        }
        return this.isEqualToIndexSet((NSIndexSet)indexSet);
    }

    public int count() {
        return NSIndexSet.GET_INTEGER_COUNT(this);
    }

    public int firstIndex() {
        return NSIndexSet.GET_RANGE_COUNT(this) != 0 ? NSIndexSet.RANGES(this)[0].location() : -1;
    }

    public int lastIndex() {
        if (NSIndexSet.GET_RANGE_COUNT(this) != 0) {
            NSRange range = NSIndexSet.RANGES(this)[NSIndexSet.GET_RANGE_COUNT(this) - 1];
            return range.location() + range.length() - 1;
        }
        return -1;
    }

    protected int _indexClosestToIndexEqualAllowedFollowing(int value, boolean equalAllowed, boolean followingOrPreceding) {
        NSRange range;
        Thread currentThread = null;
        if (this._isEmpty) {
            return -1;
        }
        if (this._hasSingleRange) {
            range = this._singleRange;
            int maxRangeIndex = range.location() + range.length() - 1;
            if (followingOrPreceding) {
                if (equalAllowed) {
                    if (range.location() >= value) {
                        return range.location();
                    }
                    if (maxRangeIndex >= value) {
                        return value;
                    }
                } else {
                    if (range.location() > value) {
                        return range.location();
                    }
                    if (maxRangeIndex > value) {
                        return value + 1;
                    }
                }
            } else if (equalAllowed) {
                if (maxRangeIndex <= value) {
                    return maxRangeIndex;
                }
                if (range.location() <= value) {
                    return value;
                }
            } else {
                if (maxRangeIndex < value) {
                    return maxRangeIndex;
                }
                if (range.location() < value) {
                    return value - 1;
                }
            }
        } else if (!this._hasSingleRange) {
            currentThread = Thread.currentThread();
            if (this._cacheOwner.get() == currentThread && this._cachedIndexValue == value) {
                if (!equalAllowed) {
                    NSRange[] ranges = NSIndexSet.RANGES(this);
                    if (followingOrPreceding) {
                        NSRange range2 = ranges[this._cachedRangeIndex];
                        if (range2.length() - 1 > this._cachedRangeOffset) {
                            ++this._cachedIndexValue;
                            ++this._cachedRangeOffset;
                            value = this._cachedIndexValue;
                        } else {
                            int count = NSIndexSet.GET_RANGE_COUNT(this);
                            if (this._cachedRangeIndex + 1 < count) {
                                ++this._cachedRangeIndex;
                                range2 = ranges[this._cachedRangeIndex];
                                this._cachedRangeOffset = 0;
                                value = this._cachedIndexValue = range2.location();
                            } else {
                                this._cacheOwner.set(null);
                                value = -1;
                            }
                        }
                    } else if (this._cachedRangeOffset > 0) {
                        --this._cachedIndexValue;
                        --this._cachedRangeOffset;
                        value = this._cachedIndexValue;
                    } else if (this._cachedRangeIndex > 0) {
                        --this._cachedRangeIndex;
                        NSRange range3 = ranges[this._cachedRangeIndex];
                        this._cachedRangeOffset = range3.length() - 1;
                        value = this._cachedIndexValue = range3.location() + this._cachedRangeOffset;
                    } else {
                        this._cacheOwner.set(null);
                        value = -1;
                    }
                }
                return value;
            }
        }
        if (followingOrPreceding) {
            if (!equalAllowed) {
                if (value <= -1) {
                    return -1;
                }
                ++value;
            }
            NSRange[] ranges = NSIndexSet.RANGES(this);
            int rangeIndex = this._indexOfRangeAfterOrContainingIndex(value);
            if (rangeIndex != -1) {
                range = ranges[rangeIndex];
                if (value < range.location()) {
                    value = range.location();
                }
                if (this._cacheOwner.get() == currentThread || this._cacheOwner.compareAndSet(null, currentThread)) {
                    this._cachedRangeIndex = rangeIndex;
                    this._cachedRangeOffset = value - range.location();
                    this._cachedIndexValue = value;
                }
                return value;
            }
        } else {
            if (!equalAllowed) {
                if (value == 0) {
                    return -1;
                }
                --value;
            }
            NSRange[] ranges = NSIndexSet.RANGES(this);
            int rangeIndex = this._indexOfRangeBeforeOrContainingIndex(value);
            if (rangeIndex != -1) {
                range = ranges[rangeIndex];
                int maxRangeIndex = range.location() + range.length() - 1;
                if (value > maxRangeIndex) {
                    value = maxRangeIndex;
                }
                Thread current = Thread.currentThread();
                if (this._cacheOwner.get() == current || this._cacheOwner.compareAndSet(null, current)) {
                    this._cachedRangeIndex = rangeIndex;
                    this._cachedRangeOffset = value - range.location();
                    this._cachedIndexValue = value;
                }
                return value;
            }
        }
        return -1;
    }

    public int indexGreaterThanIndex(int value) {
        return this._indexClosestToIndexEqualAllowedFollowing(value, false, true);
    }

    public int indexLessThanIndex(int value) {
        return this._indexClosestToIndexEqualAllowedFollowing(value, false, false);
    }

    public int indexGreaterThanOrEqualToIndex(int value) {
        return this._indexClosestToIndexEqualAllowedFollowing(value, true, true);
    }

    public int indexLessThanOrEqualToIndex(int value) {
        return this._indexClosestToIndexEqualAllowedFollowing(value, true, false);
    }

    public int getIndexesMaxCountInIndexRange(int[] indexBuffer, int bufferSize, NSMutableRange range) {
        int lastIndex;
        NSRange currentRange;
        int maxIndex;
        int minIndex;
        if (range != null) {
            if (range.length() == 0) {
                return 0;
            }
            minIndex = range.location();
            maxIndex = range.location() + range.length() - 1;
        } else {
            minIndex = this.firstIndex();
            maxIndex = this.lastIndex();
        }
        if (maxIndex < minIndex) {
            return 0;
        }
        int rangeIndex = -1;
        if (!this._hasSingleRange && this._cacheOwner.get() == Thread.currentThread() && this._cachedIndexValue == minIndex) {
            rangeIndex = this._cachedRangeIndex;
        }
        if (rangeIndex == -1) {
            rangeIndex = this._indexOfRangeAfterOrContainingIndex(minIndex);
        }
        if (rangeIndex == -1) {
            return 0;
        }
        int rangeCount = NSIndexSet.GET_RANGE_COUNT(this);
        NSRange[] ranges = NSIndexSet.RANGES(this);
        int counter = 0;
        int idx = minIndex;
        int offset = 0;
        while (rangeIndex < rangeCount && idx <= maxIndex && counter < bufferSize) {
            currentRange = ranges[rangeIndex];
            if (currentRange.location() <= minIndex) {
                idx = minIndex;
                offset = minIndex - currentRange.location();
            } else {
                idx = currentRange.location();
            }
            while (idx <= maxIndex && counter < bufferSize && offset < currentRange.length()) {
                indexBuffer[counter++] = idx++;
                ++offset;
            }
            if (offset < currentRange.length()) continue;
            ++rangeIndex;
            offset = 0;
        }
        if (counter > 0) {
            int delta = indexBuffer[counter - 1] - minIndex + 1;
            if (range != null) {
                range.setLocation(range.location() + delta);
                range.setLength(range.length() - delta);
            }
        }
        if (counter > 0 && !this._hasSingleRange && rangeIndex < rangeCount && (offset = (lastIndex = indexBuffer[counter - 1]) - (currentRange = ranges[rangeIndex]).location()) < currentRange.length()) {
            Thread currentThread = Thread.currentThread();
            if (this._cacheOwner.get() == currentThread || this._cacheOwner.compareAndSet(null, currentThread)) {
                this._cachedRangeIndex = rangeIndex;
                this._cachedRangeOffset = offset;
                this._cachedIndexValue = lastIndex;
            }
        }
        return counter;
    }

    public int countOfIndexesInRange(NSRange range) {
        int idx;
        int numberOfIndexes = 0;
        if (!this._isEmpty && range.length() > 0 && (idx = this._indexOfRangeAfterOrContainingIndex(range.location())) != -1) {
            NSRange[] ranges = NSIndexSet.RANGES(this);
            int rangeCount = NSIndexSet.GET_RANGE_COUNT(this);
            int maxRangeIndex = range.location() + range.length() - 1;
            NSRange testRange = ranges[idx];
            if (testRange.location() < range.location()) {
                if (testRange.location() + testRange.length() - 1 >= maxRangeIndex) {
                    return range.length();
                }
                numberOfIndexes = testRange.location() + testRange.length() - range.location();
                ++idx;
            }
            while (idx < rangeCount) {
                testRange = ranges[idx];
                if (testRange.location() + testRange.length() - 1 > maxRangeIndex) {
                    if (testRange.location() > maxRangeIndex) break;
                    numberOfIndexes += maxRangeIndex + 1 - testRange.location();
                    break;
                }
                numberOfIndexes += testRange.length();
                ++idx;
            }
        }
        return numberOfIndexes;
    }

    public int rangeCount() {
        return NSIndexSet.GET_RANGE_COUNT(this);
    }

    public NSRange rangeAtIndex(int rangeIndex) {
        int count = NSIndexSet.GET_RANGE_COUNT(this);
        if (rangeIndex > count) {
            throw new IllegalArgumentException("Index " + rangeIndex + " out of bounds [0..." + count + "]");
        }
        return NSIndexSet.RANGES(this)[rangeIndex];
    }

    public boolean containsIndex(int value) {
        if (this._isEmpty) {
            return false;
        }
        if (this._hasSingleRange) {
            NSRange range = this._singleRange;
            return range.location() <= value && range.location() + range.length() - 1 >= value;
        }
        if (this._cacheOwner.get() == Thread.currentThread()) {
            if (this._cachedIndexValue == value) {
                return true;
            }
            NSRange range = NSIndexSet.RANGES(this)[this._cachedRangeIndex];
            if (range.location() <= value && range.location() + range.length() - 1 >= value) {
                return true;
            }
        }
        return this._indexOfRangeContainingIndex(value) != -1;
    }

    public boolean containsIndexesInRange(NSRange range) {
        int rangeIndex;
        if (range.length() > 0 && (rangeIndex = this._indexOfRangeContainingIndex(range.location())) != -1) {
            NSRange testRange = NSIndexSet.RANGES(this)[rangeIndex];
            return testRange.location() + testRange.length() >= range.location() + range.length();
        }
        return false;
    }

    public boolean containsIndexes(NSIndexSet indexSet) {
        block6: {
            if (indexSet == null || indexSet == this) break block6;
            Class<?> indexSetClass = indexSet.getClass();
            if (indexSetClass == NSIndexSet.class || indexSetClass == NSMutableIndexSet.class) {
                int count = indexSet.rangeCount();
                int i = 0;
                while (i < count) {
                    if (!this.containsIndexesInRange(indexSet.rangeAtIndex(i))) {
                        return false;
                    }
                    ++i;
                }
            } else {
                int idx = indexSet.firstIndex();
                while (idx != -1) {
                    if (!this.containsIndex(idx)) {
                        return false;
                    }
                    idx = indexSet.indexGreaterThanIndex(idx);
                }
            }
        }
        return true;
    }

    public boolean intersectsIndexesInRange(NSRange range) {
        if (range.length() > 0) {
            NSRange testRange;
            int rangeIndex = this._indexOfRangeBeforeOrContainingIndex(range.location());
            if (rangeIndex != -1 && (testRange = NSIndexSet.RANGES(this)[rangeIndex]).location() + testRange.length() - 1 >= range.location()) {
                return true;
            }
            rangeIndex = this._indexOfRangeAfterOrContainingIndex(range.location());
            if (rangeIndex != -1) {
                testRange = NSIndexSet.RANGES(this)[rangeIndex];
                if (range.location() + range.length() - 1 >= testRange.location()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new _NSIndexSetEnumerator();
    }

    public String toString() {
        StringBuffer string = new StringBuffer(128);
        string.append(super.toString());
        int integerCount = NSIndexSet.GET_INTEGER_COUNT(this);
        if (integerCount == 0) {
            string.append("(no indexes)");
        } else {
            int count = NSIndexSet.GET_RANGE_COUNT(this);
            NSRange[] ranges = NSIndexSet.RANGES(this);
            string.append("[number of indexes: " + integerCount + " (in " + count + " ranges), indexes: (");
            int i = 0;
            while (i < count) {
                if (i > 0) {
                    string.append(" ");
                }
                NSRange range = ranges[i];
                string.append(range.location());
                if (range.length() > 1) {
                    string.append("-");
                    string.append(range.location() + range.length() - 1);
                }
                ++i;
            }
            string.append(")]");
        }
        return string.toString();
    }

    protected class _NSIndexSetEnumerator
    implements Iterator<Integer> {
        private int _index;

        public _NSIndexSetEnumerator() {
            this._index = NSIndexSet.this.firstIndex();
        }

        @Override
        public boolean hasNext() {
            return this._index != -1;
        }

        @Override
        public Integer next() {
            int idx = this._index;
            if (idx != -1) {
                this._index = NSIndexSet.this.indexGreaterThanIndex(idx);
                return idx;
            }
            throw new NoSuchElementException("no more items in index set");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("You can't remove from an immutable NSIndexSet.");
        }
    }
}

