/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NSFormatRepository
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling {
    private static NSFormatRepository _repository = new NSFormatRepository();
    private static Map<String, Object> _formatters = new ConcurrentHashMap<String, Object>();
    public static final String DefaultDateFormat = "%Y/%m/%d";
    public static final String DefaultNumberFormat = "0";
    public static final String DefaultDecimalNumberFormat = "#,##0.00;-(#,##0.00)";
    private static final _NSThreadsafeMutableDictionary<String, NSNumberFormatter> TheNumberFormatters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(32));
    private static final _NSThreadsafeMutableDictionary<String, NSTimestampFormatter> TheDateFormatters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(32));

    public static NSNumberFormatter numberFormatterForFormatString(String formatString) {
        NSNumberFormatter result = null;
        result = TheNumberFormatters.objectForKey(formatString);
        if (result == null && formatString != null) {
            result = new NSNumberFormatter(formatString);
            TheNumberFormatters.setObjectForKey(result, formatString);
        }
        return result;
    }

    private static String _reformatDateFormatStringToJDK(String formatString) {
        return formatString;
    }

    public static NSTimestampFormatter dateFormatterForFormatString(String formatString) {
        NSTimestampFormatter result = null;
        result = TheDateFormatters.objectForKey(formatString);
        if (result == null && formatString != null) {
            result = new NSTimestampFormatter(formatString);
            TheDateFormatters.setObjectForKey(result, formatString);
        }
        return result;
    }

    public static NSFormatRepository repository() {
        return _repository;
    }

    public static void setRepository(NSFormatRepository factory) {
        _repository = factory;
    }

    protected static Format createProxy(Format actual) {
        return new Proxy(actual);
    }

    public static Format formatForKey(String key) {
        Object value = _formatters.get(key);
        if (value instanceof Factory) {
            return ((Factory)value).createFormat();
        }
        return (Format)value;
    }

    public static void removeFormatForKey(String key) {
        _formatters.remove(key);
    }

    public static void setFormatForKey(Format format, String key, boolean isThreadsafe) {
        if (!isThreadsafe) {
            format = NSFormatRepository.createProxy(format);
        }
        _formatters.put(key, format);
    }

    public static void setFormatForKey(Format format, String key) {
        Class<?> clazz = format.getClass();
        NSFormatRepository.setFormatForKey(format, key, clazz == NSNumberFormatter.class || clazz == NSTimestampFormatter.class);
    }

    public static void setFactoryForKey(Factory factory, String key) {
        _formatters.put(key, factory);
    }

    @Override
    public Object valueForKey(String key) {
        return NSKeyValueCoding.Utility.valueForKey(this, key);
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        NSKeyValueCoding.Utility.takeValueForKey(this, value, key);
    }

    @Override
    public Object handleQueryWithUnboundKey(String key) {
        return _formatters.get(key);
    }

    @Override
    public void handleTakeValueForUnboundKey(Object value, String key) {
        if (value instanceof Factory) {
            NSFormatRepository.setFactoryForKey((Factory)value, key);
        } else if (value instanceof Format) {
            NSFormatRepository.setFormatForKey((Format)value, key);
        }
    }

    @Override
    public void unableToSetNullForKey(String key) {
        NSFormatRepository.removeFormatForKey(key);
    }

    public static interface Factory {
        public Format createFormat();
    }

    private static final class Proxy
    extends Format {
        Format _actual;

        public Proxy(Format actual) {
            this._actual = actual;
        }

        @Override
        public synchronized StringBuffer format(Object arg0, StringBuffer arg1, FieldPosition arg2) {
            return this._actual.format(arg0, arg1, arg2);
        }

        @Override
        public synchronized Object parseObject(String arg0, ParsePosition arg1) {
            return this._actual.parseObject(arg0, arg1);
        }
    }
}

