/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.properties.NSIntegerProperty;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSFileNotificationCenter {
    public static final String FileDidChangeNotification = "FileDidChangeNotification";
    private static final Logger _log = LoggerFactory.getLogger(NSFileNotificationCenter.class);
    private static final NSFileNotificationCenter _defaultCenter = new NSFileNotificationCenter();
    private static final NSIntegerProperty _checkFrequencyProperty = new NSIntegerProperty("NSFileNotificationCenter.checkFrequencyInSeconds", 0);
    private static final NSIntegerProperty _sleepTime = new NSIntegerProperty("NSFileNotificationCenter.backgroundCheckFrequencyInSeconds", 300);
    private Integer _checkFrequency;
    private NSMutableDictionary<String, NSMutableSet<_ObserverSelectorHolder>> _observersByFilePath;
    private ConcurrentMap<String, Object> _lastModifiedByFilePath;
    private boolean _enabled = true;
    private boolean _ignoreCheckFrequency;
    private AtomicLong _lastCheckMillis = new AtomicLong(System.currentTimeMillis());
    private boolean _symlinkSupport = Boolean.valueOf(System.getProperty("NSFileNotificationCenter.symlinkSupport", "true"));
    private NSBackgroundChecker _backgroundChecker;

    public static NSFileNotificationCenter defaultCenter() {
        return _defaultCenter;
    }

    public NSFileNotificationCenter() {
        this._observersByFilePath = new NSMutableDictionary();
        this._lastModifiedByFilePath = new ConcurrentHashMap<String, Object>();
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setIgnoreCheckFrequency(boolean ignoreCheckFrequency) {
        this._ignoreCheckFrequency = ignoreCheckFrequency;
    }

    public boolean shouldIgnoreCheckFrequency() {
        return this._ignoreCheckFrequency;
    }

    public void setCheckFrequency(Integer checkFrequencyInSeconds) {
        this._checkFrequency = checkFrequencyInSeconds;
    }

    private int checkFrequency() {
        Integer checkFrequency = this._checkFrequency;
        if (checkFrequency == null) {
            checkFrequency = _checkFrequencyProperty.value();
        }
        return checkFrequency;
    }

    public synchronized void addObserver(Object observer, NSSelector<?> selector, File file) {
        if (file == null) {
            throw new IllegalArgumentException("Attempting to register an observer on a null file.");
        }
        if (observer == null) {
            throw new IllegalArgumentException("Attempting to register a null observer for file '" + file + "'");
        }
        if (selector == null) {
            throw new IllegalArgumentException("Attempting to register a null selector for file '" + file + "'");
        }
        String filePath = this.cacheKeyForFile(file);
        if (_log.isDebugEnabled()) {
            _log.debug("Registering Observer for file at path: " + filePath);
        }
        this.recordLastModifiedDateForFile(file);
        NSMutableSet<_ObserverSelectorHolder> observerSet = (NSMutableSet<_ObserverSelectorHolder>)this._observersByFilePath.objectForKey(filePath);
        if (observerSet == null) {
            observerSet = new NSMutableSet<_ObserverSelectorHolder>();
            this._observersByFilePath.setObjectForKey(observerSet, filePath);
        }
        observerSet.addObject(new _ObserverSelectorHolder(observer, selector));
    }

    protected String cacheKeyForFile(File file) {
        return file.getAbsolutePath();
    }

    protected Object cacheValueForFile(File file) {
        if (this._symlinkSupport) {
            try {
                File canonicalizedFile = file.getCanonicalFile();
                return String.valueOf(canonicalizedFile.getPath()) + ":" + Long.valueOf(canonicalizedFile.lastModified());
            }
            catch (IOException e) {
                _log.warn("Failed to determine the lastModified time on '" + file + "': " + e.getMessage());
                return 0L;
            }
        }
        return file.lastModified();
    }

    protected void recordLastModifiedDateForFile(File file) {
        if (file != null) {
            this._lastModifiedByFilePath.put(this.cacheKeyForFile(file), this.cacheValueForFile(file));
        }
    }

    public boolean hasFileChanged(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Attempting to check if a null file has been changed.");
        }
        if (!file.exists()) {
            return false;
        }
        Object previousCacheValue = this._lastModifiedByFilePath.get(this.cacheKeyForFile(file));
        return previousCacheValue == null || !previousCacheValue.equals(this.cacheValueForFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDidChange(File file) {
        NSSet observerHolders = null;
        NSFileNotificationCenter nSFileNotificationCenter = this;
        synchronized (nSFileNotificationCenter) {
            NSMutableSet originalObserverHolders = (NSMutableSet)this._observersByFilePath.objectForKey(this.cacheKeyForFile(file));
            if (originalObserverHolders == null) {
                _log.warn("Unable to find observers for file: " + file);
                observerHolders = new NSSet();
            } else {
                observerHolders = new NSSet(originalObserverHolders);
            }
            this.recordLastModifiedDateForFile(file);
        }
        NSNotification notification = new NSNotification(FileDidChangeNotification, file);
        for (_ObserverSelectorHolder observerHolder : observerHolders) {
            try {
                observerHolder.selector.invoke(observerHolder.observer, notification);
            }
            catch (Exception e) {
                _log.error("Failed to notify of a change to file '" + file + "'.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFiles() {
        if (!this._shouldCheckNow()) {
            return;
        }
        NSFileNotificationCenter nSFileNotificationCenter = this;
        synchronized (nSFileNotificationCenter) {
            if (!this._shouldCheckNow()) {
                return;
            }
            this._lastCheckMillis.set(System.currentTimeMillis());
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Checking if files have changed.");
        }
        for (String filePath : this._lastModifiedByFilePath.keySet()) {
            File file = new File(filePath);
            if (!this.hasFileChanged(file)) continue;
            this.fileDidChange(file);
        }
    }

    public void checkFiles(NSNotification n) {
        this.checkFiles();
    }

    private boolean _shouldCheckNow() {
        if (!this._enabled) {
            return false;
        }
        if (this._ignoreCheckFrequency) {
            return true;
        }
        int checkFrequency = this.checkFrequency();
        if (checkFrequency == 0) {
            return false;
        }
        long lastCheck = this._lastCheckMillis.get();
        return System.currentTimeMillis() - lastCheck >= (long)(1000 * checkFrequency);
    }

    public void startBackgroundChecker() {
        if (this._backgroundChecker != null) {
            return;
        }
        this._backgroundChecker = new NSBackgroundChecker();
        Thread reloadingThread = new Thread(this._backgroundChecker);
        reloadingThread.setDaemon(true);
        reloadingThread.setName("NSPropertiesReloader");
        reloadingThread.start();
    }

    public void stopBackgroundChecker() {
        this._backgroundChecker.stop();
        this._backgroundChecker = null;
    }

    private class NSBackgroundChecker
    implements Runnable {
        private AtomicBoolean _running = new AtomicBoolean(true);

        private NSBackgroundChecker() {
        }

        public void stop() {
            this._running.set(false);
        }

        @Override
        public void run() {
            while (this._running.get()) {
                try {
                    if (_log.isDebugEnabled()) {
                        _log.debug("NSPropertiesReloader will check for changed files now.");
                    }
                    NSFileNotificationCenter.this.checkFiles();
                    int sleepTime = _sleepTime.value();
                    if (_log.isDebugEnabled()) {
                        _log.debug("NSPropertiesReloader sleeping for " + sleepTime + " seconds.");
                    }
                    Thread.sleep(sleepTime * 1000);
                }
                catch (Throwable t) {
                    _log.error("Error when running NSPropertiesReloader", t);
                }
            }
        }
    }

    private static class _ObserverSelectorHolder {
        public Object observer;
        public NSSelector<?> selector;

        public _ObserverSelectorHolder(Object observer, NSSelector<?> selector) {
            this.observer = observer;
            this.selector = selector;
        }

        public int hashCode() {
            return (this.observer == null ? 1 : this.observer.hashCode()) * (this.selector == null ? 1 : this.selector.hashCode());
        }

        public boolean equals(Object other) {
            return other instanceof _ObserverSelectorHolder && ((_ObserverSelectorHolder)other).selector.equals(this.selector) && ((_ObserverSelectorHolder)other).observer.equals(this.observer);
        }
    }
}

