/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSCollectionEnumerator;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaMapKeySetIterator;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class NSDictionary<K, V>
implements Cloneable,
Serializable,
NSCoding,
NSKeyValueCoding,
NSKeyValueCodingAdditions,
_NSFoundationCollection,
Map<K, V> {
    public static final Class<NSDictionary> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSDictionary.class);
    public static final NSDictionary<?, ?> EmptyDictionary = new NSDictionary();
    static final long serialVersionUID = 2886170486405617806L;
    private static final String SerializationKeysFieldKey = "keys";
    private static final String SerializationValuesFieldKey = "objects";
    private static final Class<?> _objectArrayClass = new Object[0].getClass();
    protected transient int _capacity;
    protected transient int _hashtableBuckets;
    protected transient int _count;
    protected Object[] _objects;
    protected transient Object[] _objectsCache;
    protected transient short[] _flags;
    protected Object[] _keys;
    protected transient Object[] _keysCache;
    protected transient int _hashCache;
    protected transient int _deletionLimit;
    protected static int _NSDictionaryClassHashCode = _CLASS.hashCode();
    protected static int _NSDictionaryMapEntryHashCode;
    public static final boolean CheckForNull = true;
    public static final boolean IgnoreNull = true;
    private static final ObjectStreamField[] serialPersistentFields;

    static {
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationKeysFieldKey, _objectArrayClass), new ObjectStreamField(SerializationValuesFieldKey, _objectArrayClass)};
    }

    private void _copyImmutableDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        this._capacity = otherDictionary._capacity;
        this._count = otherDictionary._count;
        this._hashtableBuckets = otherDictionary._hashtableBuckets;
        this._hashCache = otherDictionary._hashCache;
        this._objects = otherDictionary._objects;
        this._objectsCache = otherDictionary._objectsCache;
        this._flags = otherDictionary._flags;
        this._keys = otherDictionary._keys;
        this._keysCache = otherDictionary._keysCache;
        this._deletionLimit = otherDictionary._deletionLimit;
    }

    void _copyMutableDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary.getClass() == NSMutableDictionary._CLASS || otherDictionary.getClass() == _CLASS) {
            this._capacity = otherDictionary._capacity;
            this._count = otherDictionary._count;
            this._hashtableBuckets = otherDictionary._hashtableBuckets;
            this._hashCache = otherDictionary._hashCache;
            this._objects = _NSCollectionPrimitives.copyArray(otherDictionary._objects);
            this._objectsCache = null;
            this._flags = _NSCollectionPrimitives.copyArray(otherDictionary._flags);
            this._keys = _NSCollectionPrimitives.copyArray(otherDictionary._keys);
            this._keysCache = null;
            this._deletionLimit = otherDictionary._deletionLimit;
        } else {
            this._initializeDictionary();
            this._ensureCapacity(otherDictionary.count());
            Enumeration<K> keyEnum = otherDictionary.keyEnumerator();
            while (keyEnum.hasMoreElements()) {
                V object;
                K key = keyEnum.nextElement();
                if (!_NSCollectionPrimitives.addValueInHashTable(key, object = otherDictionary.objectForKey(key), this._keys, this._objects, this._flags)) continue;
                ++this._count;
            }
        }
    }

    protected void _initializeDictionary() {
        this._count = 0;
        this._capacity = 0;
        this._objectsCache = null;
        this._objects = null;
        this._flags = null;
        this._keysCache = null;
        this._keys = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
    }

    protected void _ensureCapacity(int capacity) {
        int newCapacity;
        int currentCapacity = this._capacity;
        if (capacity > currentCapacity && (newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity(capacity)) != currentCapacity) {
            int newSize;
            int oldSize = this._hashtableBuckets;
            this._hashtableBuckets = newSize = _NSCollectionPrimitives.hashTableBucketsForCapacity(newCapacity);
            if (newSize == 0) {
                this._objects = null;
                this._keys = null;
                this._flags = null;
            } else {
                Object[] oldObjects = this._objects;
                Object[] oldKeys = this._keys;
                short[] oldFlags = this._flags;
                Object[] newObjects = new Object[newSize];
                Object[] newKeys = new Object[newSize];
                short[] newFlags = new short[newSize];
                int i = 0;
                while (i < oldSize) {
                    if ((oldFlags[i] & 0xFFFFC000) == Short.MIN_VALUE) {
                        _NSCollectionPrimitives.addValueInHashTable(oldKeys[i], oldObjects[i], newKeys, newObjects, newFlags);
                    }
                    ++i;
                }
                this._objects = newObjects;
                this._keys = newKeys;
                this._flags = newFlags;
            }
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(newSize);
            this._capacity = newCapacity;
        }
    }

    protected void _clearDeletionsAndCollisions() {
        int size = this._hashtableBuckets;
        if (this._count == 0) {
            this._flags = new short[size];
        } else {
            Object[] oldObjects = this._objects;
            Object[] oldKeys = this._keys;
            short[] oldFlags = this._flags;
            Object[] newObjects = new Object[size];
            Object[] newKeys = new Object[size];
            short[] newFlags = new short[size];
            int i = 0;
            while (i < size) {
                if ((oldFlags[i] & 0xFFFFC000) == Short.MIN_VALUE) {
                    _NSCollectionPrimitives.addValueInHashTable(oldKeys[i], oldObjects[i], newKeys, newObjects, newFlags);
                }
                ++i;
            }
            this._objects = newObjects;
            this._keys = newKeys;
            this._flags = newFlags;
        }
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(size);
    }

    public static <K, V> NSDictionary<K, V> dictionary() {
        return NSDictionary.emptyDictionary();
    }

    public static <K, V> NSDictionary<K, V> dictionaryWithDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        return new NSDictionary<K, V>(otherDictionary);
    }

    public static <K, V> NSDictionary<K, V> dictionaryWithMap(Map<? extends K, ? extends V> map) {
        return new NSDictionary<K, V>(map);
    }

    public static <K, V> NSDictionary<K, V> dictionaryWithObjectForKey(V object, K key) {
        return new NSDictionary<K, V>(object, key);
    }

    public static <K, V> NSDictionary<K, V> dictionaryWithObjectsForKeys(V[] objects, K[] keys) {
        return new NSDictionary<K, V>(objects, keys);
    }

    public static <K, V> NSDictionary<K, V> dictionaryWithObjectsForKeys(NSArray<? extends V> objects, NSArray<? extends K> keys) {
        return new NSDictionary<K, V>(objects, keys);
    }

    public NSDictionary() {
        this._initializeDictionary();
    }

    public NSDictionary(V object, K key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
        }
        this._initializeDictionary();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) {
            ++this._count;
        }
    }

    private void initFromKeyValues(Object[] objects, Object[] keys, boolean checkForNull) {
        if (objects != null && keys != null) {
            int i;
            if (objects.length != keys.length) {
                throw new IllegalArgumentException("Attempt to create an " + this.getClass().getName() + " with a different number of objects and keys.");
            }
            if (checkForNull) {
                i = 0;
                while (i < objects.length) {
                    if (objects[i] == null) {
                        throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
                    }
                    if (keys[i] == null) {
                        throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                    }
                    ++i;
                }
            }
            this._initializeDictionary();
            this._ensureCapacity(objects.length);
            i = 0;
            while (i < objects.length) {
                if (_NSCollectionPrimitives.addValueInHashTable(keys[i], objects[i], this._keys, this._objects, this._flags)) {
                    ++this._count;
                }
                ++i;
            }
        } else if (objects == null && keys == null) {
            this._initializeDictionary();
        } else {
            throw new IllegalArgumentException("Both objects and keys cannot be null");
        }
    }

    private NSDictionary(Object[] objects, Object[] keys, boolean checkForNull) {
        this.initFromKeyValues(objects, keys, checkForNull);
    }

    public NSDictionary(V[] objects, K[] keys) {
        this(objects, keys, true);
    }

    public NSDictionary(NSArray<? extends V> objects, NSArray<? extends K> keys) {
        this(objects != null ? objects.objectsNoCopy() : null, keys != null ? keys.objectsNoCopy() : null, false);
    }

    public NSDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary.getClass() == _CLASS) {
            this._copyImmutableDictionary(otherDictionary);
        } else {
            this._copyMutableDictionary(otherDictionary);
        }
    }

    public NSDictionary(Map<? extends K, ? extends V> map, boolean ignoreNull) {
        if (map == null) {
            throw new NullPointerException("map cannot be null");
        }
        this._initializeDictionary();
        this._ensureCapacity(map.size());
        for (K key : map.keySet()) {
            V object = map.get(key);
            if (key == null) {
                if (ignoreNull) continue;
                throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
            }
            if (object == null) {
                if (ignoreNull) continue;
                throw new IllegalArgumentException("Attempt to insert null value into an  " + this.getClass().getName() + ".");
            }
            if (!_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) continue;
            ++this._count;
        }
    }

    public NSDictionary(Map<? extends K, ? extends V> map) {
        this(map, false);
    }

    @Deprecated
    public NSDictionary(Dictionary<? extends K, ? extends V> dictionary, boolean ignoreNull) {
        this._initializeDictionary();
        if (dictionary != null) {
            this._ensureCapacity(dictionary.size());
            Enumeration<K> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                K key = enumeration.nextElement();
                V object = dictionary.get(key);
                if (key == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                }
                if (object == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null value into an  " + this.getClass().getName() + ".");
                }
                if (!_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) continue;
                ++this._count;
            }
        }
    }

    public Object[] keysNoCopy() {
        if (this._keysCache == null) {
            this._keysCache = this._count == 0 ? _NSCollectionPrimitives.emptyArray() : _NSCollectionPrimitives.keysInHashTable(this._keys, this._objects, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._keysCache;
    }

    public Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            this._objectsCache = this._count == 0 ? _NSCollectionPrimitives.emptyArray() : _NSCollectionPrimitives.valuesInHashTable(this._keys, this._objects, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._objectsCache;
    }

    public int count() {
        return this._count;
    }

    public V objectForKey(Object key) {
        return (V)(this._count == 0 || key == null ? null : _NSCollectionPrimitives.findValueInHashTable(key, this._keys, this._objects, this._flags));
    }

    public Hashtable<K, V> hashtable() {
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        Hashtable<Object, V> hashtable = new Hashtable<Object, V>(c > 0 ? c : 1);
        int i = 0;
        while (i < c) {
            hashtable.put(keys[i], this.objectForKey(keys[i]));
            ++i;
        }
        return hashtable;
    }

    public HashMap<K, V> hashMap() {
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        HashMap<Object, V> map = new HashMap<Object, V>(c > 0 ? c : 1);
        int i = 0;
        while (i < c) {
            map.put(keys[i], this.objectForKey(keys[i]));
            ++i;
        }
        return map;
    }

    public NSArray<K> allKeysForObject(Object object) {
        if (object != null) {
            Object[] keys = this.keysNoCopy();
            NSMutableArray<int> array = new NSMutableArray<int>(keys.length);
            int i = 0;
            while (i < keys.length) {
                V compareObject = this.objectForKey(keys[i]);
                if (object == compareObject || object.equals(compareObject)) {
                    array.addObject((int)keys[i]);
                }
                ++i;
            }
            return array;
        }
        return NSArray.emptyArray();
    }

    public NSArray<V> objectsForKeys(NSArray<K> keys, V notFoundMarker) {
        if (keys != null) {
            Object[] keysArray = keys.objectsNoCopy();
            NSMutableArray<int> array = new NSMutableArray<int>(keysArray.length);
            int i = 0;
            while (i < keysArray.length) {
                V object = this.objectForKey(keysArray[i]);
                if (object != null) {
                    array.addObject((int)object);
                } else if (notFoundMarker != null) {
                    array.addObject((int)notFoundMarker);
                }
                ++i;
            }
            return array;
        }
        return NSArray.emptyArray();
    }

    private boolean _equalsDictionary(Map<?, ?> otherDictionary) {
        int count = this.count();
        if (count != otherDictionary.size()) {
            return false;
        }
        Object[] keys = this.keysNoCopy();
        int i = 0;
        while (i < count) {
            V value = this.objectForKey(keys[i]);
            Object otherValue = otherDictionary.get(keys[i]);
            if (otherValue == null || !value.equals(otherValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualToDictionary(NSDictionary<?, ?> otherDictionary) {
        if (otherDictionary == null) {
            return false;
        }
        if (otherDictionary == this) {
            return true;
        }
        return this._equalsDictionary(otherDictionary);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            return this._equalsDictionary((Map)object);
        }
        return false;
    }

    public NSArray<K> allKeys() {
        Object[] keys = this.keysNoCopy();
        return new NSArray(keys, 0, keys.length, false, true);
    }

    public NSArray<V> allValues() {
        Object[] values = this.objectsNoCopy();
        return new NSArray(values, 0, values.length, false, true);
    }

    public Enumeration<K> keyEnumerator() {
        return new _NSCollectionEnumerator(this._keys, this._flags, this._count);
    }

    public Enumeration<V> objectEnumerator() {
        return new _NSCollectionEnumerator(this._objects, this._flags, this._count);
    }

    @Override
    public Object valueForKey(String key) {
        V value = this.objectForKey(key);
        if (value == null && key != null) {
            if (key.equals("allValues")) {
                return this.allValues();
            }
            if (key.equals("allKeys")) {
                return this.allKeys();
            }
            if (key.equals("count")) {
                return _NSUtilities.IntegerForInt(this.count());
            }
        }
        return value;
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is immutable.");
    }

    @Override
    public Object valueForKeyPath(String keyPath) {
        V flattenedKeyPresent = this.objectForKey(keyPath);
        if (flattenedKeyPresent != null) {
            return flattenedKeyPresent;
        }
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath(this, keyPath);
    }

    @Override
    public void takeValueForKeyPath(Object value, String keyPath) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath(this, value, keyPath);
    }

    @Override
    public Class<?> classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        int count = coder.decodeInt();
        Object[] keys = new Object[count];
        Object[] objects = new Object[count];
        int i = 0;
        while (i < count) {
            keys[i] = coder.decodeObject();
            objects[i] = coder.decodeObject();
            ++i;
        }
        return new NSDictionary<Object, Object>(objects, keys);
    }

    @Override
    public void encodeWithCoder(NSCoder coder) {
        int count = this.count();
        coder.encodeInt(count);
        if (count > 0) {
            Object[] keys = this.keysNoCopy();
            int i = 0;
            while (i < keys.length) {
                coder.encodeObject(keys[i]);
                coder.encodeObject(this.objectForKey(keys[i]));
                ++i;
            }
        }
    }

    @Override
    public int _shallowHashCode() {
        return _NSDictionaryClassHashCode;
    }

    @Override
    public int hashCode() {
        return _NSDictionaryClassHashCode ^ this.count();
    }

    public Object clone() {
        return this;
    }

    public NSDictionary<K, V> immutableClone() {
        return this;
    }

    public static <K, V> NSDictionary<K, V> immutableCloneOf(NSDictionary<? extends K, ? extends V> dictionary) {
        NSDictionary<? extends K, ? extends V> immutableClone = dictionary.immutableClone();
        return immutableClone;
    }

    public NSMutableDictionary<K, V> mutableClone() {
        return new NSMutableDictionary(this);
    }

    public static <K, V> NSMutableDictionary<K, V> mutableCloneOf(NSDictionary<? extends K, ? extends V> dictionary) {
        NSMutableDictionary<? extends K, ? extends V> mutableClone = dictionary.mutableClone();
        return mutableClone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{");
        Object[] keys = this.keysNoCopy();
        int i = 0;
        while (i < keys.length) {
            buffer.append(" ");
            Object key = keys[i];
            V object = this.objectForKey(key);
            buffer.append(key.toString());
            buffer.append(" = ");
            String str = null;
            str = object instanceof Boolean ? ((Boolean)object != false ? "true" : "false") : object.toString();
            str = _NSStringUtilities.trimToDebugLength(str);
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append(str);
                buffer.append('\"');
            } else {
                buffer.append(str);
            }
            buffer.append("; ");
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toDebugString() {
        return NSPropertyListSerialization.debugStringFromPropertyList(this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        Object[] values = new Object[c];
        int i = 0;
        while (i < c) {
            values[i] = this.objectForKey(keys[i]);
            ++i;
        }
        fields.put(SerializationKeysFieldKey, keys);
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        values = values == null ? _NSUtilities._NoObjectArray : values;
        this.initFromKeyValues(values, keys, true);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptyDictionary;
        }
        return this;
    }

    public static final <K, V> NSDictionary<K, V> emptyDictionary() {
        return EmptyDictionary;
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() <= 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.objectForKey(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null && this._count != 0) {
            Object[] values = _NSCollectionPrimitives.valuesInHashTable(this._keys, this._objects, this._flags, this._capacity, this._hashtableBuckets);
            int i = 0;
            while (i < values.length) {
                if (values[i].equals(value)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.objectForKey(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("put is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("remove is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException("putAll is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("putAll is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public Set<K> keySet() {
        Object[] currKeys = this.keysNoCopy();
        if (currKeys != null && currKeys.length > 0) {
            return new _NSJavaSet(currKeys, false);
        }
        return NSSet.emptySet();
    }

    @Override
    public Collection<V> values() {
        return this.allValues();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._initMapEntrySet();
    }

    protected Set<Map.Entry<K, V>> _initMapEntrySet() {
        return new _NSJavaMapEntrySet(this.keysNoCopy(), false);
    }

    protected class _NSJavaMapEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private Object[] _keys;
        private boolean _mutable;

        public _NSJavaMapEntrySet(Object[] keys, boolean mutable) {
            this._keys = keys;
            this._mutable = mutable;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new _NSJavaMapKeySetIterator(NSDictionary.this, this._keys, this._mutable);
        }

        @Override
        public int size() {
            return this._keys == null ? 0 : this._keys.length;
        }
    }

    protected class _NSJavaSet
    extends AbstractSet<K> {
        private Object[] _keys;
        private boolean _mutable;

        public _NSJavaSet(Object[] keys, boolean mutable) {
            this._keys = keys;
            this._mutable = mutable;
        }

        @Override
        public Iterator<K> iterator() {
            return new _NSJavaSetIterator(NSDictionary.this, this._keys, this._mutable);
        }

        @Override
        public boolean remove(Object obj) {
            if (this._mutable) {
                return NSDictionary.this.remove(obj) != null;
            }
            throw new UnsupportedOperationException("You can not remove from an NSDictionary.");
        }

        @Override
        public int size() {
            return this._keys == null ? 0 : this._keys.length;
        }
    }

    protected static class _NSJavaSetIterator<E>
    implements Iterator<E> {
        int _index = 0;
        private NSDictionary<E, ?> _dict;
        private Object[] _objects;
        private boolean _mutable;
        private int _limit;

        public _NSJavaSetIterator(NSDictionary<E, ?> dict, Object[] objects, boolean mutable) {
            this._dict = dict;
            this._objects = objects;
            this._mutable = mutable;
            this._limit = objects == null ? 0 : objects.length;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._objects.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this._objects[this._index++];
        }

        @Override
        public void remove() {
            if (this._index >= this._limit) {
                throw new NoSuchElementException("Dictionary enumerator is already exhausted");
            }
            if (!this._mutable) {
                throw new UnsupportedOperationException("You can not remove from an NSDictionary.");
            }
            Object k = this._objects[this._index++];
            ((NSMutableDictionary)this._dict).removeObjectForKey(k);
        }
    }
}

