/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTargetInvocation;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.properties.NSPrimitiveBooleanProperty;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSDelayedCallbackCenter {
    public static final Class<NSDelayedCallbackCenter> _CLASS = _NSUtilities._classWithClassLiteral(NSDelayedCallbackCenter.class);
    private static volatile _Delegate _delegate;
    private static final WeakHashMap<Thread, NSDelayedCallbackCenter> _centers;
    private static volatile WeakReference<Thread> _lastThread;
    private static volatile NSDelayedCallbackCenter _lastCenter;
    private final NSMutableArray<NSLightInvocation> _queue = new NSMutableArray<int>(32);
    private static final Logger log;
    static final NSPrimitiveBooleanProperty _logOnPerformSelectorWithoutEventEnded;
    boolean _willCallEventEnded;

    static {
        _centers = new WeakHashMap(8);
        log = LoggerFactory.getLogger(NSDelayedCallbackCenter.class);
        _logOnPerformSelectorWithoutEventEnded = new NSPrimitiveBooleanProperty("NSDelayedCallbackCenter.logOnPerformSelectorWithoutEventEnded", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSDelayedCallbackCenter defaultCenter() {
        NSDelayedCallbackCenter center;
        Thread currentThread = Thread.currentThread();
        WeakHashMap<Thread, NSDelayedCallbackCenter> weakHashMap = _centers;
        synchronized (weakHashMap) {
            Thread last;
            Thread thread = last = _lastThread != null ? (Thread)_lastThread.get() : null;
            if (last == currentThread) {
                center = _lastCenter;
            } else {
                center = _centers.get(currentThread);
                if (center == null) {
                    center = new NSDelayedCallbackCenter();
                    _centers.put(currentThread, center);
                }
                _lastThread = new WeakReference<Thread>(currentThread);
                _lastCenter = center;
            }
        }
        return center;
    }

    public static void _setDelegate(_Delegate newDelegate) {
        if (_delegate != null) {
            throw new IllegalStateException("_setDelegate can only be called once!");
        }
        _delegate = newDelegate;
    }

    public static _Delegate _delegate() {
        return _delegate;
    }

    private NSDelayedCallbackCenter() {
    }

    public <T> void performTargetInvocation(NSTargetInvocation<? super T> targetInvocation, T target, int order) {
        NSLightTargetInvocation<? super T> newInvocation = new NSLightTargetInvocation<T>(targetInvocation, target, order);
        this._performInvocation(newInvocation);
    }

    public void performSelector(NSSelector<?> selector, Object target, Object argument, int order) {
        NSLightSelectorInvocation newInvocation = new NSLightSelectorInvocation(selector, target, argument, order);
        this._performInvocation(newInvocation);
    }

    private void _performInvocation(NSLightInvocation newInvocation) {
        NSLightInvocation invocation;
        int order = newInvocation.order();
        int i = 0;
        int count = this._queue.count();
        if (count == 0 && _logOnPerformSelectorWithoutEventEnded.booleanValue() && !this.willCallEventEnded()) {
            Thread currentThread = Thread.currentThread();
            log.warn("Thread " + currentThread.getName() + " has not agreed to call eventEnded but a callback is being registered", (Throwable)new Exception("STACK TRACE: Registering callback on thread " + currentThread));
        }
        while (i < count) {
            invocation = (NSLightInvocation)this._queue.objectAtIndex(i);
            if (invocation.order() > order) break;
            ++i;
        }
        invocation = newInvocation;
        this._queue.insertObjectAtIndex(invocation, i);
        if (_delegate != null) {
            _delegate._delayedCallbackCenterWillNeedEndOfEventNotification(this);
        }
    }

    public <T> void cancelPerformTargetInvocation(NSTargetInvocation<? super T> targetInvocation, T target) {
        if (this._queue.count() > 0) {
            NSLightTargetInvocation<? super T> invocation = new NSLightTargetInvocation<T>(targetInvocation, target, 0);
            this._queue.removeObject(invocation);
        }
    }

    public void cancelPerformSelector(NSSelector<?> selector, Object target, Object argument) {
        if (this._queue.count() > 0) {
            NSLightSelectorInvocation invocation = new NSLightSelectorInvocation(selector, target, argument);
            this._queue.removeObject(invocation);
        }
    }

    public void _cancelAllActionsWithTarget(Object obj) {
        int i = 0;
        while (this._queue.count() > 0 && i < this._queue.count()) {
            NSLightInvocation nslightinvocation = (NSLightInvocation)this._queue.objectAtIndex(i);
            if (nslightinvocation.target().equals(obj)) {
                this._queue.removeObjectAtIndex(i);
                continue;
            }
            ++i;
        }
    }

    public boolean willCallEventEnded() {
        return this._willCallEventEnded;
    }

    public void setWillCallEventEnded(boolean willCallEventEnded) {
        this._willCallEventEnded = willCallEventEnded;
    }

    public void eventEnded() {
        if (_delegate == null || _delegate._delayedCallbackCenterShouldHandleEndOfEvent(this)) {
            this._eventEnded();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void _eventEnded() {
        block5: {
            invocations = new NSMutableArray<int>(32);
            i = 0;
            currentPriority = 0;
            lastPriority = -1;
            if (NSDelayedCallbackCenter._delegate != null) {
                NSDelayedCallbackCenter._delegate._delayedCallbackCenterWillHandleEndOfEvent(this);
                break block5;
                while ((currentPriority = ((NSLightInvocation)this._queue.objectAtIndex(i)).order()) <= lastPriority) {
                    ++i;
lbl10:
                    // 2 sources

                    ** while (i >= this._queue.count())
lbl11:
                    // 1 sources

                }
lbl12:
                // 3 sources

                while (i < this._queue.count()) {
                    inv = (NSLightInvocation)this._queue.objectAtIndex(i);
                    if (inv.order() != currentPriority) break;
                    this._queue.removeObjectAtIndex(i);
                    invocations.addObject((int)inv);
                }
                j = 0;
                while (j < invocations.count()) {
                    ((NSLightInvocation)invocations.objectAtIndex(j)).invoke();
                    ++j;
                }
                invocations.removeAllObjects();
                lastPriority = currentPriority;
            }
        }
        if (i < this._queue.count()) ** GOTO lbl10
    }

    private static interface NSLightInvocation {
        public Object target();

        public int order();

        public void invoke();
    }

    private static abstract class NSLightInvocationBase<T>
    implements NSLightInvocation {
        protected final T _target;
        protected final int _order;

        protected NSLightInvocationBase(T target, int order) {
            this._target = target;
            this._order = order;
        }

        public T target() {
            return this._target;
        }

        @Override
        public int order() {
            return this._order;
        }

        @Override
        public abstract void invoke();
    }

    private static class NSLightSelectorInvocation
    extends NSLightInvocationBase<Object> {
        protected final NSSelector<?> _selector;
        protected final Object _argument;

        public NSLightSelectorInvocation(NSSelector<?> newSelector, Object newTarget, Object newArgument, int newOrder) {
            super(newTarget, newOrder);
            this._selector = newSelector;
            this._argument = newArgument;
        }

        public NSLightSelectorInvocation(NSSelector<?> newSelector, Object newTarget, Object newArgument) {
            this(newSelector, newTarget, newArgument, 0);
        }

        public boolean equals(Object other) {
            if (other instanceof NSLightSelectorInvocation) {
                NSLightSelectorInvocation invocation = (NSLightSelectorInvocation)other;
                return this.target() == invocation.target() && (this._selector == invocation._selector || this._selector.equals(invocation._selector)) && this._argument == invocation._argument;
            }
            return false;
        }

        @Override
        public void invoke() {
            NSSelector._safeInvokeSelector(this._selector, this.target(), this._argument);
        }

        public int hashCode() {
            return this._selector != null ? this._selector.hashCode() : 0;
        }
    }

    private static class NSLightTargetInvocation<T>
    extends NSLightInvocationBase<T> {
        final NSTargetInvocation<? super T> _targetInvocation;

        protected NSLightTargetInvocation(NSTargetInvocation<? super T> invocation, T target, int order) {
            super(target, order);
            this._targetInvocation = invocation;
        }

        @Override
        public void invoke() {
            this._targetInvocation.invokeWithTarget(this.target());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            NSLightTargetInvocation other = (NSLightTargetInvocation)obj;
            return this.target() == other.target() && this._targetInvocation.equals(other._targetInvocation);
        }

        public int hashCode() {
            int result = 31 + System.identityHashCode(this.target());
            result = 31 * result + this._targetInvocation.hashCode();
            return result;
        }
    }

    public static interface _Delegate {
        public void _delayedCallbackCenterWillNeedEndOfEventNotification(NSDelayedCallbackCenter var1);

        public boolean _delayedCallbackCenterShouldHandleEndOfEvent(NSDelayedCallbackCenter var1);

        public void _delayedCallbackCenterWillHandleEndOfEvent(NSDelayedCallbackCenter var1);
    }
}

