/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSData
implements Cloneable,
Serializable,
NSCoding {
    public static final Class<NSData> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSData.class);
    private static final Logger log = LoggerFactory.getLogger(NSData.class);
    public static final NSData EmptyData = new NSData();
    static final long serialVersionUID = -6138488451902188317L;
    private static final String SerializationBytesFieldKey = "bytes";
    protected byte[] _bytes;
    protected transient int _hashCache;
    private transient boolean _recomputeHashCode = true;
    private static final char[] _nibbleToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("bytes", _NSUtilities._NoByteArray.getClass())};

    public NSData() {
        this._bytes = null;
    }

    public NSData(byte[] bytes) {
        this(bytes, new NSRange(0, bytes.length), false);
    }

    public NSData(byte[] bytes, NSRange range) {
        this(bytes, range, false);
    }

    public NSData(byte[] bytes, int offset, int count) {
        this(bytes, new NSRange(offset, count), false);
    }

    public NSData(ByteBuffer aByteBuffer) {
        ByteBuffer byteBuffer = aByteBuffer.slice();
        if (byteBuffer.hasArray()) {
            byte[] theBytes = byteBuffer.array();
            this.initFromBytes(theBytes, new NSRange(byteBuffer.arrayOffset(), byteBuffer.remaining()), true);
        } else {
            byte[] buffer = new byte[byteBuffer.remaining()];
            byteBuffer.get(buffer);
            this.initFromBytes(buffer, new NSRange(0, buffer.length), true);
        }
    }

    private void initFromBytes(byte[] bytes, NSRange range, boolean noCopy) {
        if (bytes == null) {
            this._bytes = null;
        } else {
            if (range.maxRange() > bytes.length) {
                throw new IllegalArgumentException("range out of bounds for bytes");
            }
            if (noCopy) {
                if (range.location() == 0 && range.length() == bytes.length) {
                    this._bytes = bytes;
                } else {
                    int length = range.length();
                    this._bytes = new byte[length];
                    if (length > 0) {
                        System.arraycopy(bytes, range.location(), this._bytes, 0, length);
                    }
                }
            } else {
                int length = range.length();
                this._bytes = new byte[length];
                if (length > 0) {
                    System.arraycopy(bytes, range.location(), this._bytes, 0, length);
                }
            }
        }
    }

    public NSData(byte[] bytes, NSRange range, boolean noCopy) {
        this.initFromBytes(bytes, range, noCopy);
    }

    public NSData(NSData otherData) {
        this(otherData.immutableBytes(), otherData.immutableRange(), true);
    }

    public NSData(InputStream inputStream, int chunkSize) throws IOException {
        int theChunkSize = chunkSize < 1 ? 4096 : chunkSize;
        int numberOfChunks = 0;
        int numberOfChunkSlots = 32;
        Object[] chunks = new Object[numberOfChunkSlots];
        int lastChunkLength = 0;
        boolean streamEndReached = false;
        while (!streamEndReached) {
            if (numberOfChunks == numberOfChunkSlots) {
                Object[] oldChunks = chunks;
                chunks = new Object[numberOfChunkSlots *= 2];
                System.arraycopy(oldChunks, 0, chunks, 0, numberOfChunks);
            }
            int length = 0;
            byte[] chunk = new byte[theChunkSize];
            while (length < theChunkSize) {
                int bytesRead = inputStream.read(chunk, length, theChunkSize - length);
                if (bytesRead < 0) {
                    streamEndReached = true;
                    break;
                }
                length += bytesRead;
            }
            if (length <= 0) continue;
            chunks[numberOfChunks] = chunk;
            lastChunkLength = length;
            ++numberOfChunks;
        }
        NSMutableRange range = new NSMutableRange(0, 0);
        if (numberOfChunks == 0) {
            this._bytes = null;
        } else {
            this._bytes = new byte[theChunkSize * (numberOfChunks - 1) + lastChunkLength];
            int i = 0;
            while (i < numberOfChunks - 1) {
                System.arraycopy(chunks[i], 0, this._bytes, range._length, theChunkSize);
                range._length += theChunkSize;
                ++i;
            }
            System.arraycopy(chunks[numberOfChunks - 1], 0, this._bytes, range._length, lastChunkLength);
            range._length += lastChunkLength;
        }
    }

    protected void _createBytesFromInputStream(InputStream inputStream, int length, boolean closeInputStream) throws IOException {
        try {
            this._bytes = new byte[length];
            int offset = 0;
            while (offset < length) {
                int bytesRead = inputStream.read(this._bytes, offset, length - offset);
                if (bytesRead < 0) {
                    throw new IOException("error while reading input stream for new NSData: " + offset + " out of " + length + SerializationBytesFieldKey);
                }
                offset += bytesRead;
            }
        }
        finally {
            if (closeInputStream) {
                inputStream.close();
            }
        }
    }

    public NSData(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("file '" + file.getName() + "' does not exist");
        }
        this._createBytesFromInputStream(new FileInputStream(file), (int)file.length(), true);
    }

    public NSData(URL url) throws IOException {
        this(url.openStream(), (int)NSPathUtilities._contentLengthForPathURL(url));
    }

    @Deprecated
    public NSData(String value) {
        this(value, null);
    }

    public NSData(String value, String encoding) {
        this(_NSStringUtilities.bytesForString(value, encoding));
    }

    protected byte[] bytesNoCopy() {
        return this._bytes != null ? this._bytes : _NSCollectionPrimitives.EmptyByteArray;
    }

    protected NSRange rangeNoCopy() {
        return new NSRange(0, this.length());
    }

    protected byte[] immutableBytes() {
        return this._bytes != null ? this._bytes : _NSCollectionPrimitives.EmptyByteArray;
    }

    protected NSRange immutableRange() {
        return new NSRange(0, this.length());
    }

    public byte[] bytesNoCopy(NSMutableRange range) {
        byte[] returnValue = this.bytesNoCopy();
        if (range == null) {
            throw new IllegalArgumentException("must pass NSMutableRange to bytesNoCopy");
        }
        range.setLocation(0);
        range.setLength(this.length());
        return returnValue;
    }

    public NSData subdataWithRange(NSRange range) {
        int rangeLength;
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > this.length()) {
            throw new IllegalArgumentException("range [" + rangeLocation + "; " + rangeLength + "] out of bounds");
        }
        return new NSData(this.immutableBytes(), new NSRange(this.immutableRange().location() + range.location(), range.length()), true);
    }

    @Deprecated
    public static NSData dataWithContentsOfMappedFile(File file) throws IOException {
        return NSData.dataWithContentsOfFile(file);
    }

    public static NSData dataWithContentsOfFile(File file) throws IOException {
        return new NSData(file);
    }

    public static NSData dataWithContentsOfFile(String path) throws IOException {
        return NSData.dataWithContentsOfFile(new File(path));
    }

    public int length() {
        return this._bytes != null ? this._bytes.length : 0;
    }

    public int _offset() {
        return 0;
    }

    public byte[] _bytesNoCopy() {
        return this.bytesNoCopy();
    }

    private byte[] _bytes(int offset, int length) {
        byte[] bytes = new byte[length];
        if (length > 0) {
            System.arraycopy(this.bytesNoCopy(), this._offset() + offset, bytes, 0, length);
        }
        return bytes;
    }

    public byte[] bytes() {
        return this._bytes(0, this.length());
    }

    public byte[] bytes(int offset, int length) {
        if (offset + length > this.length()) {
            throw new IllegalArgumentException("range [" + offset + "; " + length + "] out of bounds");
        }
        return this._bytes(offset, length);
    }

    public byte[] bytes(NSRange range) {
        return this.bytes(range.location(), range.length());
    }

    @Deprecated
    public boolean writeToURL(URL url, boolean atomically) {
        if (url.getHost().equals("")) {
            return this.writeToFile(url.getFile());
        }
        return false;
    }

    public void writeToFile(File file) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.bytesNoCopy(), this._offset(), this.length());
        }
    }

    @Deprecated
    public boolean writeToFile(String path) {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(path);
                fileOutputStream.write(this.bytesNoCopy(), this._offset(), this.length());
            }
            catch (IOException e) {
                log.debug("An exception occurred", (Throwable)e);
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e2) {
                        log.debug("An exception occurred", (Throwable)e2);
                        return false;
                    }
                }
                return false;
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    log.debug("An exception occurred", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isEqualToData(NSData otherData) {
        if (otherData == null) {
            return false;
        }
        if (otherData == this) {
            return true;
        }
        int length = this.length();
        if (length != otherData.length()) {
            return false;
        }
        byte[] bytes = this.bytesNoCopy();
        byte[] otherBytes = otherData.bytesNoCopy();
        int offset = this._offset();
        int otherOffset = otherData._offset();
        int i = 0;
        while (i < length) {
            if (bytes[i + offset] != otherBytes[i + otherOffset]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof NSData ? this.isEqualToData((NSData)object) : false;
    }

    public ByteArrayInputStream stream() {
        byte[] bytes = this.immutableBytes();
        NSRange range = this.immutableRange();
        return new ByteArrayInputStream(bytes, range.location(), range.length());
    }

    public void writeToStream(OutputStream stream) throws IOException {
        stream.write(this.bytesNoCopy(), this._offset(), this.length());
    }

    @Override
    public Class<?> classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        return new NSData(coder.decodeBytes());
    }

    @Override
    public void encodeWithCoder(NSCoder coder) {
        byte[] bytesNoCopy = this.bytesNoCopy();
        byte[] bytes = this.length() == bytesNoCopy.length && this._offset() == 0 ? bytesNoCopy : this.bytes();
        coder.encodeBytes(bytes);
    }

    public int hashCode() {
        if (this._mustRecomputeHash()) {
            int limit;
            byte[] bytes = this.bytesNoCopy();
            int offset = this._offset();
            int hash = limit = this.length();
            if (limit > 32) {
                limit = 32;
            }
            int i = 0;
            while (i < limit) {
                hash = 31 * hash + bytes[offset++];
                ++i;
            }
            this._hashCache = hash;
            this._setMustRecomputeHash(false);
        }
        return this._hashCache;
    }

    public ByteBuffer toByteBuffer() {
        byte[] theBytes = this.immutableBytes();
        ByteBuffer buffer = ByteBuffer.allocate(theBytes.length);
        buffer.put(theBytes);
        buffer.flip();
        return buffer;
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        if (this.length() == 0) {
            return "<" + this.getClass().getSimpleName() + ": (empty)>";
        }
        int offset = this._offset();
        int length = this.length();
        byte[] bytes = this.bytesNoCopy();
        StringBuffer buffer = new StringBuffer("<" + this.getClass().getSimpleName() + ": " + offset + "/" + length + "/");
        int i = 0;
        while (i < length && i < 24) {
            byte b = bytes[i + offset];
            buffer.append(_nibbleToHex[0xF & b >> 4]);
            buffer.append(_nibbleToHex[0xF & b]);
            ++i;
        }
        if (i < length) {
            buffer.append("...");
        }
        buffer.append(">");
        return new String(buffer);
    }

    public String _hexString() {
        byte[] bytes = this.bytes();
        StringBuilder result = new StringBuilder(2 * this.length());
        int i = 0;
        while (i < this.length()) {
            byte b = bytes[i];
            result.append(_nibbleToHex[0xF & b >> 4]);
            result.append(_nibbleToHex[0xF & b]);
            ++i;
        }
        return result.toString();
    }

    protected boolean _mustRecomputeHash() {
        return this._recomputeHashCode;
    }

    protected void _setMustRecomputeHash(boolean change) {
        this._recomputeHashCode = change;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationBytesFieldKey, this.bytes());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        byte[] bytes = (byte[])fields.get(SerializationBytesFieldKey, _NSUtilities._NoByteArray);
        bytes = bytes == null ? _NSUtilities._NoByteArray : bytes;
        this.initFromBytes(bytes, new NSRange(0, bytes.length), false);
        this._recomputeHashCode = true;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.length() == 0) {
            return EmptyData;
        }
        return this;
    }
}

