/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation._NSLZ4;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class NSCompressedString
implements Comparable<CharSequence>,
CharSequence {
    private final int _hashCode;
    private final int _byteLength;
    private final int _stringLength;
    private final ByteBuffer _compressedData;
    private volatile transient Reference<String> _uncompressedRef;

    public NSCompressedString(CharSequence value) {
        if (value == null) {
            throw new IllegalArgumentException("CharSequence value cannot be null");
        }
        String string = value.toString();
        this._hashCode = string.hashCode();
        this._uncompressedRef = new SoftReference<String>(string);
        Charset encodingCharset = Charset.forName("UTF8");
        byte[] bytes = encodingCharset != null ? string.getBytes(encodingCharset) : string.getBytes();
        this._byteLength = bytes.length;
        this._stringLength = string.length();
        ByteBuffer out = ByteBuffer.allocate(this._byteLength + 3);
        try {
            _NSLZ4.compressHC(bytes, 0, this._byteLength, out);
            out.flip();
            this._compressedData = ByteBuffer.allocate(out.limit()).put(out).asReadOnlyBuffer();
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    @Override
    public String toString() {
        String value = this._uncompressedRef != null ? this._uncompressedRef.get() : null;
        return value != null ? value : this._uncompressedString();
    }

    private synchronized String _uncompressedString() {
        String value;
        String string = value = this._uncompressedRef != null ? this._uncompressedRef.get() : null;
        if (value == null) {
            byte[] out = new byte[this._byteLength];
            try {
                this._compressedData.position(0);
                _NSLZ4.decompress(this._compressedData, this._byteLength, out, 0);
                Charset encodingCharset = Charset.forName("UTF8");
                value = encodingCharset != null ? new String(out, encodingCharset) : new String(out);
                this._uncompressedRef = new SoftReference<String>(value);
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
        return value;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NSCompressedString) {
            NSCompressedString cs = (NSCompressedString)obj;
            return obj == this || this._hashCode == cs._hashCode && this._compressedData.equals(cs._compressedData);
        }
        return false;
    }

    public boolean contentEquals(CharSequence cs) {
        if (cs.length() != this.length()) {
            return false;
        }
        return this.equals(cs) || this.toString().contentEquals(cs);
    }

    public int compressedLength() {
        return this._compressedData.limit();
    }

    public static NSCompressedString valueOf(Object obj) {
        if (obj == null || obj instanceof NSCompressedString) {
            return (NSCompressedString)obj;
        }
        return new NSCompressedString(obj.toString());
    }

    @Override
    public int length() {
        return this._stringLength;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public int compareTo(CharSequence o) {
        return this.toString().compareTo(o.toString());
    }
}

