/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface NSCompoundKeyMap<V>
extends Map<NSCompoundKey, V> {
    public V objectForKeys(Object ... var1);

    public V removeObjectForKeys(Object ... var1);

    public V setObjectForKey(V var1, Object ... var2);

    public static class NSCompoundKey
    implements Cloneable {
        static final Object NullKey = "NSCompoundKey.NullKey";
        protected int _hashcode;
        static final int[] PrimeNumbers = new int[]{1, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997};
        protected Object[] _keys;

        NSCompoundKey(Object ... keys) {
            this.init(keys);
        }

        public int hashCode() {
            return this._hashcode;
        }

        public boolean equals(Object otherObject) {
            if (!(otherObject instanceof NSCompoundKey)) {
                return false;
            }
            if (this.hashCode() != otherObject.hashCode()) {
                return false;
            }
            NSCompoundKey otherKey = (NSCompoundKey)otherObject;
            int i = 0;
            while (i < this._keys.length) {
                if (!this._keys[i].equals(otherKey._keys[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        static Object _checkKey(Object value) {
            return value == null ? NullKey : value;
        }

        static NSCompoundKey newInstance(Object ... keys) {
            if (keys == null) {
                throw new UnsupportedOperationException();
            }
            switch (keys.length) {
                case 2: {
                    return new NSCompoundKey2(keys[0], keys[1]);
                }
                case 3: {
                    return new NSCompoundKey3(keys[0], keys[1], keys[2]);
                }
                case 4: {
                    return new NSCompoundKey4(keys[0], keys[1], keys[2], keys[3]);
                }
            }
            return new NSCompoundKey(keys);
        }

        void init(Object ... keys) {
            if (keys == null) {
                throw new UnsupportedOperationException("Compounds keys cannot be null.");
            }
            Object[] initKeys = new Object[keys.length];
            int i = 0;
            while (i < keys.length) {
                initKeys[i] = NSCompoundKey._checkKey(keys[i]);
                ++i;
            }
            this._keys = initKeys;
            int hashcode = 0;
            int i2 = 0;
            while (i2 < this._keys.length) {
                hashcode ^= this._keys[i2].hashCode() * PrimeNumbers[i2];
                ++i2;
            }
            this._hashcode = hashcode;
        }

        NSCompoundKey shallowCopy() {
            NSCompoundKey clone;
            try {
                clone = (NSCompoundKey)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                clone = null;
            }
            return clone;
        }

        public Object key(int index) {
            if (index >= this._keys.length) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return this._keys[index];
        }

        public int keyCount() {
            return this._keys.length;
        }

        private static final class NSCompoundKey2
        extends NSCompoundKey {
            private Object _key1;
            private Object _key2;

            NSCompoundKey2(Object key1, Object key2) {
                super(new Object[0]);
                this.init(key1, key2);
            }

            @Override
            void init(Object ... keys) {
                int hashcode;
                if (keys == null || keys.length != 2) {
                    throw new UnsupportedOperationException();
                }
                this._key1 = NSCompoundKey._checkKey(keys[0]);
                this._key2 = NSCompoundKey._checkKey(keys[1]);
                this._hashcode = hashcode = this._key1.hashCode() ^ this._key2.hashCode() * PrimeNumbers[1];
            }

            @Override
            public boolean equals(Object otherObject) {
                boolean result = false;
                if (otherObject instanceof NSCompoundKey2) {
                    NSCompoundKey2 otherKey = (NSCompoundKey2)otherObject;
                    result = this._key1.equals(otherKey._key1) && this._key2.equals(otherKey._key2);
                }
                return result;
            }

            @Override
            public Object key(int index) {
                if (index == 0) {
                    return this._key1;
                }
                if (index == 1) {
                    return this._key2;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int keyCount() {
                return 2;
            }
        }

        private static final class NSCompoundKey3
        extends NSCompoundKey {
            private Object _key1;
            private Object _key2;
            private Object _key3;

            NSCompoundKey3(Object key1, Object key2, Object key3) {
                super(new Object[0]);
                this.init(key1, key2, key3);
            }

            @Override
            void init(Object ... keys) {
                int hashcode;
                if (keys == null || keys.length != 3) {
                    throw new UnsupportedOperationException();
                }
                this._key1 = NSCompoundKey._checkKey(keys[0]);
                this._key2 = NSCompoundKey._checkKey(keys[1]);
                this._key3 = NSCompoundKey._checkKey(keys[2]);
                this._hashcode = hashcode = this._key1.hashCode() ^ this._key2.hashCode() * PrimeNumbers[1] ^ this._key3.hashCode() * PrimeNumbers[2];
            }

            @Override
            public boolean equals(Object otherObject) {
                boolean result = false;
                if (otherObject instanceof NSCompoundKey3) {
                    NSCompoundKey3 otherKey = (NSCompoundKey3)otherObject;
                    result = this._key1.equals(otherKey._key1) && this._key2.equals(otherKey._key2) && this._key3.equals(otherKey._key3);
                }
                return result;
            }

            @Override
            public Object key(int index) {
                if (index == 0) {
                    return this._key1;
                }
                if (index == 1) {
                    return this._key2;
                }
                if (index == 2) {
                    return this._key3;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int keyCount() {
                return 3;
            }
        }

        private static final class NSCompoundKey4
        extends NSCompoundKey {
            private Object _key1;
            private Object _key2;
            private Object _key3;
            private Object _key4;

            NSCompoundKey4(Object key1, Object key2, Object key3, Object key4) {
                super(new Object[0]);
                this.init(key1, key2, key3, key4);
            }

            @Override
            void init(Object ... keys) {
                int hashcode;
                if (keys == null || keys.length != 4) {
                    throw new UnsupportedOperationException();
                }
                this._key1 = NSCompoundKey._checkKey(keys[0]);
                this._key2 = NSCompoundKey._checkKey(keys[1]);
                this._key3 = NSCompoundKey._checkKey(keys[2]);
                this._key4 = NSCompoundKey._checkKey(keys[3]);
                this._hashcode = hashcode = this._key1.hashCode() ^ this._key2.hashCode() * PrimeNumbers[1] ^ this._key3.hashCode() * PrimeNumbers[2] ^ this._key4.hashCode() * PrimeNumbers[3];
            }

            @Override
            public boolean equals(Object otherObject) {
                boolean result = false;
                if (otherObject instanceof NSCompoundKey4) {
                    NSCompoundKey4 otherKey = (NSCompoundKey4)otherObject;
                    result = this._key1.equals(otherKey._key1) && this._key2.equals(otherKey._key2) && this._key3.equals(otherKey._key3) && this._key4.equals(otherKey._key4);
                }
                return result;
            }

            @Override
            public Object key(int index) {
                if (index == 0) {
                    return this._key1;
                }
                if (index == 1) {
                    return this._key2;
                }
                if (index == 2) {
                    return this._key3;
                }
                if (index == 3) {
                    return this._key4;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int keyCount() {
                return 4;
            }
        }
    }

    public static class SharedKeyStorage {
        private static final ThreadLocal<NSCompoundKey.NSCompoundKey2> SharedCompoundKey2 = new ThreadLocal();
        private static final ThreadLocal<NSCompoundKey.NSCompoundKey3> SharedCompoundKey3 = new ThreadLocal();
        private static final ThreadLocal<NSCompoundKey.NSCompoundKey4> SharedCompoundKey4 = new ThreadLocal();
        private static final Map<Integer, ThreadLocal<NSCompoundKey>> SharedCompoundKeys = new ConcurrentHashMap<Integer, ThreadLocal<NSCompoundKey>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static NSCompoundKey sharedCompoundKey(Object ... keys) {
            NSCompoundKey sharedCompoundKey;
            switch (keys.length) {
                case 2: {
                    return SharedKeyStorage.sharedCompoundKey2(keys[0], keys[1]);
                }
                case 3: {
                    return SharedKeyStorage.sharedCompoundKey3(keys[0], keys[1], keys[2]);
                }
                case 4: {
                    return SharedKeyStorage.sharedCompoundKey4(keys[0], keys[1], keys[2], keys[3]);
                }
            }
            Integer keySize = keys.length;
            ThreadLocal<NSCompoundKey> sharedCompoundKeyStorage = SharedCompoundKeys.get(keySize);
            if (sharedCompoundKeyStorage == null) {
                Map<Integer, ThreadLocal<NSCompoundKey>> map = SharedCompoundKeys;
                synchronized (map) {
                    sharedCompoundKeyStorage = SharedCompoundKeys.get(keySize);
                    if (sharedCompoundKeyStorage == null) {
                        sharedCompoundKeyStorage = new ThreadLocal();
                        SharedCompoundKeys.put(keySize, sharedCompoundKeyStorage);
                    }
                }
            }
            if ((sharedCompoundKey = sharedCompoundKeyStorage.get()) == null) {
                sharedCompoundKey = NSCompoundKey.newInstance(keys);
                sharedCompoundKeyStorage.set(sharedCompoundKey);
            } else {
                sharedCompoundKey.init(keys);
            }
            return sharedCompoundKey;
        }

        private static NSCompoundKey sharedCompoundKey2(Object key1, Object key2) {
            NSCompoundKey.NSCompoundKey2 sharedCompoundKey = SharedCompoundKey2.get();
            if (sharedCompoundKey == null) {
                sharedCompoundKey = (NSCompoundKey.NSCompoundKey2)NSCompoundKey.newInstance(key1, key2);
                SharedCompoundKey2.set(sharedCompoundKey);
            } else {
                sharedCompoundKey.init(key1, key2);
            }
            return sharedCompoundKey;
        }

        private static NSCompoundKey sharedCompoundKey3(Object key1, Object key2, Object key3) {
            NSCompoundKey.NSCompoundKey3 sharedCompundKey = SharedCompoundKey3.get();
            if (sharedCompundKey == null) {
                sharedCompundKey = (NSCompoundKey.NSCompoundKey3)NSCompoundKey.newInstance(key1, key2, key3);
                SharedCompoundKey3.set(sharedCompundKey);
            } else {
                sharedCompundKey.init(key1, key2, key3);
            }
            return sharedCompundKey;
        }

        private static NSCompoundKey sharedCompoundKey4(Object key1, Object key2, Object key3, Object key4) {
            NSCompoundKey.NSCompoundKey4 sharedCompundKey = SharedCompoundKey4.get();
            if (sharedCompundKey == null) {
                sharedCompundKey = (NSCompoundKey.NSCompoundKey4)NSCompoundKey.newInstance(key1, key2, key3, key4);
                SharedCompoundKey4.set(sharedCompundKey);
            } else {
                sharedCompundKey.init(key1, key2, key3, key4);
            }
            return sharedCompundKey;
        }
    }
}

