/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSUtilities;
import java.lang.reflect.InvocationTargetException;

public abstract class NSComparator {
    public static final Class<NSComparator> _CLASS = _NSUtilities._classWithClassLiteral(NSComparator.class);
    public static final NSComparator AscendingStringComparator = new _StringComparator(true, false);
    public static final NSComparator DescendingStringComparator = new _StringComparator(false, false);
    public static final NSComparator AscendingCaseInsensitiveStringComparator = new _StringComparator(true, true);
    public static final NSComparator DescendingCaseInsensitiveStringComparator = new _StringComparator(false, true);
    public static final NSComparator AscendingNumberComparator = new _NumberComparator(true);
    public static final NSComparator DescendingNumberComparator = new _NumberComparator(false);
    public static final NSComparator AscendingTimestampComparator = new _TimestampComparator(true);
    public static final NSComparator DescendingTimestampComparator = new _TimestampComparator(false);
    public static final int OrderedAscending = -1;
    public static final int OrderedSame = 0;
    public static final int OrderedDescending = 1;

    public abstract int compare(Object var1, Object var2) throws ComparisonException;

    public static <T extends Comparable<? super T>> int _compareObjects(T object1, T object2) {
        if (object1 == object2) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        int comparison = object1.compareTo(object2);
        if (comparison < 0) {
            return -1;
        }
        if (comparison > 0) {
            return 1;
        }
        return 0;
    }

    public static class ComparisonException
    extends Exception {
        private static final long serialVersionUID = -2282920745493922488L;

        public ComparisonException(String message) {
            super(message);
        }
    }

    protected static class _NSSelectorComparator
    extends NSComparator {
        NSSelector<Integer> _selector;
        Class<?> _objectsClass;

        public _NSSelectorComparator(NSSelector<Integer> selector) {
            if (selector == null) {
                throw new IllegalArgumentException("Selector not specified");
            }
            this._selector = selector;
            Class<?>[] types = this._selector.parameterTypes();
            this._objectsClass = types.length != 0 ? types[0] : null;
        }

        private void _computeObjectsClassFromObjects(Object object1, Object object2) {
            Class<?> object1Class = object1.getClass();
            Class<?> object2Class = object2.getClass();
            while (object1Class != object2Class) {
                if (object2Class == _NSUtilities._ObjectClass) continue;
                object2Class = object2Class.getSuperclass();
            }
            if (object1Class != object2Class) {
                object2Class = object2.getClass();
                while (object1Class != object2Class) {
                    if (object1Class == _NSUtilities._ObjectClass) continue;
                    object1Class = object1Class.getSuperclass();
                }
            }
            this._objectsClass = object1Class;
            this._selector = new NSSelector(this._selector.name(), this._objectsClass);
        }

        @Override
        public int compare(Object object1, Object object2) throws ComparisonException {
            if (object1 == object2) {
                return 0;
            }
            if (object1 == null || object2 == null) {
                throw new ComparisonException("Unable to compare objects as one of the is null.");
            }
            if (this._objectsClass == null) {
                this._computeObjectsClassFromObjects(object1, object2);
            }
            if (!this._objectsClass.isInstance(object1) || !this._objectsClass.isInstance(object2)) {
                throw new ComparisonException("Unable to compare objects. Objects should be instance of class " + this._objectsClass + ". Comparison was made with " + object1 + " and " + object2 + ".");
            }
            int result = 0;
            try {
                result = ((Number)this._selector.invoke(object1, object2)).intValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ComparisonException("<" + this.getClass().getName() + "> Could not invoke comparison selector " + this._selector.name() + "(" + object1.getClass().getName() + ") on object \n" + object1.toString() + "\nas it is not public.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ComparisonException("<" + this.getClass().getName() + "> Could not invoke comparison selector " + this._selector.name() + "(" + object1.getClass().getName() + ") on object \n" + object1.toString() + "\nhas wrong number of arguments, or the argument's class is incorrect.");
            }
            catch (InvocationTargetException e) {
                throw new ComparisonException("<" + this.getClass().getName() + "> Invoking comparison selector " + this._selector.name() + "(" + object1.getClass().getName() + ") on object \n" + object1.toString() + "\n raised an Exception:\n" + e.getTargetException().toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ComparisonException("<" + this.getClass().getName() + "> Could not invoke comparison selector " + this._selector.name() + "(" + object1.getClass().getName() + ") on object \n" + object1.toString() + "\nas it does not exist.");
            }
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
    }

    private static class _NumberComparator
    extends NSComparator {
        private boolean _ascending;

        public _NumberComparator() {
            this(true);
        }

        public _NumberComparator(boolean ascending) {
            this._ascending = ascending;
        }

        @Override
        public int compare(Object object1, Object object2) throws ComparisonException {
            double value2;
            if (object1 == null || object2 == null || !(object1 instanceof Number) || !(object2 instanceof Number)) {
                throw new ComparisonException("Unable to compare objects. Objects should be instance of class Number. Comparison was made with " + object1 + " and " + object2 + ".");
            }
            if (object1 == object2 || object1.equals(object2)) {
                return 0;
            }
            double value1 = ((Number)object1).doubleValue();
            if (value1 < (value2 = ((Number)object2).doubleValue())) {
                return this._ascending ? -1 : 1;
            }
            return this._ascending ? 1 : -1;
        }
    }

    private static class _StringComparator
    extends NSComparator {
        private boolean _ascending;
        private boolean _caseInsensitive;

        public _StringComparator() {
            this(true, false);
        }

        public _StringComparator(boolean ascending, boolean caseInsensitive) {
            this._ascending = ascending;
            this._caseInsensitive = caseInsensitive;
        }

        @Override
        public int compare(Object object1, Object object2) throws ComparisonException {
            if (object1 == null || object2 == null || !(object1 instanceof String) || !(object2 instanceof String)) {
                throw new ComparisonException("Unable to compare objects. Objects should be instance of class String. Comparison was made with " + object1 + " and " + object2 + ".");
            }
            if (object1 == object2) {
                return 0;
            }
            int result = 0;
            result = this._caseInsensitive ? ((String)object1).toUpperCase().compareTo(((String)object2).toUpperCase()) : ((String)object1).compareTo((String)object2);
            if (result < 0) {
                return this._ascending ? -1 : 1;
            }
            if (result > 0) {
                return this._ascending ? 1 : -1;
            }
            return 0;
        }
    }

    private static class _TimestampComparator
    extends NSComparator {
        private boolean _ascending;

        public _TimestampComparator() {
            this(true);
        }

        public _TimestampComparator(boolean ascending) {
            this._ascending = ascending;
        }

        @Override
        public int compare(Object object1, Object object2) throws ComparisonException {
            if (object1 == null || object2 == null || !(object1 instanceof NSTimestamp) || !(object2 instanceof NSTimestamp)) {
                throw new ComparisonException("Unable to compare objects. Objects should be instance of class NSTimestamp. Comparison was made with " + object1 + " and " + object2 + ".");
            }
            if (object1 == object2 || object1.equals(object2)) {
                return 0;
            }
            if (((NSTimestamp)object1).before((NSTimestamp)object2)) {
                return this._ascending ? -1 : 1;
            }
            return this._ascending ? 1 : -1;
        }
    }
}

