/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public interface NSCoding {
    public static final Class<NSCoding> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSCoding.class);

    public Class<?> classForCoder();

    public void encodeWithCoder(NSCoder var1);

    public static abstract class Support<T> {
        private static NSMutableDictionary<Class<?>, Support<?>> _supportByClass = new NSMutableDictionary(16);
        private static final String _UTF8StringEncoding = "UTF8";

        static {
            Support.setSupportForClass(new _StringSupport(), _NSUtilities._StringClass);
            Support.setSupportForClass(new _BooleanSupport(), _NSUtilities._BooleanClass);
            Support.setSupportForClass(new _NumberSupport(), _NSUtilities._NumberClass);
            Support.setSupportForClass(new _ByteSupport(), _NSUtilities._ByteClass);
            Support.setSupportForClass(new _ShortSupport(), _NSUtilities._ShortClass);
            Support.setSupportForClass(new _IntegerSupport(), _NSUtilities._IntegerClass);
            Support.setSupportForClass(new _LongSupport(), _NSUtilities._LongClass);
            Support.setSupportForClass(new _FloatSupport(), _NSUtilities._FloatClass);
            Support.setSupportForClass(new _DoubleSupport(), _NSUtilities._DoubleClass);
            Support.setSupportForClass(new _BigIntegerSupport(), _NSUtilities._BigIntegerClass);
            Support.setSupportForClass(new _BigDecimalSupport(), _NSUtilities._BigDecimalClass);
            Support.setSupportForClass(new _DateSupport(), _NSUtilities._DateClass);
            Support.setSupportForClass(new _CharacterSupport(), _NSUtilities._CharacterClass);
        }

        public static <T> Support<? super T> supportForClass(Class<? extends T> aClass) {
            Support result = null;
            Class<T> currentClass = aClass;
            while (result == null && currentClass != null) {
                Support supportForClass = (Support)_supportByClass.objectForKey(currentClass);
                result = supportForClass;
                if (result == null) {
                    currentClass = currentClass.getSuperclass();
                    continue;
                }
                if (currentClass == aClass) continue;
                _supportByClass.setObjectForKey(result, aClass);
            }
            return result;
        }

        public static <T> void setSupportForClass(Support<? super T> support, Class<? extends T> aClass) {
            _supportByClass.setObjectForKey(support, aClass);
        }

        public Class<?> classForCoder(T receiver) {
            return receiver.getClass();
        }

        public abstract void encodeWithCoder(T var1, NSCoder var2);

        public abstract T decodeObject(NSCoder var1);

        protected static void _encodeUTF8(String string, NSCoder coder) {
            byte[] bytes = null;
            try {
                bytes = string.getBytes(_UTF8StringEncoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
            coder.encodeBytes(bytes);
        }

        protected static String _decodeUTF8(NSCoder coder) {
            String result;
            byte[] bytes = coder.decodeBytes();
            try {
                result = new String(bytes, _UTF8StringEncoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
            return result;
        }
    }

    public static abstract class _AbstractNumberSupport<T extends Number>
    extends Support<T> {
        Class<T> _numberClass;

        _AbstractNumberSupport(Class<T> numberClass) {
            this._numberClass = numberClass;
        }

        @Override
        public Class<?> classForCoder(T receiver) {
            return _NSUtilities._NumberClass;
        }

        @Override
        public T decodeObject(NSCoder coder) {
            return (T)((Number)this._numberClass.cast(_AbstractNumberSupport._decodeNumber(coder)));
        }

        static Number _decodeNumber(NSCoder coder) {
            String type = _AbstractNumberSupport._decodeUTF8(coder);
            switch (type.charAt(0)) {
                case 'c': {
                    return coder.decodeByte();
                }
                case 's': {
                    return coder.decodeShort();
                }
                case 'i': {
                    return coder.decodeInt();
                }
                case 'l': {
                    return coder.decodeLong();
                }
                case 'f': {
                    return Float.valueOf(coder.decodeFloat());
                }
                case 'd': {
                    return coder.decodeDouble();
                }
            }
            throw new IllegalStateException("decodeObject: unsupported number type: " + type);
        }
    }

    public static class _BigDecimalSupport
    extends Support<BigDecimal> {
        private static final int _MaxMantissaSize = 16;
        private static final int _MaxByteDifference = 127;
        private static final double _LnTen = Math.log(10.0);

        private double _logBaseTen(double value) {
            return Math.log(value) / _LnTen;
        }

        @Override
        public void encodeWithCoder(BigDecimal receiver, NSCoder coder) {
            int byteLength;
            int scale = receiver.scale();
            BigInteger mantissa = receiver.movePointRight(scale).toBigInteger();
            while ((byteLength = mantissa.bitLength() / 8 + 1) > 16) {
                int byteDifference = byteLength - 16;
                if (byteDifference > 127) {
                    byteDifference = 127;
                }
                int exponentDelta = (int)this._logBaseTen(Math.pow(2.0, 8 * byteDifference));
                BigInteger divisor = new BigInteger("10").pow(exponentDelta);
                scale -= exponentDelta;
                mantissa = mantissa.divide(divisor);
            }
            coder.encodeInt(-scale);
            _BigIntegerSupport._encodeBigInteger(coder, mantissa);
        }

        @Override
        public BigDecimal decodeObject(NSCoder coder) {
            int exponent = coder.decodeInt();
            BigInteger mantissa = _BigIntegerSupport._decodeBigInteger(coder, exponent > 0 ? exponent : 0);
            return new BigDecimal(mantissa, exponent > 0 ? 0 : -exponent);
        }
    }

    public static class _BigIntegerSupport
    extends Support<BigInteger> {
        private static final int _MaxShortArrayLength = 8;

        @Override
        public void encodeWithCoder(BigInteger receiver, NSCoder coder) {
            coder.encodeInt(0);
            _BigIntegerSupport._encodeBigInteger(coder, receiver);
        }

        @Override
        public BigInteger decodeObject(NSCoder coder) {
            int exponent = coder.decodeInt();
            return _BigIntegerSupport._decodeBigInteger(coder, exponent);
        }

        private static void _copyIntToByteArray(int anInt, byte[] bytes, int offset) {
            bytes[offset] = (byte)(anInt >>> 24 & 0xFF);
            bytes[offset + 1] = (byte)(anInt >>> 16 & 0xFF);
            bytes[offset + 2] = (byte)(anInt >>> 8 & 0xFF);
            bytes[offset + 3] = (byte)(anInt & 0xFF);
        }

        private static void _copyShortToByteArray(short aShort, byte[] bytes, int offset) {
            bytes[offset] = (byte)(aShort >>> 8);
            bytes[offset + 1] = (byte)aShort;
        }

        private static short _shortFromByteArray(byte[] bytes, int offset) {
            int high = offset >= 0 ? (int)bytes[offset] : 0;
            short low = bytes[offset + 1];
            if (low < 0) {
                low = (short)(low + 256);
            }
            return (short)((high << 8) + low);
        }

        protected static void _encodeBigInteger(NSCoder coder, BigInteger bigInteger) {
            boolean isNegative;
            BigInteger integer = bigInteger;
            boolean bl = isNegative = integer.signum() < 0;
            if (isNegative) {
                integer = integer.negate();
            }
            byte[] bytes = integer.toByteArray();
            int length = bytes.length;
            int shortCount = length / 2 + length % 2;
            coder.encodeShort((short)shortCount);
            coder.encodeBoolean(isNegative);
            coder.encodeBoolean(false);
            coder.encodeInt(8);
            int i = 0;
            while (i < 8) {
                if (i < shortCount) {
                    coder.encodeShort(_BigIntegerSupport._shortFromByteArray(bytes, length - 2 * (i + 1)));
                } else {
                    coder.encodeShort((short)0);
                }
                ++i;
            }
        }

        protected static BigInteger _decodeBigInteger(NSCoder coder, int exponent) {
            short length = coder.decodeShort();
            boolean isNegative = coder.decodeBoolean();
            coder.decodeBoolean();
            int shortCount = coder.decodeInt();
            byte[] bytes = new byte[length * 2];
            int i = 0;
            while (i < shortCount) {
                short part = coder.decodeShort();
                if (i < length) {
                    _BigIntegerSupport._copyShortToByteArray(part, bytes, (length - (i + 1)) * 2);
                }
                ++i;
            }
            BigInteger result = new BigInteger(isNegative ? -1 : 1, bytes);
            if (exponent != 0) {
                bytes = new byte[4];
                int powerOfTen = 10;
                i = 1;
                while (i < exponent) {
                    powerOfTen *= 10;
                    ++i;
                }
                _BigIntegerSupport._copyIntToByteArray(powerOfTen, bytes, 0);
                BigInteger factor = new BigInteger(bytes);
                result = exponent > 0 ? result.multiply(factor) : result.divide(factor);
            }
            return result;
        }
    }

    public static class _BooleanSupport
    extends Support<Boolean> {
        @Override
        public void encodeWithCoder(Boolean receiver, NSCoder coder) {
            coder.encodeBoolean(receiver);
        }

        @Override
        public Boolean decodeObject(NSCoder coder) {
            return coder.decodeBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class _ByteSupport
    extends _AbstractNumberSupport<Byte> {
        _ByteSupport() {
            super(Byte.class);
        }

        @Override
        public void encodeWithCoder(Byte receiver, NSCoder coder) {
            _ByteSupport._encodeUTF8("c", coder);
            coder.encodeByte(receiver);
        }
    }

    public static class _CharacterSupport
    extends Support<Character> {
        @Override
        public void encodeWithCoder(Character receiver, NSCoder coder) {
            coder.encodeChar(receiver.charValue());
        }

        @Override
        public Character decodeObject(NSCoder coder) {
            return Character.valueOf(coder.decodeChar());
        }
    }

    public static class _DateSupport
    extends Support<Date> {
        @Override
        public void encodeWithCoder(Date receiver, NSCoder coder) {
            long milliseconds = receiver.getTime();
            double seconds = milliseconds / 1000L;
            coder.encodeDouble(seconds);
        }

        @Override
        public Date decodeObject(NSCoder coder) {
            double seconds = coder.decodeDouble();
            long milliseconds = (long)seconds * 1000L;
            return new Date(milliseconds);
        }
    }

    public static class _DoubleSupport
    extends _AbstractNumberSupport<Double> {
        _DoubleSupport() {
            super(Double.class);
        }

        @Override
        public void encodeWithCoder(Double receiver, NSCoder coder) {
            _DoubleSupport._encodeUTF8("d", coder);
            coder.encodeDouble(receiver);
        }
    }

    public static class _FloatSupport
    extends _AbstractNumberSupport<Float> {
        _FloatSupport() {
            super(Float.class);
        }

        @Override
        public void encodeWithCoder(Float receiver, NSCoder coder) {
            _FloatSupport._encodeUTF8("f", coder);
            coder.encodeFloat(receiver.floatValue());
        }
    }

    public static class _IntegerSupport
    extends _AbstractNumberSupport<Integer> {
        _IntegerSupport() {
            super(Integer.class);
        }

        @Override
        public void encodeWithCoder(Integer receiver, NSCoder coder) {
            _IntegerSupport._encodeUTF8("i", coder);
            coder.encodeInt(receiver);
        }
    }

    public static class _LongSupport
    extends _AbstractNumberSupport<Long> {
        _LongSupport() {
            super(Long.class);
        }

        @Override
        public void encodeWithCoder(Long receiver, NSCoder coder) {
            _LongSupport._encodeUTF8("l", coder);
            coder.encodeLong(receiver);
        }
    }

    public static class _NumberSupport
    extends _AbstractNumberSupport<Number> {
        _NumberSupport() {
            super(Number.class);
        }

        @Override
        public void encodeWithCoder(Number receiver, NSCoder coder) {
            Class<?> receiverClass = receiver.getClass();
            throw new IllegalArgumentException("Please register support for the following Number subclass: " + receiverClass.getName());
        }

        @Override
        public Number decodeObject(NSCoder coder) {
            return _NumberSupport._decodeNumber(coder);
        }
    }

    public static class _ShortSupport
    extends _AbstractNumberSupport<Short> {
        _ShortSupport() {
            super(Short.class);
        }

        @Override
        public void encodeWithCoder(Short receiver, NSCoder coder) {
            _ShortSupport._encodeUTF8("s", coder);
            coder.encodeShort(receiver);
        }
    }

    public static class _StringSupport
    extends Support<String> {
        @Override
        public void encodeWithCoder(String receiver, NSCoder coder) {
            _StringSupport._encodeUTF8(receiver, coder);
        }

        @Override
        public String decodeObject(NSCoder coder) {
            return _StringSupport._decodeUTF8(coder);
        }
    }
}

