/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.properties.NSBooleanProperty;
import com.webobjects.foundation.properties.NSStringProperty;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSCheckFix {
    private static final Logger log = LoggerFactory.getLogger(NSCheckFix.class);
    private static final ConcurrentHashMap<Integer, NSBooleanProperty> _propertyKeyForRadarNumber = new ConcurrentHashMap();
    private static final NSStringProperty branchNameProperty = new NSStringProperty("build.branch", "0A");

    public static boolean fixEnabledForRadar(int radarNumber) {
        NSBooleanProperty property = _propertyKeyForRadarNumber.get(radarNumber);
        if (property == null) {
            property = new NSBooleanProperty("NSCheckFix." + radarNumber, true);
            _propertyKeyForRadarNumber.put(radarNumber, property);
        }
        return property.value();
    }

    public static boolean fixDisabledForRadar(int radarNumber) {
        return !NSCheckFix.fixEnabledForRadar(radarNumber);
    }

    public static boolean fixEnabledForRadar(int radarNumber, String branchNameInWhichToCleanupCheckFixCall) {
        NSCheckFix.warnAboutOldCheckFixCalls(radarNumber, branchNameInWhichToCleanupCheckFixCall);
        return NSCheckFix.fixEnabledForRadar(radarNumber);
    }

    public static boolean fixDisabledForRadar(int radarNumber, String branchNameInWhichToCleanupCheckFixCall) {
        NSCheckFix.warnAboutOldCheckFixCalls(radarNumber, branchNameInWhichToCleanupCheckFixCall);
        return NSCheckFix.fixDisabledForRadar(radarNumber);
    }

    private static void warnAboutOldCheckFixCalls(int radarNumber, String branchName) {
        String currentBranchName;
        if (branchName == null) {
            return;
        }
        if (NSProperties.booleanForKey("NSCheckFix.shouldWarnAboutOldCalls") && (currentBranchName = branchNameProperty.value()).compareToIgnoreCase(branchName) > 0) {
            log.warn("Call to NSCheckFix for radar '" + radarNumber + "' should have been cleaned up in branch '" + branchName + "'.");
        }
    }
}

