/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSVersion;
import com.webobjects.foundation._NSBundleStatus;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.development.NSBundleFactory;
import com.webobjects.foundation.development.NSLegacyBundle;
import com.webobjects.foundation.development.NSProjectBundle;
import com.webobjects.foundation.development.NSProjectBundleFactory;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NSBundle
implements NSVersion {
    public static final String NS_GLOBAL_PROPERTIES_PATH = "NSGlobalPropertiesPath";
    public static final String CFBUNDLESHORTVERSIONSTRINGKEY = "CFBundleShortVersionString";
    public static final String MANIFESTIMPLEMENTATIONVERSIONKEY = "Implementation-Version";
    public static final String BundleDidLoadNotification = "NSBundleDidLoadNotification";
    public static final String AllBundlesDidLoadNotification = "NSBundleAllDidLoadNotification";
    public static final String AllBundlesWillInitializeNotification = "NSBundleAllWillInitializeNotification";
    public static final String AllBundlesDidInitializeNotification = "NSBundleAllDidInitializeNotification";
    public static final String LoadedClassesNotification = "NSLoadedClassesNotification";
    private static String userDirPath;
    public static final String LPROJSUFFIX = ".lproj";
    private static final String NONLOCALIZED_LOCALE = "Nonlocalized.lproj";
    private static final String NONLOCALIZED_LOCALE_PREFIX;
    private static final String RESOURCES = "Resources";
    private static final NSMutableArray<NSBundle> AllBundles;
    private static final NSMutableArray<NSBundle> AllBundlesReally;
    private static final NSMutableArray<NSBundle> AllFrameworks;
    private static final NSMutableDictionary<String, NSBundle> BundlesClassesTable;
    private static NSArray<String> ClassPath;
    private static final NSMutableDictionary<String, NSBundle> BundlesNamesTable;
    private static final NSMutableDictionary<String, NSBundle> AppBundlesNamesTable;
    private static NSBundle MainBundle;
    private static boolean PrincipalClassLookupAllowed;
    private static final _NSThreadsafeMutableDictionary<String, ResourceDirectoryFilter> ResourceDirectoryFilters;
    private static final _NSThreadsafeMutableDictionary<String, ResourceFilter> ResourceFilters;
    protected static final DirectoryFilter TheDirectoryFilter;
    protected static final FilesFilter TheFilesFilter;
    public static final String InfoPlistFilename = "Info.plist";
    private static String ResourcesInfoPlist;
    private static String JarResourcesInfoPlist;
    private static boolean safeInvokeDeprecatedJarBundleAPI;
    private static boolean _bundlesLoaded;
    private Class<?> principalClass;
    private static final String jarEndsWithString;
    protected Integer _version;
    protected Integer _revision;
    protected Integer _fix;
    protected Integer _build;
    protected String _releaseString;
    protected static final Integer _zeroInteger;
    private static final Logger log;

    static {
        NONLOCALIZED_LOCALE_PREFIX = NONLOCALIZED_LOCALE + File.separator;
        AllBundles = new NSMutableArray<int>(64);
        AllBundlesReally = new NSMutableArray<int>(64);
        AllFrameworks = new NSMutableArray<int>(64);
        BundlesClassesTable = new NSMutableDictionary(2048);
        BundlesNamesTable = new NSMutableDictionary(16);
        AppBundlesNamesTable = new NSMutableDictionary(1);
        ResourceDirectoryFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        ResourceFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        TheDirectoryFilter = new DirectoryFilter();
        TheFilesFilter = new FilesFilter();
        ResourcesInfoPlist = "Resources/Info.plist";
        JarResourcesInfoPlist = "!/" + ResourcesInfoPlist;
        safeInvokeDeprecatedJarBundleAPI = false;
        _bundlesLoaded = false;
        jarEndsWithString = ".jar".concat(JarResourcesInfoPlist);
        _zeroInteger = 0;
        log = LoggerFactory.getLogger(NSBundle.class);
    }

    private static final String __extractStringFromURL(URL anURL) {
        String url2Path = null;
        try {
            String urlPath = anURL.getPath();
            if (urlPath.endsWith(jarEndsWithString)) {
                url2Path = urlPath.substring(0, urlPath.length() - JarResourcesInfoPlist.length());
                URL url2 = new URL(url2Path);
                url2Path = url2.getPath();
            }
        }
        catch (Exception exception) {}
        return url2Path;
    }

    public static boolean bundlesLoaded() {
        return _bundlesLoaded;
    }

    public static synchronized void _loadBundles() {
        if (!_bundlesLoaded) {
            try {
                String urlPath;
                _bundlesLoaded = true;
                NSProperties._setInitializationWarningEnabled(false);
                NSPropertiesCoordinator.loadProperties();
                safeInvokeDeprecatedJarBundleAPI = NSPropertyListSerialization.booleanForString(NSProperties.getProperty("com.webobjects.safeInvokeDeprecatedJarBundleAPI"));
                String woUserDir = NSProperties.getProperty("webobjects.user.dir");
                if (woUserDir == null) {
                    woUserDir = System.getProperty("user.dir");
                }
                userDirPath = new File(woUserDir).getCanonicalPath();
                NSMutableArray<String> urlArray = new NSMutableArray<String>();
                Enumeration<URL> e = NSBundle.class.getClassLoader().getResources(ResourcesInfoPlist);
                while (e.hasMoreElements()) {
                    urlPath = NSBundle.__extractStringFromURL(e.nextElement());
                    if (urlPath == null) continue;
                    urlArray.addObject(urlPath);
                }
                if (urlArray.count() == 0) {
                    e = ClassLoader.getSystemResources(ResourcesInfoPlist);
                    while (e.hasMoreElements()) {
                        urlPath = NSBundle.__extractStringFromURL(e.nextElement());
                        if (urlPath == null) continue;
                        urlArray.addObject(urlPath);
                    }
                }
                NSBundle.LoadBundlesFromJars(urlArray);
                String classPathString = System.getProperty("java.class.path");
                String woClassPathString = NSProperties.stringForKey("com.webobjects.classpath");
                if (woClassPathString != null) {
                    classPathString = String.valueOf(classPathString) + File.pathSeparator + woClassPathString;
                }
                NSMutableArray<String> classpath = NSArray._mutableComponentsSeparatedByString(classPathString, File.pathSeparator);
                LinkedHashSet<String> cleanedUpClassPath = new LinkedHashSet<String>();
                for (String path : classpath) {
                    String fixedComponent = NSPathUtilities.stringByNormalizingExistingPath(path);
                    if (fixedComponent != null && fixedComponent.length() > 0) {
                        cleanedUpClassPath.add(fixedComponent);
                    }
                    if (!NSProjectBundleFactory.isEnabled()) continue;
                    File f = new File(path);
                    String string = fixedComponent = f.exists() ? f.getAbsolutePath() : null;
                    if (fixedComponent == null || fixedComponent.length() <= 0) continue;
                    cleanedUpClassPath.add(fixedComponent);
                }
                ClassPath = new NSArray(cleanedUpClassPath, false);
                NSBundle.LoadBundlesFromClassPath(ClassPath);
                for (NSBundle bundle : AllBundlesReally) {
                    NSNotificationCenter.defaultCenter().postNotification(BundleDidLoadNotification, bundle, new NSDictionary<String, NSArray<String>>(bundle.bundleClassNames(), LoadedClassesNotification));
                }
                NSBundle.InitMainBundle();
                NSBundle._userAndBundleProperties();
                NSPropertiesCoordinator.loadProperties();
                NSNotificationCenter.defaultCenter().postNotification(AllBundlesWillInitializeNotification, null, null);
                NSBundle.InitPrincipalClasses();
                NSNotificationCenter.defaultCenter().postNotification(AllBundlesDidInitializeNotification, null, null);
                NSNotificationCenter.defaultCenter().postNotification(AllBundlesDidLoadNotification, null, null);
                _NSUtilities._setResourceSearcher(new _NSUtilities._ResourceSearcher(){

                    @Override
                    public Class<?> _searchForClassWithName(String className) {
                        return NSBundle.searchAllBundlesForClassWithName(className);
                    }

                    @Override
                    public URL _searchPathURLForResourceWithName(Class<?> resourceClass, String resourceName, String extension) {
                        URL url = null;
                        NSBundle bundle = NSBundle.bundleForClass(resourceClass);
                        if (bundle != null && resourceName != null) {
                            String fileName = null;
                            fileName = extension == null || extension.length() == 0 ? resourceName : (extension.startsWith(".") || resourceName.endsWith(".") ? resourceName.concat(extension) : _NSStringUtilities.concat(resourceName, ".", extension));
                            bundle.pathURLForResourcePath(bundle.resourcePathForLocalizedResourceNamed(fileName, ""));
                        }
                        return url;
                    }
                });
                NSKeyValueCoding.DefaultImplementation._initializeBindingFactory();
                NSBundleFactory._bundleFactoriesBundlesDidLoad();
                _NSBundleStatus.bundlesDidLoad();
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
    }

    @Deprecated
    public static synchronized NSArray<NSBundle> allBundles() {
        NSBundle._loadBundles();
        return AllBundles.immutableClone();
    }

    @Deprecated
    public static NSArray<NSBundle> allFrameworks() {
        NSBundle._loadBundles();
        return NSBundle.frameworkBundles();
    }

    public static synchronized NSBundle bundleForClass(Class<?> aClass) {
        NSBundle._loadBundles();
        NSBundle bundle = null;
        if (aClass != null) {
            bundle = (NSBundle)BundlesClassesTable.objectForKey(aClass.getName());
        }
        return bundle;
    }

    @Deprecated
    public static NSBundle bundleWithPath(String aPath) {
        return NSBundle._bundleWithPathShouldCreateIsJar(aPath, false, false);
    }

    public static NSBundle _bundleWithPathShouldCreateIsJar(String aPath, boolean shouldCreateBundle, boolean newIsJar) {
        NSBundle._loadBundles();
        return NSBundleFactory.bundleForPathWithRegistry(aPath, shouldCreateBundle, newIsJar);
    }

    public static synchronized NSBundle bundleForName(String aName) {
        NSBundle._loadBundles();
        NSBundle bundle = null;
        if (aName != null) {
            String fixedName = aName.endsWith(".framework") ? NSPathUtilities.stringByDeletingPathExtension(aName) : aName;
            bundle = (NSBundle)BundlesNamesTable.objectForKey(fixedName);
        }
        return bundle;
    }

    public static synchronized NSBundle _appBundleForName(String aName) {
        NSBundle._loadBundles();
        NSBundle bundle = null;
        if (aName != null) {
            String fixedName = aName.endsWith(".woa") ? NSPathUtilities.stringByDeletingPathExtension(aName) : aName;
            bundle = (NSBundle)AppBundlesNamesTable.objectForKey(fixedName);
        }
        return bundle;
    }

    public static synchronized NSBundle _bundleOrAppForName(String name) {
        NSBundle bundle = NSBundle.bundleForName(name);
        if (bundle == null) {
            bundle = NSBundle._appBundleForName(name);
        }
        return bundle;
    }

    public static synchronized NSArray<NSBundle> frameworkBundles() {
        NSBundle._loadBundles();
        return AllFrameworks.immutableClone();
    }

    public static void _setMainBundle(NSBundle bundle) {
        MainBundle = bundle;
    }

    public static NSBundle mainBundle() {
        NSBundle._loadBundles();
        return MainBundle;
    }

    public static NSBundle _mainBundle() {
        return MainBundle;
    }

    public static Properties _userAndBundleProperties() {
        NSArray<NSBundle> allBundles = NSBundle.allFrameworks();
        Enumeration<NSBundle> bundleEn = allBundles.objectEnumerator();
        while (bundleEn.hasMoreElements()) {
            NSBundle nextBundle = bundleEn.nextElement();
            nextBundle.registerProperties();
        }
        if (NSBundle.mainBundle() != null) {
            NSBundle.mainBundle().registerProperties();
        }
        return null;
    }

    private static void InitMainBundle() {
        try {
            String mainBundleName = NSProperties._mainBundleName();
            if (mainBundleName != null) {
                MainBundle = NSBundle.bundleForName(mainBundleName);
            }
        }
        catch (Exception e) {
            log.debug("Didn't create bundle for " + NSProperties._mainBundleName(), (Throwable)e);
        }
        if (MainBundle == null) {
            MainBundle = NSBundleFactory.bundleForPathWithRegistry(userDirPath, true, false);
        }
        if (MainBundle == null) {
            int i = 0;
            while (MainBundle == null && i < AllBundlesReally.count()) {
                NSBundle bundle = (NSBundle)AllBundlesReally.objectAtIndex(i);
                if (bundle._infoDictionary() != null && "APPL".equals(bundle._infoDictionary().objectForKey("CFBundlePackageType"))) {
                    MainBundle = bundle;
                }
                ++i;
            }
        }
        if (MainBundle == null) {
            log.debug("Can't locate main bundle, using JavaFoundation");
            MainBundle = NSBundle.bundleForName("JavaFoundation");
        }
        if (MainBundle != null && (MainBundle._infoDictionary() == null || !_NSUtilities.safeEquals(MainBundle.name(), MainBundle._infoDictionary().objectForKey("NSExecutable")) && !_NSUtilities.safeEquals(MainBundle.name(), MainBundle._infoDictionary().objectForKey("CFBundleName")))) {
            throw new IllegalStateException("There was no name defined for the bundle '" + MainBundle + "'");
        }
    }

    @Deprecated
    public static void _setPrincipalClassWarningSuppressed(boolean flag) {
    }

    private static void InitPrincipalClasses() {
        int count = AllBundlesReally.count();
        int i = 0;
        while (i < count) {
            ((NSBundle)AllBundlesReally.objectAtIndex(i))._bundlesDidLoad();
            ((NSBundle)AllBundlesReally.objectAtIndex(i)).initPrincipalClass();
            ++i;
        }
        PrincipalClassLookupAllowed = true;
    }

    private static void LoadBundlesFromJars(NSArray<String> array) {
        Enumeration<String> en = array.objectEnumerator();
        while (en.hasMoreElements()) {
            NSBundleFactory.bundleForPathWithRegistry(en.nextElement().toString(), true, true);
        }
    }

    private static void LoadBundlesFromClassPath(NSArray<String> array) {
        Enumeration<String> en = array.objectEnumerator();
        while (en.hasMoreElements()) {
            String nextPathComponent = en.nextElement();
            NSBundleFactory.bundleForPathWithRegistry(nextPathComponent, true, false);
        }
        NSBundle mainBundle = NSBundle.mainBundle();
        if (mainBundle != null && mainBundle instanceof NSProjectBundle) {
            AllBundlesReally.removeObject(mainBundle);
            AllBundlesReally.addObject(mainBundle);
        }
    }

    public static String _DefaultLocalePrefix() {
        String defaultLang = "English";
        String defaultLocaleLang = Locale.getDefault().getLanguage();
        if (defaultLocaleLang.equals("de")) {
            defaultLang = "German";
        } else if (defaultLocaleLang.equals("es")) {
            defaultLang = "Spanish";
        } else if (defaultLocaleLang.equals("fr")) {
            defaultLang = "French";
        } else if (defaultLocaleLang.equals("ja")) {
            defaultLang = "Japanese";
        }
        return defaultLang.concat(LPROJSUFFIX);
    }

    public static synchronized NSBundle _lookupBundleWithPath(String aPath) {
        NSBundle._loadBundles();
        NSBundle bundle = null;
        if (aPath == null) {
            return null;
        }
        Enumeration en = AllBundlesReally.objectEnumerator();
        while (en.hasMoreElements() && bundle == null) {
            NSBundle nextBundle = (NSBundle)en.nextElement();
            if (!nextBundle.bundlePath().equals(aPath)) continue;
            bundle = nextBundle;
        }
        return bundle;
    }

    public static String _normalizeExistingBundlePath(String aPath) {
        File fileAtPath;
        String standardizedPath = null;
        if (aPath != null && (fileAtPath = new File(aPath)).exists()) {
            standardizedPath = NSPathUtilities.stringByNormalizingExistingPath(aPath);
        }
        return standardizedPath;
    }

    public static String _cleanNormalizedBundlePath(String standardizedPath) {
        String bundlePath = standardizedPath;
        if (bundlePath != null) {
            String allDirectoriesInPath = null;
            int i = -1;
            File fileAtPath = new File(bundlePath);
            allDirectoriesInPath = !fileAtPath.isDirectory() ? _NSStringUtilities.stringByDeletingLastComponent(bundlePath, File.separatorChar) : bundlePath;
            if (allDirectoriesInPath != null) {
                i = allDirectoriesInPath.lastIndexOf(NSLegacyBundle.RJSUFFIX);
                if (i == -1 || i == 0) {
                    i = allDirectoriesInPath.lastIndexOf(NSLegacyBundle.RSUFFIX);
                }
                if (i == -1 || i == 0) {
                    bundlePath = allDirectoriesInPath;
                } else {
                    bundlePath = allDirectoriesInPath.substring(0, i);
                    if (NSPathUtilities.lastPathComponent(NSPathUtilities.stringByDeletingLastPathComponent(bundlePath)).equals("Versions")) {
                        bundlePath = NSPathUtilities.stringByDeletingLastPathComponent(NSPathUtilities.stringByDeletingLastPathComponent(bundlePath));
                    }
                }
            }
        }
        return bundlePath;
    }

    public static NSArray<NSBundle> _allBundlesReally() {
        NSBundle._loadBundles();
        return AllBundlesReally;
    }

    public static synchronized void addBundle(NSBundle bundle) {
        NSBundle._loadBundles();
        if (AllBundlesReally.containsObject(bundle)) {
            return;
        }
        boolean bundleAdded = true;
        if (bundle.isFramework()) {
            NSBundle possibleBundle = NSBundle.bundleForName(bundle.name());
            if (possibleBundle == null) {
                BundlesNamesTable.setObjectForKey(bundle, bundle.name());
                AllFrameworks.addObject(bundle);
            } else {
                bundleAdded = false;
                System.err.println("<" + NSBundle.class.getName() + "> warning: There is already a unique instance for Bundle named '" + bundle.name() + "' at the path + '" + possibleBundle.bundlePath() + "'. Skipping the version located at '" + bundle.bundlePath() + "'.");
            }
        } else {
            AppBundlesNamesTable.setObjectForKey(bundle, bundle.name());
            MainBundle = bundle;
            AllBundles.addObject(bundle);
        }
        if (bundleAdded) {
            AllBundlesReally.addObject(bundle);
            bundle.initVersion();
            if (PrincipalClassLookupAllowed) {
                bundle._bundlesDidLoad();
                bundle.initPrincipalClass();
                NSNotificationCenter.defaultCenter().postNotification(BundleDidLoadNotification, bundle, new NSDictionary<String, NSArray<String>>(bundle.bundleClassNames(), LoadedClassesNotification));
            }
        }
    }

    public static String _userDirPath() {
        NSBundle._loadBundles();
        return userDirPath;
    }

    public static NSArray<String> _classPath() {
        NSBundle._loadBundles();
        return ClassPath;
    }

    public static synchronized void _registerClassNameForBundle(String className, NSBundle bundle) {
        NSBundle._loadBundles();
        NSBundle existingBundle = (NSBundle)BundlesClassesTable.objectForKey(className);
        if (existingBundle == null) {
            BundlesClassesTable.setObjectForKey(bundle, className);
        }
    }

    protected static ResourceDirectoryFilter ResourceDirectoryFilterForExtension(String anExtension) {
        ResourceDirectoryFilter rdf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rdf = ResourceDirectoryFilters.objectForKey(correctedExtension);
        if (rdf == null) {
            rdf = new ResourceDirectoryFilter(correctedExtension);
            ResourceDirectoryFilters.setObjectForKey(rdf, correctedExtension);
        }
        return rdf;
    }

    protected static ResourceFilter ResourceFilterForExtension(String anExtension) {
        ResourceFilter rf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rf = ResourceFilters.objectForKey(correctedExtension);
        if (rf == null) {
            rf = new ResourceFilter(correctedExtension);
            ResourceFilters.setObjectForKey(rf, correctedExtension);
        }
        return rf;
    }

    static Class<?> searchAllBundlesForClassWithName(String className) {
        if (log.isDebugEnabled()) {
            log.debug("NSBundle.searchAllBundlesForClassWithName({}) was invoked.\n\t**This affects performance very badly.**", (Object)className, (Object)new RuntimeException("NSBundle.searchAllBundlesForClassWithName was invoked."));
        }
        Class<?> result = null;
        result = NSBundle.searchForClassInBundles(className, NSBundle.allBundles(), true);
        if (result == null) {
            result = NSBundle.searchForClassInBundles(className, NSBundle.allFrameworks(), true);
        }
        return result;
    }

    private static Class<?> searchForClassInBundles(String className, NSArray<? extends NSBundle> bundles, boolean registerPackageOnHit) {
        NSBundle._loadBundles();
        int count = bundles.count();
        Class<?> result = null;
        if (className.indexOf(46) == -1) {
            boolean scanPackages = false;
            String bundleClassNameSuffix = "." + className;
            int i = 0;
            while (i < count && result == null && !scanPackages) {
                NSBundle bundle = bundles.objectAtIndex(i);
                for (String bundleClassName : bundle.bundleClassNames()) {
                    if (!bundleClassName.endsWith(bundleClassNameSuffix)) continue;
                    try {
                        result = _NSUtilities._classForName(bundleClassName, NSBundle.class.getClassLoader());
                        _NSUtilities.setClassForName(result, className);
                        return result;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        scanPackages = true;
                        break;
                    }
                    catch (ClassFormatError classFormatError) {
                        scanPackages = true;
                        break;
                    }
                    catch (SecurityException securityException) {
                        scanPackages = true;
                        break;
                    }
                }
                ++i;
            }
            if (!scanPackages) {
                return null;
            }
        }
        if (result == null) {
            int i = 0;
            while (i < count) {
                NSBundle bundle = bundles.objectAtIndex(i);
                result = _NSUtilities._searchForClassInPackages(className, bundle.bundleClassPackageNames(), registerPackageOnHit, false);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    public abstract NSArray<String> bundleClassPackageNames();

    @Deprecated
    public abstract String bundlePath();

    public abstract URL bundlePathURL();

    public abstract String _bundleURLPrefix();

    public byte[] bytesForResourcePath(String aResourcePath) {
        InputStream is = this.inputStreamForResourcePath(aResourcePath);
        byte[] b = null;
        if (is == null) {
            b = new byte[]{};
        } else {
            try {
                b = _NSStringUtilities.bytesFromInputStream(is);
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
        return b;
    }

    public abstract NSArray<String> bundleClassNames();

    @Deprecated
    public abstract NSDictionary<String, ?> infoDictionary();

    public NSDictionary<String, ?> _infoDictionary() {
        return this.infoDictionary();
    }

    public URL pathURLForResourcePath(String aResourcePath) {
        return this._pathURLForResourcePath(aResourcePath, true);
    }

    public abstract URL _pathURLForResourcePath(String var1, boolean var2);

    public InputStream inputStreamForResourcePath(String aResourcePath) {
        InputStream is = null;
        URL url = this._pathURLForResourcePath(aResourcePath, false);
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (IOException ioe) {
                throw NSForwardException._runtimeExceptionForThrowable(ioe);
            }
        }
        return is;
    }

    public abstract boolean isFramework();

    public abstract boolean _isCFBundle();

    public abstract boolean isJar();

    public abstract JarFile _jarFile();

    public abstract NSDictionary<String, ? extends NSDictionary<String, ?>> _jarFileLayout();

    @Deprecated
    public abstract boolean load();

    public abstract String name();

    public boolean _directoryExistsInJar(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return true;
        }
        if (this.isJar()) {
            String aPath = path;
            if (!aPath.endsWith("/")) {
                aPath = aPath.concat("/");
            }
            if (File.separatorChar != '/') {
                aPath = aPath.replace(File.separatorChar, '/');
            }
            return this._jarFile().getEntry(aPath) != null;
        }
        return false;
    }

    protected void initVersion() {
        NSDictionary<String, ?> infoPlist = this._infoDictionary();
        String aBuildString = null;
        String aVersion = null;
        if (infoPlist != null) {
            aVersion = (String)infoPlist.valueForKey(CFBUNDLESHORTVERSIONSTRINGKEY);
            aBuildString = (String)infoPlist.valueForKey(MANIFESTIMPLEMENTATIONVERSIONKEY);
        }
        this.parseVersionString(aVersion, aBuildString);
    }

    protected void parseVersionString(String aVersion, String aBuildString) {
        Integer version = 1;
        Integer revision = _zeroInteger;
        Integer fix = _zeroInteger;
        Integer build = _zeroInteger;
        String releaseString = "";
        try {
            build = aBuildString != null && aBuildString.length() > 0 ? Integer.valueOf(aBuildString) : _zeroInteger;
        }
        catch (Exception exception) {
            log.debug("The bundle {} has malformed build number: {}", (Object)this.name(), (Object)aBuildString);
        }
        if (aVersion != null && aVersion.trim().length() > 0) {
            try {
                StringBuilder numeric = new StringBuilder(32);
                StringBuilder adjective = new StringBuilder(32);
                boolean found = false;
                char[] cArray = aVersion.trim().toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!found && (Character.isDigit(c) || c == '.')) {
                        numeric.append(c);
                    } else {
                        found = true;
                        adjective.append(c);
                    }
                    ++n2;
                }
                StringTokenizer versionTokenizer = new StringTokenizer(numeric.toString(), ".", false);
                if (versionTokenizer.hasMoreTokens()) {
                    version = Integer.valueOf(versionTokenizer.nextToken());
                }
                if (versionTokenizer.hasMoreTokens()) {
                    revision = Integer.valueOf(versionTokenizer.nextToken());
                }
                if (versionTokenizer.hasMoreTokens()) {
                    fix = Integer.valueOf(versionTokenizer.nextToken());
                }
                releaseString = adjective.toString();
            }
            catch (Exception exception) {
                log.debug("An exception occurred", (Throwable)exception);
            }
        }
        this._version = version;
        this._revision = revision;
        this._fix = fix;
        this._build = build;
        this._releaseString = releaseString;
    }

    @Override
    public Integer version() {
        return this._version != null ? this._version : Integer.valueOf(1);
    }

    @Override
    public Integer revision() {
        return this._revision != null ? this._revision : Integer.valueOf(0);
    }

    @Override
    public Integer fix() {
        return this._fix != null ? this._fix : Integer.valueOf(0);
    }

    @Override
    public Integer build() {
        return this._build != null ? this._build : Integer.valueOf(0);
    }

    @Override
    public int compareTo(NSVersion object) throws ClassCastException {
        return NSVersion.DefaultImplementation.compareTo(this, object);
    }

    @Override
    public String versionString() {
        return NSVersion.DefaultImplementation.toString(this);
    }

    @Override
    public String releaseString() {
        return this._releaseString != null ? this._releaseString : "";
    }

    @Deprecated
    public String pathForResource(String aName, String anExtension) {
        return this.pathForResource(aName, anExtension, null);
    }

    @Deprecated
    public abstract String pathForResource(String var1, String var2, String var3);

    @Deprecated
    public abstract NSArray<String> pathsForResources(String var1, String var2);

    public Class<?> principalClass() {
        return this.principalClass;
    }

    public abstract void registerProperties();

    @Deprecated
    public abstract Properties properties();

    @Deprecated
    public abstract String resourcePath();

    public URL _urlForRelativePath(String path) {
        URL retVal = null;
        if (path != null && path.length() > 0) {
            if (this.isJar()) {
                ZipEntry ze;
                String aPath = path;
                if (aPath.startsWith("/")) {
                    aPath = aPath.substring(1, aPath.length());
                }
                if ((ze = this._jarFile().getEntry(aPath)) == null && !aPath.endsWith("/")) {
                    aPath = aPath.concat("/");
                    ze = this._jarFile().getEntry(aPath);
                }
                if (ze != null) {
                    try {
                        retVal = new URL(this._bundleURLPrefix().concat(aPath));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else {
                File f = new File(_NSStringUtilities.concat(this.bundlePath(), File.separator, path));
                if (f.exists()) {
                    try {
                        retVal = f.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
        }
        return retVal;
    }

    public abstract String resourcePathForLocalizedResourceNamed(String var1, String var2);

    protected String resourcePathForLocalizedResourceNamed(String aName, String aSubDirPath, List<String> resourceBuckets) {
        String path = null;
        if (aName != null) {
            String FileSeparator = this.isJar() ? "/" : File.separator;
            Iterator<String> en = resourceBuckets.iterator();
            String localePrefix = NSBundle._DefaultLocalePrefix().concat(FileSeparator);
            String[] pathFragments = new String[2];
            if (aSubDirPath == null || aSubDirPath.length() == 0) {
                pathFragments[0] = localePrefix;
                pathFragments[1] = "";
            } else {
                pathFragments[0] = _NSStringUtilities.concat(localePrefix, aSubDirPath, FileSeparator);
                pathFragments[1] = aSubDirPath.concat(FileSeparator);
            }
            while (en.hasNext() && path == null) {
                String nextDir = en.next();
                String pathPrefix = nextDir.equals("") ? this.bundlePath().concat(FileSeparator) : _NSStringUtilities.concat(this.bundlePath(), FileSeparator, nextDir, FileSeparator);
                int i = 0;
                while (i < pathFragments.length && path == null) {
                    block15: {
                        String possiblePath;
                        if (this.isJar()) {
                            possiblePath = _NSStringUtilities.concat(FileSeparator, pathFragments[i], aName);
                            String comparisonPath = nextDir.concat(possiblePath);
                            ZipEntry ze = this._jarFile().getEntry(comparisonPath);
                            if (ze != null) {
                                path = pathFragments[i].concat(aName);
                                if (!pathFragments[i].startsWith(NSBundle._DefaultLocalePrefix())) {
                                    path = NONLOCALIZED_LOCALE.concat(possiblePath);
                                }
                            }
                        } else {
                            possiblePath = pathFragments[i].equals("") ? pathPrefix.concat(aName) : _NSStringUtilities.concat(pathPrefix, pathFragments[i], aName);
                            File possibleResource = new File(possiblePath);
                            File possibleResourcePrefix = new File(pathPrefix);
                            if (possibleResource.exists() && possibleResourcePrefix.isDirectory()) {
                                try {
                                    path = possibleResource.getCanonicalPath();
                                    String absolutePathPrefix = possibleResourcePrefix.getCanonicalPath();
                                    if (!absolutePathPrefix.endsWith(File.separator)) {
                                        absolutePathPrefix = String.valueOf(absolutePathPrefix) + File.separator;
                                    }
                                    if (path.startsWith(absolutePathPrefix)) {
                                        path = path.substring(absolutePathPrefix.length());
                                        if (!pathFragments[i].startsWith(NSBundle._DefaultLocalePrefix())) {
                                            path = NONLOCALIZED_LOCALE_PREFIX.concat(path);
                                        }
                                        break block15;
                                    }
                                    throw new IllegalArgumentException("<" + NSLegacyBundle.class.getName() + "> May not pass relative paths that reference resources outside of the bundle! (" + aName + "," + aSubDirPath + ")");
                                }
                                catch (IOException e) {
                                    throw NSForwardException._runtimeExceptionForThrowable(e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return path;
    }

    public abstract NSArray<String> resourcePathsForDirectories(String var1, String var2);

    public abstract NSArray<String> resourcePathsForLocalizedResources(String var1, String var2);

    public abstract NSArray<String> resourcePathsForResources(String var1, String var2);

    protected boolean _prefixPathWithNonLocalizedPrefix(String aPath, String resourcePath) {
        return aPath.equals(resourcePath);
    }

    public String toString() {
        int count = 0;
        if (this.bundleClassNames() != null) {
            count = this.bundleClassNames().count();
        }
        return "<" + this.getClass().getName() + " name:'" + this.name() + "' bundlePath:'" + this.bundlePath() + "' packages:'" + this.bundleClassPackageNames() + "' " + count + " classes >";
    }

    public Class<?> _classWithName(String className) {
        Class<?> objectClass = null;
        if (className == null) {
            throw new IllegalArgumentException("Class name cannot be null.");
        }
        objectClass = _NSUtilities._classWithPartialName(className, false);
        if (objectClass != null) {
            return objectClass;
        }
        NSArray<String> thePackages = this.bundleClassPackageNames();
        objectClass = _NSUtilities._searchForClassInPackages(className, thePackages, true, false);
        return objectClass != null ? objectClass : _NSUtilities._classWithPartialName(className, true);
    }

    protected NSArray<String> resourcePathsForResourcesInDirectory(String aPath, String resourcePath, FilenameFilter aFilter, boolean prependNonlocalizedLProj) {
        File subdir = new File(aPath);
        String[] fileNames = subdir.list(aFilter);
        if (fileNames == null) {
            return NSArray.emptyArray();
        }
        String prefix = this._prefixPathWithNonLocalizedPrefix(aPath, resourcePath) ? "" : aPath.substring(resourcePath.concat(File.separator).length());
        NSMutableArray<String> list = new NSMutableArray<String>();
        int i = 0;
        while (i < fileNames.length) {
            if (prefix.length() == 0) {
                list.addObject(NONLOCALIZED_LOCALE_PREFIX.concat(fileNames[i]));
            } else if (prependNonlocalizedLProj) {
                list.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE_PREFIX, prefix, File.separator, fileNames[i]));
            } else {
                list.addObject(_NSStringUtilities.concat(prefix, File.separator, fileNames[i]));
            }
            ++i;
        }
        String[] dirNames = subdir.list(TheDirectoryFilter);
        int i2 = 0;
        while (i2 < dirNames.length) {
            boolean prepend = prefix.length() == 0 ? !dirNames[i2].endsWith(LPROJSUFFIX) : prependNonlocalizedLProj;
            list.addObjectsFromArray(this.resourcePathsForResourcesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i2]), resourcePath, aFilter, prepend));
            ++i2;
        }
        if (list.count() == 0) {
            return NSArray.emptyArray();
        }
        return list;
    }

    public abstract void _simplePathsInDirectoryInJar(String var1, String var2, NSMutableArray<String> var3, String var4, NSMutableArray<String> var5);

    protected NSArray<String> resourcePathsForDirectoriesInDirectory(String aPath, String resourcePath, FilenameFilter aFilter, boolean prependNonlocalizedLProj) {
        String[] dirNames = new File(aPath).list(aFilter);
        if (dirNames == null) {
            return NSArray.emptyArray();
        }
        NSMutableArray<String> list = new NSMutableArray<String>();
        String prefix = this._prefixPathWithNonLocalizedPrefix(aPath, resourcePath) ? "" : aPath.substring(resourcePath.concat(File.separator).length());
        int i = 0;
        while (i < dirNames.length) {
            if (prefix.length() == 0) {
                if (dirNames[i].endsWith(LPROJSUFFIX)) {
                    list.addObject(dirNames[i]);
                } else {
                    list.addObject(NONLOCALIZED_LOCALE_PREFIX.concat(dirNames[i]));
                }
            } else if (prependNonlocalizedLProj) {
                list.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE_PREFIX, prefix, File.separator, dirNames[i]));
            } else {
                list.addObject(_NSStringUtilities.concat(prefix, File.separator, dirNames[i]));
            }
            ++i;
        }
        i = 0;
        while (i < dirNames.length) {
            if (prefix.length() == 0) {
                boolean endWithLPROJ = dirNames[i].endsWith(LPROJSUFFIX);
                list.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i]), resourcePath, aFilter, !endWithLPROJ));
            } else {
                list.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i]), resourcePath, aFilter, prependNonlocalizedLProj));
            }
            ++i;
        }
        if (list.count() == 0) {
            return NSArray.emptyArray();
        }
        return list;
    }

    public abstract void _bundlesDidLoad();

    public void initPrincipalClass() {
        String principalClassName = null;
        this.principalClass = null;
        if (this.infoDictionary() != null && (principalClassName = (String)this.infoDictionary().objectForKey("NSPrincipalClass")) != null && !principalClassName.equals("") && !"true".equals(System.getProperty("NSSkipPrincipalClasses"))) {
            this.principalClass = _NSUtilities.classWithName(principalClassName);
            if (this.principalClass != null) {
                try {
                    Class.forName(this.principalClass.getName(), true, this.principalClass.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            if (this.principalClass == null && _NSUtilities._principalClassLoadingWarningsNeeded) {
                log.error("Principal class '{}' not found in bundle {}", new Object[]{principalClassName, this.name(), new ClassNotFoundException(principalClassName)});
            }
        }
    }

    protected static boolean shouldValidateProperties() {
        return Boolean.valueOf(System.getProperty("NSValidateProperties", "true"));
    }

    public static boolean _bundleUrlExists(URL url) {
        boolean urlPathExists;
        block10: {
            urlPathExists = true;
            try {
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    File file = new File(url.getFile());
                    urlPathExists = file.exists();
                    break block10;
                }
                if ("jar".equals(protocol)) {
                    JarURLConnection urlConn = (JarURLConnection)url.openConnection();
                    URL jarFileURL = urlConn.getJarFileURL();
                    if (NSBundle._bundleUrlExists(jarFileURL)) {
                        if ("file".equals(jarFileURL.getProtocol())) {
                            try (JarFile jarFile = new JarFile(jarFileURL.getPath());){
                                JarEntry jarEntry = (JarEntry)jarFile.getEntry(urlConn.getEntryName());
                                if (jarEntry == null) {
                                    urlPathExists = false;
                                }
                                break block10;
                            }
                        }
                        throw new IllegalArgumentException("Unable to handle Jar File URL protocol: " + url);
                    }
                    urlPathExists = false;
                    break block10;
                }
                throw new IllegalArgumentException("Unable to handle URL protocol: " + url);
            }
            catch (IOException iOException) {
                urlPathExists = true;
            }
        }
        return urlPathExists;
    }

    protected static class DirectoryFilter
    implements FilenameFilter {
        protected DirectoryFilter() {
        }

        @Override
        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && !aName.equals(".svn")) {
                File namedFile = new File(dir, aName);
                result = namedFile.isDirectory();
            }
            return result;
        }
    }

    protected static class FilesFilter
    implements FilenameFilter {
        protected FilesFilter() {
        }

        @Override
        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && !aName.equals(".svn")) {
                File namedFile = new File(dir, aName);
                result = namedFile.isFile();
            }
            return result;
        }
    }

    protected static class OldResourceFilter
    implements FilenameFilter {
        private String extension;

        public OldResourceFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        @Override
        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    protected static class ResourceDirectoryFilter
    implements FilenameFilter {
        private String extension;

        public ResourceDirectoryFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        @Override
        public boolean accept(File dir, String aName) {
            File d;
            boolean result = false;
            if (aName != null && !aName.equals(".svn") && (d = new File(dir + File.separator + aName)).isDirectory() && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    protected static class ResourceFilter
    implements FilenameFilter {
        private String extension;

        public ResourceFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        @Override
        public boolean accept(File dir, String aName) {
            File f;
            boolean result = false;
            if (aName != null && (f = new File(dir, aName)).isFile() && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    protected static class SpecificResourceFilter
    implements FilenameFilter {
        private String name;

        public SpecificResourceFilter(String aName) {
            this.name = String.valueOf(aName) + ".";
        }

        @Override
        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.startsWith(this.name)) {
                result = true;
            }
            return result;
        }
    }
}

