/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSIndexSet;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSJavaArrayListIterator;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSArray<E>
implements Cloneable,
Serializable,
NSCoding,
NSKeyValueCoding,
NSKeyValueCodingAdditions,
_NSFoundationCollection,
List<E>,
RandomAccess {
    public static final Class<NSArray> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSArray.class);
    public static final int NotFound = -1;
    public static final NSArray EmptyArray = new NSArray();
    private static final Logger log = LoggerFactory.getLogger(NSArray.class);
    private static final char _OperatorIndicatorChar = '@';
    public static final String CountOperatorName = "count";
    public static final String MaximumOperatorName = "max";
    public static final String MinimumOperatorName = "min";
    public static final String SumOperatorName = "sum";
    public static final String AverageOperatorName = "avg";
    static final long serialVersionUID = -3789592578296478260L;
    private static final String SerializationValuesFieldKey = "objects";
    private static ConcurrentMap<String, Operator> _operators = new ConcurrentHashMap<String, Operator>(8);
    protected static int _NSArrayClassHashCode;
    protected Object[] _objects;
    protected transient int _hashCache;
    private transient boolean _recomputeHashCode = true;
    public static final boolean CheckForNull = true;
    public static final boolean IgnoreNull = true;
    private static final ObjectStreamField[] serialPersistentFields;

    static {
        try {
            NSArray.setOperatorForKey(CountOperatorName, new _CountOperator());
            NSArray.setOperatorForKey(MaximumOperatorName, new _MaxOperator());
            NSArray.setOperatorForKey(MinimumOperatorName, new _MinOperator());
            NSArray.setOperatorForKey(SumOperatorName, new _SumNumberOperator());
            NSArray.setOperatorForKey(AverageOperatorName, new _AvgNumberOperator());
            _NSArrayClassHashCode = _CLASS.hashCode();
        }
        catch (Throwable e) {
            log.error("Exception occurred in initializer", e);
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationValuesFieldKey, new Object[0].getClass())};
    }

    public static NSArray<String> operatorNames() {
        NSArray<String> operatorNames = new NSArray<String>(_operators.keySet());
        return operatorNames;
    }

    public static void setOperatorForKey(String operatorName, Operator arrayOperator) {
        if (operatorName == null) {
            throw new IllegalArgumentException("Operator key cannot be null");
        }
        if (arrayOperator == null) {
            throw new IllegalArgumentException("Operator cannot be null for " + operatorName);
        }
        _operators.put(operatorName, arrayOperator);
    }

    public static Operator operatorForKey(String operatorName) {
        Operator arrayOperator = (Operator)_operators.get(operatorName);
        return arrayOperator;
    }

    public static void removeOperatorForKey(String operatorName) {
        if (operatorName != null) {
            _operators.remove(operatorName);
        }
    }

    public static <E> NSArray<E> array() {
        return NSArray.emptyArray();
    }

    public static <E> NSArray<E> arrayWithObject(E object) {
        return new NSArray<E>(object);
    }

    public static <E> NSArray<E> arrayWithObjects(E ... objects) {
        return new NSArray<E>(objects, 0, objects != null ? objects.length : 0, true, false);
    }

    public static <E> NSArray<E> arrayWithObjectsIgnoringNulls(E ... objects) {
        return new NSArray<E>(objects, 0, objects != null ? objects.length : 0, true, true);
    }

    public static <E> NSArray<E> arrayWithArray(NSArray<? extends E> array) {
        return new NSArray<E>(array);
    }

    public static <E> NSArray<E> arrayWithCollection(Collection<? extends E> collection) {
        return new NSArray<E>(collection);
    }

    protected void _initializeWithCapacity(int capacity) {
        this._setCount(0);
        this._setObjects(capacity > 0 ? new Object[capacity] : null);
        this._setMustRecomputeHash(true);
    }

    public NSArray() {
        this(null, 0, 0, false, false);
    }

    public NSArray(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an NSArray");
        }
        this._initializeWithCapacity(1);
        this._objects()[0] = object;
        this._setCount(1);
    }

    private void initFromObjects(Object[] objects, int rangeLocation, int rangeLength, int offset, boolean checkForNull, boolean ignoreNull) {
        if (checkForNull) {
            int maxRange = rangeLocation + rangeLength;
            int validObjectcount = 0;
            Object[] validObjects = new Object[maxRange];
            int i = rangeLocation;
            while (i < maxRange) {
                if (objects[i] == null) {
                    if (!ignoreNull) {
                        throw new IllegalArgumentException("Attempt to insert null into an " + this.getClass().getName() + ".");
                    }
                } else {
                    validObjects[validObjectcount] = objects[i];
                    ++validObjectcount;
                }
                ++i;
            }
            this._initializeWithCapacity(validObjectcount + offset);
            if (validObjectcount > 0) {
                System.arraycopy(validObjects, 0, this._objects(), offset, validObjectcount);
            }
            this._setCount(validObjectcount + offset);
        } else {
            this._initializeWithCapacity(rangeLength + offset);
            if (rangeLength > 0) {
                System.arraycopy(objects, rangeLocation, this._objects(), offset, rangeLength);
            }
            this._setCount(rangeLength + offset);
        }
    }

    protected NSArray(Object[] objects, int rangeLocation, int rangeLength, boolean checkForNull, boolean ignoreNull) {
        this.initFromObjects(objects, rangeLocation, rangeLength, 0, checkForNull, ignoreNull);
    }

    public NSArray(E[] objects) {
        this(objects, 0, objects != null ? objects.length : 0, true, true);
    }

    public NSArray(E object, E ... objects) {
        if (object == null) {
            this.initFromObjects(objects, 0, objects == null ? 0 : objects.length, 0, true, true);
        } else {
            this.initFromObjects(objects, 0, objects == null ? 0 : objects.length, 1, true, true);
            this._objects()[0] = object;
        }
    }

    public NSArray(E[] objects, NSRange range) {
        this(objects, range != null ? range.location() : 0, range != null ? range.length() : 0, true, true);
    }

    public NSArray(NSArray<? extends E> otherArray) {
        this(otherArray != null ? otherArray.objectsNoCopy() : null, 0, otherArray != null ? otherArray.count() : 0, false, false);
    }

    public NSArray(Collection<? extends E> collection, boolean checkForNull) {
        if (collection == null) {
            throw new NullPointerException("Collection cannot be null");
        }
        Object[] anArray = collection.toArray();
        this.initFromObjects(anArray, 0, anArray.length, 0, checkForNull, false);
    }

    public NSArray(Collection<? extends E> collection) {
        this(collection, true);
    }

    public NSArray(List<? extends E> list, NSRange range, boolean ignoreNull) {
        if (range != null) {
            int rangeLength;
            if (list == null) {
                throw new IllegalArgumentException("Vector cannot be null");
            }
            int rangeLocation = range.location();
            int capacity = rangeLength = range.length();
            if (ignoreNull) {
                int i = 0;
                while (i < rangeLength) {
                    if (list.get(i + rangeLocation) == null) {
                        --capacity;
                    }
                    ++i;
                }
            }
            this._initializeWithCapacity(capacity);
            Object[] objects = this._objects();
            int count = 0;
            int i = 0;
            while (i < rangeLength) {
                E object = list.get(i + rangeLocation);
                if (object != null) {
                    objects[count++] = object;
                } else if (!ignoreNull) {
                    throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
                }
                ++i;
            }
            this._setCount(count);
        }
    }

    protected Object[] objectsNoCopy() {
        return this._objects != null ? this._objects : _NSCollectionPrimitives.EmptyArray;
    }

    public int count() {
        return this._count();
    }

    protected int _count() {
        return this._objects() == null ? 0 : this._objects().length;
    }

    protected void _setCount(int count) {
    }

    protected Object[] _objects() {
        return this._objects;
    }

    protected void _setObjects(Object[] objects) {
        this._objects = objects;
    }

    public E objectAtIndex(int index) {
        if (index >= 0 && index < this._count()) {
            Object objectAtIndex = this._objects()[index];
            return (E)objectAtIndex;
        }
        if (this._count() == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count() - 1) + "]");
    }

    public NSArray<E> objectsAtIndexes(NSIndexSet iset) {
        if (iset == null) {
            throw new IllegalArgumentException("Index set is null");
        }
        int lastIndex = iset.lastIndex();
        int count = this.count();
        if (lastIndex != -1 && count <= lastIndex) {
            throw new IllegalArgumentException("Last index (" + lastIndex + ") of index set is out of bounds [0, " + (count - 1) + "]");
        }
        Object[] resultObjects = new Object[iset.count()];
        int i = 0;
        int rangeCount = iset.rangeCount();
        int rangeI = 0;
        while (rangeI < rangeCount) {
            NSRange range = iset.rangeAtIndex(rangeI);
            this.getObjects(resultObjects, i, range);
            i += range.length();
            ++rangeI;
        }
        assert (i == resultObjects.length);
        return new NSArray<Object>(resultObjects);
    }

    public NSArray<E> arrayByAddingObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int count = this.count();
        Object[] objects = new Object[count + 1];
        System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        objects[count] = object;
        return new NSArray<E>(objects, 0, count + 1, false, false);
    }

    public static <E> NSArray<E> arrayByAddingObject(NSArray<? extends E> array, E object) {
        NSArray<E> uncheckedArray = array;
        return uncheckedArray.arrayByAddingObject(object);
    }

    public NSArray<E> arrayByAddingObjectsFromArray(NSArray<? extends E> otherArray) {
        if (otherArray != null) {
            int count = this.count();
            int otherCount = otherArray.count();
            if (count == 0) {
                return new NSArray<E>(otherArray);
            }
            if (otherCount == 0) {
                return (NSArray)this.clone();
            }
            Object[] objects = new Object[count + otherCount];
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
            System.arraycopy(otherArray.objectsNoCopy(), 0, objects, count, otherCount);
            return new NSArray<E>(objects, 0, count + otherCount, false, false);
        }
        return new NSArray<E>(this);
    }

    public static <E> NSArray<E> arrayByAddingObjectsFromArray(NSArray<? extends E> array, NSArray<? extends E> otherArray) {
        NSArray<? extends E> uncheckedArray = array;
        return uncheckedArray.arrayByAddingObjectsFromArray(otherArray);
    }

    public Object[] objects() {
        int count = this.count();
        Object[] objects = new Object[count];
        if (count > 0) {
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        }
        return objects;
    }

    public Object[] objects(NSRange range) {
        if (range == null) {
            return _NSCollectionPrimitives.EmptyArray;
        }
        int rangeLength = range.length();
        Object[] objects = new Object[rangeLength];
        System.arraycopy(this.objectsNoCopy(), range.location(), objects, 0, rangeLength);
        return objects;
    }

    public Vector<E> vector() {
        Object[] objects = this.objectsNoCopy();
        Vector<Object> vector = new Vector<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            vector.addElement(objects[i]);
            ++i;
        }
        return vector;
    }

    public ArrayList<E> arrayList() {
        Object[] objects = this.objectsNoCopy();
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            list.add(objects[i]);
            ++i;
        }
        return list;
    }

    public boolean containsObject(Object object) {
        if (object == null) {
            return false;
        }
        return this._findObjectInArray(0, this.count(), object, false) != -1;
    }

    public E firstObjectCommonWithArray(NSArray<?> otherArray) {
        if (otherArray == null) {
            return null;
        }
        int otherCount = otherArray.count();
        if (otherCount > 0) {
            Object[] objects = this.objectsNoCopy();
            int i = 0;
            while (i < objects.length) {
                if (otherArray.containsObject(objects[i])) {
                    return (E)objects[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Deprecated
    public void getObjects(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Object buffer cannot be null");
        }
        System.arraycopy(this.objectsNoCopy(), 0, objects, 0, this.count());
    }

    @Deprecated
    public void getObjects(Object[] objects, NSRange range) {
        if (objects == null) {
            throw new IllegalArgumentException("Object buffer cannot be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
        System.arraycopy(this.objectsNoCopy(), range.location(), objects, 0, range.length());
    }

    public void getObjects(Object[] objects, int destPos) {
        this._getObjects(objects, destPos, 0, this.count());
    }

    public void getObjects(Object[] objects, int destPos, NSRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
        this._getObjects(objects, destPos, range.location(), range.length());
    }

    private final void _getObjects(Object[] objects, int destPos, int sourcePos, int length) {
        if (objects == null) {
            throw new IllegalArgumentException("Object buffer cannot be null");
        }
        if (objects.length - destPos < length) {
            throw new IllegalArgumentException("Object buffer must be large enough to hold " + length + " entries beginning at index " + destPos);
        }
        System.arraycopy(this.objectsNoCopy(), sourcePos, objects, destPos, length);
    }

    private final int _findObjectInArray(int index, int length, Object object, boolean identical) {
        block6: {
            if (this.count() <= 0 || object == null) break block6;
            Object[] objects = this.objectsNoCopy();
            int maxIndex = index + length - 1;
            if (!identical) {
                int i = index;
                while (i <= maxIndex) {
                    if (object == objects[i] || object.equals(objects[i])) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int i = index;
                while (i <= maxIndex) {
                    if (objects[i] == object) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public int indexOfObject(Object object) {
        if (object == null) {
            return -1;
        }
        return this._findObjectInArray(0, this.count(), object, false);
    }

    public int indexOfObject(Object object, NSRange range) {
        int rangeLength;
        if (object == null || range == null) {
            return -1;
        }
        int count = this._count();
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
            throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (count - 1) + "]");
        }
        return this._findObjectInArray(rangeLocation, rangeLength, object, false);
    }

    public int indexOfIdenticalObject(Object object) {
        if (object == null) {
            return -1;
        }
        return this._findObjectInArray(0, this.count(), object, true);
    }

    public int indexOfIdenticalObject(Object object, NSRange range) {
        int rangeLength;
        if (object == null || range == null) {
            return -1;
        }
        int count = this._count();
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
            throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count() - 1) + "]");
        }
        return this._findObjectInArray(rangeLocation, rangeLength, object, true);
    }

    public NSArray<E> subarrayWithRange(NSRange range) {
        if (range == null) {
            return NSArray.emptyArray();
        }
        return new NSArray<E>(this.objectsNoCopy(), range.location(), range.length(), false, false);
    }

    public E lastObject() {
        int count = this.count();
        return count == 0 ? null : (E)this.objectAtIndex(count - 1);
    }

    private boolean _equalsArray(List<?> otherArray) {
        int count = this.count();
        if (count != otherArray.size()) {
            return false;
        }
        if (!this._mustRecomputeHash() && this.hashCode() != otherArray.hashCode()) {
            return false;
        }
        Object[] objects = this.objectsNoCopy();
        Object[] otherObjects = otherArray.toArray();
        int i = 0;
        while (i < count) {
            if (!objects[i].equals(otherObjects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualToArray(NSArray<?> otherArray) {
        if (otherArray == this) {
            return true;
        }
        if (otherArray == null) {
            return false;
        }
        return this._equalsArray(otherArray);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            return this._equalsArray((List)object);
        }
        return false;
    }

    public Enumeration<E> objectEnumerator() {
        return new _NSJavaArrayEnumerator(this._objects(), this._count(), false);
    }

    public Enumeration<E> reverseObjectEnumerator() {
        return new _NSJavaArrayEnumerator(this._objects(), this._count(), true);
    }

    @Deprecated
    public NSArray<E> sortedArrayUsingSelector(NSSelector<Integer> selector) throws NSComparator.ComparisonException {
        NSMutableArray array = new NSMutableArray(this);
        NSComparator._NSSelectorComparator comparator = new NSComparator._NSSelectorComparator(selector);
        array.sortUsingComparator(comparator);
        return array;
    }

    public NSArray<E> sortedArrayUsingComparator(NSComparator comparator) throws NSComparator.ComparisonException {
        NSMutableArray array = new NSMutableArray(this);
        array.sortUsingComparator(comparator);
        return array;
    }

    public String componentsJoinedByString(String separator) {
        Object[] objects = this.objectsNoCopy();
        StringBuffer buffer = new StringBuffer(objects.length * 32);
        int i = 0;
        while (i < objects.length) {
            if (i > 0 && separator != null) {
                buffer.append(separator);
            }
            buffer.append(objects[i].toString());
            ++i;
        }
        return new String(buffer);
    }

    public static NSArray<String> componentsSeparatedByString(String string, String separator) {
        NSMutableArray<String> objects;
        if (string == null || string.length() == 0) {
            return NSArray.emptyArray();
        }
        int stringLength = string.length();
        if (separator == null || separator.length() == 0) {
            return new NSArray<String>(string);
        }
        int separatorLength = separator.length();
        int start = 0;
        int index = 0;
        int count = 0;
        if (separatorLength == 1 && stringLength < 256) {
            char[] parseData = string.toCharArray();
            char charSeparator = separator.charAt(0);
            int i = 0;
            while (i < stringLength) {
                if (parseData[i] == charSeparator) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                return new NSMutableArray<String>(string);
            }
            objects = new NSMutableArray(count + 1);
            int end = stringLength - 1;
            index = 0;
            while (index <= end) {
                if (parseData[index] == charSeparator) {
                    if (start == index) {
                        objects.addObject("");
                    } else {
                        objects.addObject(string.substring(start, index));
                    }
                    start = index + 1;
                }
                ++index;
            }
            if (parseData[end] == charSeparator) {
                if (start < end) {
                    objects.addObject(string.substring(start, end));
                }
                objects.addObject("");
            } else {
                objects.addObject(string.substring(start, stringLength));
            }
        } else {
            objects = new NSMutableArray<String>(4);
            int end = stringLength - separatorLength;
            while (start < stringLength) {
                index = string.indexOf(separator, start);
                if (index < 0) {
                    index = stringLength;
                }
                if (index != end) {
                    objects.addObject(string.substring(start, index));
                    start = index + separatorLength;
                    continue;
                }
                if (start < index) {
                    objects.addObject(string.substring(start, index));
                } else {
                    objects.addObject("");
                }
                objects.addObject("");
                break;
            }
        }
        return objects;
    }

    public static NSMutableArray<String> _mutableComponentsSeparatedByString(String string, String separator) {
        return NSArray.componentsSeparatedByString(string, separator).mutableClone();
    }

    private Object _valueForKeyPathWithOperator(String keyPath) {
        String operatorPath;
        String operatorName;
        int index = keyPath.indexOf(46);
        if (index < 0) {
            operatorName = keyPath.substring(1);
            operatorPath = "";
        } else {
            operatorName = keyPath.substring(1, index);
            operatorPath = index < keyPath.length() - 1 ? keyPath.substring(index + 1) : "";
        }
        Operator arrayOperator = NSArray.operatorForKey(operatorName);
        if (arrayOperator != null) {
            return arrayOperator.compute(this, operatorPath);
        }
        throw new IllegalArgumentException("No key operator available to compute aggregate " + keyPath);
    }

    @Override
    public Object valueForKey(String key) {
        if (key != null && key.length() > 0) {
            if (key.charAt(0) == '@') {
                return this._valueForKeyPathWithOperator(key);
            }
            if (key.equals(CountOperatorName)) {
                return _NSUtilities.IntegerForInt(this.count());
            }
        }
        if (key != null && key.length() == 0) {
            throw new NSKeyValueCoding.UnknownKeyException("You must provide a key to valueForKey on an NSArray.", this, "");
        }
        Object[] objects = this.objectsNoCopy();
        NSMutableArray<Object> values = new NSMutableArray<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(objects[i], key);
            values.addObject(value != null ? value : NSKeyValueCoding.Utility.nullValue());
            ++i;
        }
        return values;
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        Object[] objects = this.objectsNoCopy();
        int i = 0;
        while (i < objects.length) {
            NSKeyValueCodingAdditions.Utility.takeValueForKeyPath(objects[i], value, key);
            ++i;
        }
    }

    @Override
    public Object valueForKeyPath(String keyPath) {
        if (keyPath != null && keyPath.charAt(0) == '@') {
            return this._valueForKeyPathWithOperator(keyPath);
        }
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath(this, keyPath);
    }

    @Override
    public void takeValueForKeyPath(Object value, String keyPath) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath(this, value, keyPath);
    }

    @Override
    public Class<?> classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        return new NSArray<Object>(coder.decodeObjects());
    }

    @Override
    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObjects(this.objectsNoCopy());
    }

    public void makeObjectsPerformSelector(NSSelector<?> selector, Object[] parameters) {
        if (selector == null) {
            throw new IllegalArgumentException("Selector cannot be null");
        }
        Object[] objects = this.objectsNoCopy();
        int i = 0;
        while (i < objects.length) {
            NSSelector._safeInvokeSelector(selector, objects[i], parameters);
            ++i;
        }
    }

    @Override
    public int _shallowHashCode() {
        return _NSArrayClassHashCode;
    }

    @Override
    public int hashCode() {
        if (this._mustRecomputeHash()) {
            int hash = 0;
            int max = this.count() > 16 ? 16 : this.count();
            Object[] objects = this._objects();
            int i = 0;
            while (i < max) {
                Object element = objects[i];
                hash = element instanceof _NSFoundationCollection ? (hash ^= ((_NSFoundationCollection)element)._shallowHashCode()) : (hash ^= element.hashCode());
                ++i;
            }
            this._hashCache = hash;
            this._setMustRecomputeHash(false);
        }
        return this._hashCache;
    }

    public Object clone() {
        return this;
    }

    public NSArray<E> immutableClone() {
        return this;
    }

    public static <E> NSArray<E> immutableCloneOf(NSArray<? extends E> array) {
        NSArray<? extends E> immutableClone = array.immutableClone();
        return immutableClone;
    }

    public NSMutableArray<E> mutableClone() {
        return new NSMutableArray(this);
    }

    public static <E> NSMutableArray<E> mutableCloneOf(NSArray<? extends E> array) {
        NSMutableArray<? extends E> mutableClone = array.mutableClone();
        return mutableClone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("( ");
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E object = iterator.next();
            String str = object != null ? object.toString() : "null";
            str = _NSStringUtilities.trimToDebugLength(str);
            if (object instanceof String) {
                buffer.append("\"");
                buffer.append(str);
                buffer.append("\"");
            } else {
                buffer.append(str);
            }
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(" )");
        return new String(buffer);
    }

    public String toDebugString() {
        return NSPropertyListSerialization.debugStringFromPropertyList(this);
    }

    protected boolean _mustRecomputeHash() {
        return this._recomputeHashCode;
    }

    protected void _setMustRecomputeHash(boolean change) {
        this._recomputeHashCode = change;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationValuesFieldKey, this.objects());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        values = values == null ? _NSUtilities._NoObjectArray : values;
        this.initFromObjects(values, 0, values.length, 0, true, false);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptyArray;
        }
        return this;
    }

    public static final <T> NSArray<T> emptyArray() {
        return EmptyArray;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean add(E element) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean contains(Object element) {
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        return this.containsObject(element);
    }

    @Override
    public Iterator<E> iterator() {
        return new _NSJavaArrayListIterator(this._objects(), this._count());
    }

    @Override
    public Object[] toArray() {
        return this.objects();
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        if (objects == null) {
            throw new NullPointerException("List.toArray() cannot have a null parameter");
        }
        int count = this.count();
        if (count <= 0) {
            return objects;
        }
        Object[] result = objects;
        if (result.length < count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), count);
        }
        int j = 0;
        while (j < result.length) {
            result[j] = j < count ? this.objectAtIndex(j) : null;
            ++j;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] objects = c.toArray();
        if (objects.length > 0) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] == null) {
                    return false;
                }
                if (this._findObjectInArray(0, this.count(), objects[i], false) == -1) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new _NSJavaArrayListIterator(this._objects(), this._count());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new _NSJavaArrayListIterator(this._objects(), this._count(), index);
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        return this.objectAtIndex(index);
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        throw new UnsupportedOperationException("Set is not a support operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public int indexOf(Object element) {
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        return this.indexOfObject(element);
    }

    @Override
    public int lastIndexOf(Object element) {
        int lastIndex = -1;
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        Object[] objects = this._objects();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] != null && objects[i].equals(element)) {
                    lastIndex = i;
                }
                ++i;
            }
        }
        return lastIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Remove is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Remove is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Clear is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("RetainAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("RemoveAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.count() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Illegal index value (fromIndex < 0 || toIndex > size || fromIndex > toIndex)");
        }
        return this.subarrayWithRange(new NSRange(fromIndex, toIndex - fromIndex));
    }

    public static interface Operator {
        public Object compute(NSArray<?> var1, String var2);
    }

    static class _AvgNumberOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            int count = values.count();
            if (count != 0) {
                BigDecimal sum = this._sum(values, keyPath);
                return sum.divide(BigDecimal.valueOf(count), sum.scale() + 4, 6);
            }
            return null;
        }
    }

    static class _CountOperator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            return _NSUtilities.IntegerForInt(values.count());
        }
    }

    static class _MaxOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            Object max = null;
            Object[] objects = values.objectsNoCopy();
            int i = 0;
            while (i < objects.length) {
                max = this._minOrMaxValue(max, this._operationValue(objects[i], keyPath), true);
                ++i;
            }
            return max;
        }
    }

    static class _MinOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            Object min = null;
            Object[] objects = values.objectsNoCopy();
            int i = 0;
            while (i < objects.length) {
                min = this._minOrMaxValue(min, this._operationValue(objects[i], keyPath), false);
                ++i;
            }
            return min;
        }
    }

    static class _Operator {
        protected Object _operationValue(Object object, String keyPath) {
            return keyPath != null && keyPath.length() > 0 ? NSKeyValueCodingAdditions.Utility.valueForKeyPath(object, keyPath) : object;
        }

        private BigDecimal _bigDecimalForValue(Object object) {
            if (object != null) {
                if (_NSUtilities._isClassANumberOrABoolean(object.getClass())) {
                    return (BigDecimal)_NSUtilities.convertNumberOrBooleanIntoCompatibleValue(object, _NSUtilities._BigDecimalClass);
                }
                if (object instanceof String) {
                    return new BigDecimal((String)object);
                }
                throw new IllegalStateException("Can't convert " + object + " (class " + object.getClass().getName() + ") into number");
            }
            return null;
        }

        BigDecimal _sum(NSArray<?> values, String keyPath) {
            BigDecimal sum = BigDecimal.valueOf(0L);
            Object[] objects = values.objectsNoCopy();
            int i = 0;
            while (i < objects.length) {
                BigDecimal value = this._bigDecimalForValue(this._operationValue(objects[i], keyPath));
                if (value != null) {
                    sum = sum.add(value);
                }
                ++i;
            }
            return sum;
        }

        Object _minOrMaxValue(Object referenceValue, Object compareValue, boolean trueForMaxAndFalseForMin) {
            int comparison;
            if (referenceValue == null) {
                return compareValue;
            }
            if (compareValue == null) {
                return referenceValue;
            }
            if (_NSUtilities._isClassANumberOrABoolean(referenceValue.getClass())) {
                comparison = _NSUtilities.compareNumbersOrBooleans(referenceValue, compareValue);
            } else if (referenceValue instanceof NSTimestamp) {
                comparison = ((NSTimestamp)referenceValue).compare((NSTimestamp)compareValue);
            } else if (referenceValue instanceof Comparable) {
                comparison = ((Comparable)referenceValue).compareTo(compareValue);
            } else {
                throw new IllegalStateException("Cannot compare values " + referenceValue + " and " + compareValue + " (they are not instance of Comparable");
            }
            if (trueForMaxAndFalseForMin ? comparison >= 0 : comparison <= 0) {
                return referenceValue;
            }
            return compareValue;
        }
    }

    static class _SumNumberOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            return this._sum(values, keyPath);
        }
    }
}

