/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ObjectLongProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractObjectLongMap<T>
extends AbstractSet {
    public boolean containsKey(final T key) {
        return !this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final long value) {
        return !this.forEachPair(new ObjectLongProcedure<T>(){

            @Override
            public boolean apply(T iterKey, long iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractObjectLongMap<T> copy() {
        return (AbstractObjectLongMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractObjectLongMap)) {
            return false;
        }
        final AbstractObjectLongMap other = (AbstractObjectLongMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ObjectLongProcedure<T>(){

            @Override
            public boolean apply(T key, long value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ObjectLongProcedure<T>(){

            @Override
            public boolean apply(T key, long value) {
                return AbstractObjectLongMap.this.containsKey(key) && AbstractObjectLongMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ObjectProcedure<T> var1);

    public boolean forEachPair(final ObjectLongProcedure<T> procedure) {
        return this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                return procedure.apply(key, AbstractObjectLongMap.this.get(key));
            }
        });
    }

    public abstract long get(T var1);

    public List<T> keys() {
        ArrayList list = new ArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final List<T> list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(List<T> keyList) {
        this.pairsSortedByValue(keyList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final ObjectLongProcedure<T> condition, final List<T> keyList, final LongArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ObjectLongProcedure<T>(){

            @Override
            public boolean apply(T key, long value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(List<T> keyList, LongArrayList valueList) {
        this.keys(keyList);
        if (keyList.isEmpty()) {
            return;
        }
        T k = keyList.get(0);
        if (!(k instanceof Comparable)) {
            throw new UnsupportedOperationException("The key type for this map does not implement comparable");
        }
        Collections.sort(keyList);
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.get(i)));
        }
    }

    public void pairsSortedByValue(final List<T> keyList, LongArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final long[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                long t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                Object t2 = keyList.get(a);
                keyList.set(a, keyList.get(b));
                keyList.set(b, t2);
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : 0);
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(T var1, long var2);

    public abstract boolean removeKey(T var1);

    public String toString() {
        List<T> theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            T key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ArrayList theKeys = new ArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public LongArrayList values() {
        LongArrayList list = new LongArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final LongArrayList list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(AbstractObjectLongMap.this.get(key));
                return true;
            }
        });
    }

    public long adjustOrPutValue(T key, long newValue, long incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

