/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.buffer.FloatBufferConsumer;
import org.apache.mahout.math.function.FloatComparator;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.AbstractList;
import org.apache.mahout.math.list.FloatArrayList;

public abstract class AbstractFloatList
extends AbstractList
implements FloatBufferConsumer,
Cloneable {
    protected int size;

    public void add(float element) {
        this.beforeInsert(this.size, element);
    }

    public void addAllOf(AbstractFloatList other) {
        this.addAllOfFromTo(other, 0, other.size() - 1);
    }

    public void addAllOfFromTo(AbstractFloatList other, int from, int to) {
        this.beforeInsertAllOfFromTo(this.size, other, from, to);
    }

    @Override
    public void addAllOf(FloatArrayList other) {
        this.addAllOfFromTo(other, 0, other.size() - 1);
    }

    public void beforeInsert(int index, float element) {
        this.beforeInsertDummies(index, 1);
        this.set(index, element);
    }

    public void beforeInsertAllOfFromTo(int index, AbstractFloatList other, int from, int to) {
        int length = to - from + 1;
        this.beforeInsertDummies(index, length);
        this.replaceFromToWithFrom(index, index + length - 1, other, from);
    }

    @Override
    protected void beforeInsertDummies(int index, int length) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (length > 0) {
            this.ensureCapacity(this.size + length);
            this.setSizeRaw(this.size + length);
            this.replaceFromToWithFrom(index + length, this.size - 1, this, index);
        }
    }

    public int binarySearch(float key) {
        return this.binarySearchFromTo(key, 0, this.size - 1);
    }

    public int binarySearchFromTo(float key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = (low + high) / 2;
            float midVal = this.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(float elem) {
        return this.indexOfFromTo(elem, 0, this.size - 1) >= 0;
    }

    public void delete(float element) {
        int index = this.indexOfFromTo(element, 0, this.size - 1);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public float[] elements() {
        float[] myElements = new float[this.size];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public AbstractFloatList elements(float[] elements) {
        this.clear();
        this.addAllOfFromTo(new FloatArrayList(elements), 0, elements.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof AbstractFloatList)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        AbstractFloatList other = (AbstractFloatList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = this.size();
        while (--i >= 0) {
            if (this.getQuick(i) == other.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int from, int to, float val) {
        AbstractFloatList.checkRangeFromTo(from, to, this.size);
        int i = from;
        while (i <= to) {
            this.setQuick(i++, val);
        }
    }

    public boolean forEach(FloatProcedure procedure) {
        int i = 0;
        while (i < this.size) {
            if (procedure.apply(this.get(i++))) continue;
            return false;
        }
        return true;
    }

    public float get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.getQuick(index);
    }

    protected abstract float getQuick(int var1);

    public int indexOf(float element) {
        return this.indexOfFromTo(element, 0, this.size - 1);
    }

    public int indexOfFromTo(float element, int from, int to) {
        AbstractFloatList.checkRangeFromTo(from, to, this.size);
        for (int i = from; i <= to; ++i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float element) {
        return this.lastIndexOfFromTo(element, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(float element, int from, int to) {
        AbstractFloatList.checkRangeFromTo(from, to, this.size());
        for (int i = to; i >= from; --i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void mergeSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractFloatList.checkRangeFromTo(from, to, mySize);
        float[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void mergeSortFromTo(int from, int to, FloatComparator c) {
        int mySize = this.size();
        AbstractFloatList.checkRangeFromTo(from, to, mySize);
        float[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public AbstractFloatList partFromTo(int from, int to) {
        AbstractFloatList.checkRangeFromTo(from, to, this.size);
        int length = to - from + 1;
        FloatArrayList part = new FloatArrayList(length);
        part.addAllOfFromTo(this, from, to);
        return part;
    }

    @Override
    public void quickSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractFloatList.checkRangeFromTo(from, to, mySize);
        float[] myElements = this.elements();
        java.util.Arrays.sort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void quickSortFromTo(int from, int to, FloatComparator c) {
        int mySize = this.size();
        AbstractFloatList.checkRangeFromTo(from, to, mySize);
        float[] myElements = this.elements();
        Sorting.quickSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public boolean removeAll(AbstractFloatList other) {
        if (other.isEmpty()) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) >= 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void removeFromTo(int from, int to) {
        int width;
        AbstractFloatList.checkRangeFromTo(from, to, this.size);
        int numMoved = this.size - to - 1;
        if (numMoved > 0) {
            this.replaceFromToWithFrom(from, from - 1 + numMoved, this, to + 1);
        }
        if ((width = to - from + 1) > 0) {
            this.setSizeRaw(this.size - width);
        }
    }

    public void replaceFromToWithFrom(int from, int to, AbstractFloatList other, int otherFrom) {
        block4: {
            int length = to - from + 1;
            if (length <= 0) break block4;
            AbstractFloatList.checkRangeFromTo(from, to, this.size());
            AbstractFloatList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            if (from <= otherFrom) {
                while (--length >= 0) {
                    this.setQuick(from++, other.getQuick(otherFrom++));
                }
            } else {
                int otherTo = otherFrom + length - 1;
                while (--length >= 0) {
                    this.setQuick(to--, other.getQuick(otherTo--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int from, int to, AbstractFloatList other, int otherFrom, int otherTo) {
        int length;
        if (otherFrom > otherTo) {
            throw new IndexOutOfBoundsException("otherFrom: " + otherFrom + ", otherTo: " + otherTo);
        }
        if (this == other && to - from != otherTo - otherFrom) {
            this.replaceFromToWithFromTo(from, to, this.partFromTo(otherFrom, otherTo), 0, otherTo - otherFrom);
            return;
        }
        int diff = length = otherTo - otherFrom + 1;
        int theLast = from - 1;
        if (to >= from) {
            diff -= to - from + 1;
            theLast = to;
        }
        if (diff > 0) {
            this.beforeInsertDummies(theLast + 1, diff);
        } else if (diff < 0) {
            this.removeFromTo(theLast + diff, theLast - 1);
        }
        if (length > 0) {
            this.replaceFromToWithFrom(from, from + length - 1, other, otherFrom);
        }
    }

    public boolean retainAll(AbstractFloatList other) {
        if (other.isEmpty()) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) < 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size() / 2;
        int j = this.size() - 1;
        int i = 0;
        while (i < limit) {
            float tmp = this.getQuick(i);
            this.setQuick(i++, this.getQuick(j));
            this.setQuick(j--, tmp);
        }
    }

    public void set(int index, float element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.setQuick(index, element);
    }

    protected abstract void setQuick(int var1, float var2);

    protected void setSizeRaw(int newSize) {
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractFloatList times(int times) {
        FloatArrayList newList = new FloatArrayList(times * this.size());
        int i = times;
        while (--i >= 0) {
            newList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return newList;
    }

    public List<Float> toList() {
        int mySize = this.size();
        ArrayList<Float> list = new ArrayList<Float>(mySize);
        for (int i = 0; i < mySize; ++i) {
            list.add(Float.valueOf(this.get(i)));
        }
        return list;
    }

    public float[] toArray(float[] values) {
        int mySize = this.size();
        float[] myElements = values.length >= mySize ? values : new float[mySize];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

