/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

public class MatrixVectorView
extends AbstractVector {
    private Matrix matrix;
    private int row;
    private int column;
    private int rowStride;
    private int columnStride;

    public MatrixVectorView(Matrix matrix, int row, int column, int rowStride, int columnStride) {
        super(MatrixVectorView.viewSize(matrix, row, column, rowStride, columnStride));
        if (row < 0 || row > matrix.rowSize()) {
            throw new IndexException(row, matrix.rowSize());
        }
        if (column < 0 || column > matrix.columnSize()) {
            throw new IndexException(column, matrix.columnSize());
        }
        this.matrix = matrix;
        this.row = row;
        this.column = column;
        this.rowStride = rowStride;
        this.columnStride = columnStride;
    }

    private static int viewSize(Matrix matrix, int row, int column, int rowStride, int columnStride) {
        if (rowStride != 0 && columnStride != 0) {
            int n1 = (matrix.numRows() - row) / rowStride;
            int n2 = (matrix.numCols() - column) / columnStride;
            return Math.min(n1, n2);
        }
        if (rowStride > 0) {
            return (matrix.numRows() - row) / rowStride;
        }
        return (matrix.numCols() - column) / columnStride;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        final AbstractVector.LocalElement r = new AbstractVector.LocalElement(this, 0);
        return new Iterator<Vector.Element>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < MatrixVectorView.this.size();
            }

            @Override
            public Vector.Element next() {
                if (this.i >= MatrixVectorView.this.size()) {
                    throw new NoSuchElementException();
                }
                r.index = this.i++;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove from a view");
            }
        };
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return this.iterator();
    }

    @Override
    public double getQuick(int index) {
        return this.matrix.getQuick(this.row + this.rowStride * index, this.column + this.columnStride * index);
    }

    @Override
    public Vector like() {
        return this.matrix.like(this.size(), 1).viewColumn(0);
    }

    @Override
    public void setQuick(int index, double value) {
        this.matrix.setQuick(this.row + this.rowStride * index, this.column + this.columnStride * index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.size();
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        int[] offset = new int[]{this.row, this.column};
        int[] size = new int[]{this.rowStride == 0 ? 1 : this.rowStride, this.columnStride == 0 ? 1 : this.columnStride};
        return this.matrix.viewPart(offset, size);
    }

    @Override
    public Vector clone() {
        MatrixVectorView r = (MatrixVectorView)super.clone();
        r.matrix = this.matrix.clone();
        r.row = this.row;
        r.column = this.column;
        r.rowStride = this.rowStride;
        r.columnStride = this.columnStride;
        return r;
    }
}

