/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.util;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class UTF8CharacterDecoder {
    private final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    private final CharBuffer outCharBuffer = CharBuffer.allocate(1);

    public CharBuffer decode(ByteBuffer bb) throws CharacterCodingException {
        int availableBytes = bb.remaining();
        if (availableBytes == 0) {
            return null;
        }
        bb.mark();
        byte firstByte = bb.get();
        int characterByteCount = UTF8CharacterDecoder.characterByteCount(firstByte);
        if (characterByteCount > availableBytes) {
            bb.reset();
            throw new BufferUnderflowException();
        }
        ByteBuffer outBB = ByteBuffer.wrap(new byte[characterByteCount]);
        outBB.put(firstByte);
        for (int i = 1; i < characterByteCount; ++i) {
            outBB.put(bb.get());
        }
        outBB.flip();
        this.outCharBuffer.clear();
        CoderResult result = this.decoder.decode(outBB, this.outCharBuffer, true);
        if (result.isError()) {
            bb.reset();
            result.throwException();
        }
        this.outCharBuffer.flip();
        return this.outCharBuffer;
    }

    private static int characterByteCount(byte b) {
        int x = b & 0xFF;
        if (x < 128) {
            return 1;
        }
        if (x < 224) {
            return 2;
        }
        if (x < 240) {
            return 3;
        }
        if (x < 248) {
            return 4;
        }
        return 5;
    }
}

