/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.request.action;

import com.apple.transporter.commlink.TCSError;
import com.apple.transporter.commlink.TCSResponse;
import com.apple.transporter.commlink.request.action.ActionHandler;
import com.apple.transporter.commlink.request.action.ActionHandlerRegistry;
import com.apple.transporter.log.Logger;
import java.util.Map;

public class EchoActionHandler
implements ActionHandler {
    private static final EchoActionHandler sharedInstance = new EchoActionHandler();

    @Override
    public TCSResponse perform(String identifier, Map<String, ?> arguments) {
        if (null == arguments) {
            return TCSResponse.errorResponse(TCSError.INVALID_ACTION_ARGUMENTS.makeException("arguments parameter is null"));
        }
        String message = (String)arguments.get("message");
        if (null == message) {
            return TCSResponse.errorResponse(TCSError.INVALID_ACTION_ARGUMENTS.makeException("message parameter is null"));
        }
        String logLevel = (String)arguments.get("logLevel");
        if (null == logLevel) {
            Logger.info((String)message);
        } else if (logLevel.equals("debug")) {
            Logger.debug((String)message);
        } else if (logLevel.equals("warn")) {
            Logger.warn((String)message);
        } else if (logLevel.equals("error")) {
            Logger.error((String)message);
        } else if (logLevel.equals("essential")) {
            Logger.essential((String)message);
        } else if (logLevel.equals("extreme")) {
            Logger.extreme((String)message);
        } else if (logLevel.equals("fatal")) {
            Logger.fatal((String)message);
        } else {
            return TCSResponse.errorResponse(TCSError.INVALID_ACTION_ARGUMENTS.makeException("invalid log level " + logLevel));
        }
        return TCSResponse.okResponse();
    }

    public static ActionHandlerRegistry.Factory getFactory() {
        return new ActionHandlerRegistry.Factory(){

            @Override
            public ActionHandler get() {
                return sharedInstance;
            }
        };
    }

    public static void registerWithName(String methodName) {
        ActionHandlerRegistry.registerFactoryWithName(EchoActionHandler.getFactory(), methodName);
    }
}

