/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.request;

import com.apple.transporter.commlink.TCSError;
import com.apple.transporter.commlink.TCSException;
import com.apple.transporter.commlink.TCSRequest;
import com.apple.transporter.commlink.TCSResponse;
import com.apple.transporter.commlink.request.RequestHandler;
import com.apple.transporter.commlink.request.action.ActionHandler;
import com.apple.transporter.commlink.request.action.ActionHandlerRegistry;
import java.util.Map;

public class PerformActionRequestHandler
implements RequestHandler {
    @Override
    public TCSResponse perform(TCSRequest request) throws TCSException {
        Object obj = request.getPayloadObject();
        if (!(obj instanceof Map)) {
            throw TCSError.INVALID_CONTENT_OBJECT.makeException("payload object was not a Map");
        }
        Map map = (Map)obj;
        try {
            String command = (String)map.get("command");
            ActionHandler handler = ActionHandlerRegistry.get(command);
            String identifier = request.headers.get("id");
            if (null == identifier) {
                throw TCSError.IDENTIFIER_MISSING.makeException();
            }
            Map arguments = (Map)map.get("arguments");
            TCSResponse response = handler.perform(identifier, arguments);
            response.setHeaderForKey(identifier, "id");
            return response;
        }
        catch (ClassCastException ccx) {
            throw TCSError.INVALID_ACTION_ARGUMENTS.makeException(ccx);
        }
        catch (IllegalArgumentException iax) {
            throw TCSError.INVALID_ACTION_ARGUMENTS.makeException(iax);
        }
    }
}

