/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.payload;

import com.apple.transporter.commlink.payload.TCSFramePayloadEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.json.simple.JSONValue;

public class JSONFramePayloadEncoder
implements TCSFramePayloadEncoder {
    private final Charset UTF8 = Charset.forName("UTF-8");
    private Integer contentLength = null;

    @Override
    public InputStream inputStreamForObject(Object obj) throws IOException {
        if (null == obj) {
            this.contentLength = 0;
            return null;
        }
        String jsonString = JSONValue.toJSONString((Object)obj);
        byte[] jsonBytes = jsonString.getBytes(this.UTF8);
        this.contentLength = jsonBytes.length;
        return new ByteArrayInputStream(jsonBytes);
    }

    @Override
    public void reset() {
        this.contentLength = null;
    }

    @Override
    public int getContentLength() {
        if (null == this.contentLength) {
            throw new IllegalStateException("inputStreamForObject must be called first");
        }
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

