/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.payload;

import com.apple.transporter.commlink.TCSError;
import com.apple.transporter.commlink.TCSException;
import com.apple.transporter.commlink.TCSRequest;
import com.apple.transporter.commlink.payload.TCSFramePayloadDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONFramePayloadDecoder
implements TCSFramePayloadDecoder {
    @Override
    public void decodePayloadForRequest(TCSRequest request) throws TCSException {
        int contentLength = request.getContentLength();
        if (contentLength == 0) {
            return;
        }
        ByteArrayOutputStream baos = request.payloadOutputStream;
        if (null == baos) {
            throw new IllegalArgumentException("content output stream not set on frame");
        }
        int size = baos.size();
        if (size < contentLength) {
            throw new IllegalArgumentException("content output stream not set on frame");
        }
        if (size == 0) {
            return;
        }
        JSONParser parser = new JSONParser();
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        Object payloadObject = null;
        try {
            payloadObject = parser.parse((Reader)reader);
            request.setPayloadObject(payloadObject);
        }
        catch (IOException iox) {
            throw TCSError.IO_ERROR_PROCESSING_CONTENT.makeException(iox);
        }
        catch (ParseException px) {
            throw TCSError.CONTENT_PARSING.makeException(px);
        }
    }

    @Override
    public void reset() {
    }
}

