/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.osgi;

import com.apple.transporter.commlink.api.TransporterConnectionService;
import com.apple.transporter.commlink.impl.TransporterConnectionServiceImpl;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class CommLinkBundleActivator
implements BundleActivator,
ManagedService {
    private BundleContext bundleContext;
    private ServiceRegistration<ManagedService> registration;
    private ServiceRegistration<TransporterConnectionService> connectionServiceRegistration;
    private TransporterConnectionService connectionService;

    public void start(BundleContext bundleContext) throws Exception {
        Collection managedServices = bundleContext.getServiceReferences(ManagedService.class, null);
        if (null != managedServices) {
            for (ServiceReference ref : managedServices) {
                Object pid = ref.getProperty("service.pid");
                if (!"com.apple.transporter.commlink".equals(pid)) continue;
                return;
            }
        }
        this.bundleContext = bundleContext;
        Hashtable<String, String> configuration = new Hashtable<String, String>();
        ((Dictionary)configuration).put("service.pid", "com.apple.transporter.commlink");
        this.registration = bundleContext.registerService(ManagedService.class, (Object)this, configuration);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (null != this.registration) {
            this.registration.unregister();
            this.registration = null;
        }
        if (null != this.connectionServiceRegistration) {
            this.connectionServiceRegistration.unregister();
            this.connectionServiceRegistration = null;
        }
        bundleContext = null;
    }

    public void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
        Integer port;
        this.stopConnectionService();
        if (null != configuration && null != (port = (Integer)configuration.get("port"))) {
            Integer poolSize = (Integer)configuration.get("poolSize");
            String authToken = (String)configuration.get("authToken");
            this.updateConnectionService(port, poolSize, authToken);
        }
    }

    private void updateConnectionService(int port, int poolSize, String authToken) {
        this.connectionService = new TransporterConnectionServiceImpl(poolSize, port, authToken);
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        ((Dictionary)serviceProperties).put("port", port);
        ((Dictionary)serviceProperties).put("poolSize", poolSize);
        ((Dictionary)serviceProperties).put("authToken", authToken);
        this.connectionServiceRegistration = this.bundleContext.registerService(TransporterConnectionService.class, (Object)this.connectionService, serviceProperties);
        this.connectionService.start();
    }

    private void stopConnectionService() {
        if (null != this.connectionService) {
            Future future = this.connectionService.stop();
            this.connectionService = null;
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

