/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.impl;

import com.apple.transporter.commlink.api.TransporterConnectionClient;
import com.apple.transporter.commlink.api.TransporterConnectionService;
import com.apple.transporter.commlink.impl.TransporterAsyncClientConnection;
import com.apple.transporter.commlink.request.action.EchoActionHandler;
import com.apple.transporter.commlink.request.action.NotifyActionHandler;
import com.apple.transporter.commlink.request.action.QuitActionHandler;
import com.apple.transporter.log.LogMessageType;
import com.apple.transporter.log.Logger;
import com.apple.transporter.util.JSONMessageLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TransporterConnectionServiceImpl
implements TransporterConnectionService {
    private final ExecutorService pool;
    private final ConcurrentLinkedQueue<TransporterAsyncClientConnection> clients;
    private final int port;
    private final String authToken;
    private AsynchronousChannelGroup channelGroup;
    private AsynchronousServerSocketChannel server;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private AtomicReference<Future<Void>> shutdownHook = new AtomicReference();

    public TransporterConnectionServiceImpl(int poolsize, int port, String authToken) {
        this.pool = Executors.newFixedThreadPool(poolsize);
        this.clients = new ConcurrentLinkedQueue();
        this.port = port;
        this.authToken = authToken;
        QuitActionHandler.registerWithName("quit", this);
    }

    public void start() {
        if (this.isRunning.get()) {
            throw new IllegalStateException("already running Transporter Connection Service");
        }
        if (this.pool.isShutdown()) {
            throw new IllegalStateException("Transporter Connection Service was shutdown, it is not restartable.");
        }
        this.pool.execute((Runnable)((Object)this));
    }

    public void run() {
        this.isRunning.set(true);
        try {
            this.channelGroup = AsynchronousChannelGroup.withThreadPool(this.pool);
            this.server = AsynchronousServerSocketChannel.open(this.channelGroup);
            if (!this.server.isOpen()) {
                Logger.error((String)"could not open a server socket");
                this.stop();
                return;
            }
            this.server.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)1024);
            this.server.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            InetSocketAddress address = new InetSocketAddress("::1", this.port);
            this.server.bind(address);
            if (this.server.getLocalAddress() instanceof InetSocketAddress) {
                address = (InetSocketAddress)this.server.getLocalAddress();
            }
            HashMap<String, Integer> payload = new HashMap<String, Integer>();
            payload.put("port", new Integer(address.getPort()));
            JSONMessageLogger.extreme((LogMessageType)LogMessageType.CONNECTION_SERVICE_PORT, payload);
            this.startAcceptingConnections();
        }
        catch (IOException iox) {
            Logger.error((String)"Could not open a server conection", (Throwable)iox);
            this.stop();
        }
    }

    private void startAcceptingConnections() {
        final TransporterConnectionServiceImpl delegate = this;
        CompletionHandler<AsynchronousSocketChannel, AsynchronousServerSocketChannel> handler = new CompletionHandler<AsynchronousSocketChannel, AsynchronousServerSocketChannel>(){

            @Override
            public void completed(AsynchronousSocketChannel channel, AsynchronousServerSocketChannel incomingServer) {
                if (!TransporterConnectionServiceImpl.this.isRunning.get()) {
                    try {
                        if (channel.isOpen()) {
                            channel.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                TransporterAsyncClientConnection client = new TransporterAsyncClientConnection(channel, delegate, TransporterConnectionServiceImpl.this.authToken);
                TransporterConnectionServiceImpl.this.clients.add(client);
                client.start();
                incomingServer.accept(incomingServer, this);
            }

            @Override
            public void failed(Throwable exc, AsynchronousServerSocketChannel incomingServer) {
                if (!(exc instanceof AsynchronousCloseException)) {
                    Logger.error((String)exc.getMessage());
                    TransporterConnectionServiceImpl.this.stop();
                }
            }
        };
        this.server.accept(this.server, handler);
    }

    public void clientWllDisconnect(TransporterConnectionClient client) {
        this.clients.remove(client);
        if (!this.isRunning.get() && this.clients.isEmpty() && !this.pool.isShutdown()) {
            this.pool.shutdown();
        }
    }

    public Future<Void> stop() {
        if (null != this.shutdownHook.get()) {
            return this.shutdownHook.get();
        }
        this.isRunning.set(false);
        Future<Void> hook = Executors.newSingleThreadExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() {
                Logger.extreme((String)"Transporter Connection Service is shutting down...");
                while (!TransporterConnectionServiceImpl.this.pool.isShutdown()) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    TransporterConnectionServiceImpl.this.pool.awaitTermination(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Logger.extreme((String)"Transporter Connection Service shutdown complete.");
                return null;
            }
        });
        this.shutdownHook.set(hook);
        try {
            if (this.server.isOpen()) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.clients.isEmpty()) {
            if (!this.pool.isShutdown()) {
                this.pool.shutdown();
            }
        } else {
            for (TransporterConnectionClient transporterConnectionClient : this.clients) {
                transporterConnectionClient.stop();
            }
        }
        return hook;
    }

    static {
        EchoActionHandler.registerWithName("echo");
        NotifyActionHandler.registerWithName("notify");
    }
}

