/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.impl;

import com.apple.transporter.commlink.TCSError;
import com.apple.transporter.commlink.TCSException;
import com.apple.transporter.commlink.TCSProtocolVersion;
import com.apple.transporter.commlink.TCSRequest;
import com.apple.transporter.commlink.TCSResponse;
import com.apple.transporter.commlink.api.TransporterConnectionClient;
import com.apple.transporter.commlink.api.TransporterConnectionService;
import com.apple.transporter.commlink.framing.TCSFrameDecoder;
import com.apple.transporter.commlink.framing.TCSFrameDecoderDelegate;
import com.apple.transporter.commlink.framing.TCSOutboundFrame;
import com.apple.transporter.commlink.payload.JSONFramePayloadDecoder;
import com.apple.transporter.commlink.payload.JSONFramePayloadEncoder;
import com.apple.transporter.commlink.payload.TCSFramePayloadDecoder;
import com.apple.transporter.commlink.payload.TCSFramePayloadEncoder;
import com.apple.transporter.commlink.request.ConnectRequestHandler;
import com.apple.transporter.commlink.request.DisconnectRequestHandler;
import com.apple.transporter.commlink.request.PerformActionRequestHandler;
import com.apple.transporter.commlink.request.RequestHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ShutdownChannelGroupException;
import java.util.HashMap;
import java.util.Map;

public class TransporterAsyncClientConnection
implements TransporterConnectionClient,
TCSFrameDecoderDelegate {
    private final WeakReference<TransporterConnectionService> serverDelegate;
    private final AsynchronousSocketChannel channel;
    private final ByteBuffer readBuffer;
    private CompletionHandler<Integer, Void> readHandler;
    private final TCSFrameDecoder frameDecoder;
    private Map<String, TCSFramePayloadDecoder> payloadDecoders = new HashMap<String, TCSFramePayloadDecoder>();
    private Map<String, TCSFramePayloadEncoder> payloadEncoders = new HashMap<String, TCSFramePayloadEncoder>();
    private RequestHandler connectHandler;
    private RequestHandler disconnectHandler = new DisconnectRequestHandler();
    private RequestHandler performHandler = new PerformActionRequestHandler();
    private ConnectionState connectionState = ConnectionState.STARTING;
    private TCSProtocolVersion version = TCSProtocolVersion.V_1_0;

    public TransporterAsyncClientConnection(AsynchronousSocketChannel channel, TransporterConnectionService serverDelegate, String authToken) {
        this.channel = channel;
        this.serverDelegate = new WeakReference<TransporterConnectionService>(serverDelegate);
        this.readBuffer = ByteBuffer.allocate(1024);
        this.frameDecoder = new TCSFrameDecoder(this);
        this.connectHandler = new ConnectRequestHandler(authToken);
        JSONFramePayloadDecoder payloadDecoder = new JSONFramePayloadDecoder();
        this.payloadDecoders.put("default", payloadDecoder);
        this.payloadDecoders.put("application/json", payloadDecoder);
        JSONFramePayloadEncoder payloadEncoder = new JSONFramePayloadEncoder();
        this.payloadEncoders.put("default", payloadEncoder);
        this.payloadEncoders.put("application/json", payloadEncoder);
    }

    public void start() {
        this.readHandler = new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer ch, Void att) {
                if (ch == -1) {
                    TransporterAsyncClientConnection.this.close();
                } else if (ch > 0) {
                    try {
                        TransporterAsyncClientConnection.this.frameDecoder.decodeBytes(TransporterAsyncClientConnection.this.readBuffer);
                        TransporterAsyncClientConnection.this.channel.read(TransporterAsyncClientConnection.this.readBuffer, null, this);
                    }
                    catch (TCSException fx) {
                        try {
                            TransporterAsyncClientConnection.this.writeErrorForException(fx);
                        }
                        catch (TCSException ex) {
                            ex.printStackTrace();
                            TransporterAsyncClientConnection.this.close();
                        }
                    }
                }
            }

            @Override
            public void failed(Throwable exc, Void att) {
                if (exc instanceof ClosedChannelException) {
                    return;
                }
                if (exc instanceof ShutdownChannelGroupException) {
                    return;
                }
                TransporterAsyncClientConnection.this.close();
            }
        };
        this.channel.read(this.readBuffer, null, this.readHandler);
    }

    public void stop() {
        this.close();
    }

    public void close() {
        TransporterConnectionService server;
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
        if (null != (server = (TransporterConnectionService)this.serverDelegate.get())) {
            server.clientWllDisconnect((TransporterConnectionClient)this);
            this.serverDelegate.clear();
        }
    }

    private TCSFramePayloadDecoder decoderForContentType(String contentType) throws TCSException {
        if (null == contentType) {
            return this.payloadDecoders.get("default");
        }
        TCSFramePayloadDecoder decoder = this.payloadDecoders.get(contentType);
        if (null == decoder) {
            throw TCSError.UNKNOWN_CONTENT_TYPE.makeException("don't know how to process content type: " + contentType);
        }
        return decoder;
    }

    private TCSFramePayloadEncoder encoderForContentType(String contentType) {
        if (null == contentType) {
            return this.payloadEncoders.get("default");
        }
        TCSFramePayloadEncoder encoder = this.payloadEncoders.get(contentType);
        if (null == encoder) {
            throw new IllegalArgumentException("could not find a payload encoder for :" + contentType);
        }
        return encoder;
    }

    @Override
    public void decoderDidReceiveRequest(TCSRequest request) throws TCSException {
        try {
            this.decodeContentForRequest(request);
            this.processRequest(request);
        }
        catch (TCSException ex) {
            ex.identifier = request.getIdentifier();
            throw ex;
        }
    }

    private void decodeContentForRequest(TCSRequest request) throws TCSException {
        if (request.getContentLength() == 0) {
            return;
        }
        TCSFramePayloadDecoder payloadDecoder = this.decoderForContentType(request.getContentType());
        payloadDecoder.decodePayloadForRequest(request);
        payloadDecoder.reset();
    }

    private void processRequest(TCSRequest request) throws TCSException {
        TCSResponse response = null;
        switch (request.requestType) {
            case CONNECT: {
                response = this.connectHandler.perform(request);
                break;
            }
            case DISCONNECT: {
                response = this.disconnectHandler.perform(request);
                break;
            }
            case PERFORM: {
                response = this.performHandler.perform(request);
            }
        }
        TCSFramePayloadEncoder payloadEncoder = this.encoderForContentType(response.contentType);
        try {
            InputStream is = payloadEncoder.inputStreamForObject(response.result);
            TCSOutboundFrame outFrame = new TCSOutboundFrame(response, payloadEncoder.getContentType(), payloadEncoder.getContentLength(), is);
            this.writeFrame(outFrame, response.shouldDisconnect);
        }
        catch (IOException iox) {
            throw TCSError.IO_ERROR_PROCESSING_CONTENT.makeException(iox);
        }
        finally {
            payloadEncoder.reset();
        }
    }

    private void writeErrorForException(TCSException ex) throws TCSException {
        TCSFramePayloadEncoder payloadEncoder = this.encoderForContentType(null);
        try {
            TCSResponse response = TCSResponse.errorResponse(ex);
            InputStream is = payloadEncoder.inputStreamForObject(response.result);
            TCSOutboundFrame outFrame = new TCSOutboundFrame(response, payloadEncoder.getContentType(), payloadEncoder.getContentLength(), is);
            this.writeFrame(outFrame, response.shouldDisconnect);
        }
        catch (IOException iox) {
            throw TCSError.IO_ERROR_PROCESSING_CONTENT.makeException(iox);
        }
        finally {
            payloadEncoder.reset();
        }
    }

    public void writeFrame(final TCSOutboundFrame outboundFrame, final boolean disconnectWhenComplete) {
        ByteBuffer outBuffer = ByteBuffer.allocate(1024);
        try {
            outboundFrame.writeToByteBuffer(outBuffer);
            outBuffer.flip();
        }
        catch (IOException iox) {
            iox.printStackTrace();
            this.close();
            return;
        }
        this.channel.write(outBuffer, outBuffer, new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer ch, ByteBuffer writeBuffer) {
                if (ch == -1) {
                    TransporterAsyncClientConnection.this.close();
                } else if (writeBuffer.hasRemaining()) {
                    TransporterAsyncClientConnection.this.channel.write(writeBuffer, writeBuffer, this);
                } else {
                    try {
                        writeBuffer.flip();
                        int bytesWritten = outboundFrame.writeToByteBuffer(writeBuffer);
                        writeBuffer.flip();
                        if (bytesWritten > 0) {
                            TransporterAsyncClientConnection.this.channel.write(writeBuffer, writeBuffer, this);
                        } else if (disconnectWhenComplete) {
                            TransporterAsyncClientConnection.this.close();
                        }
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                        TransporterAsyncClientConnection.this.close();
                    }
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer writeBuffer) {
                if (!(exc instanceof ClosedChannelException)) {
                    exc.printStackTrace();
                    TransporterAsyncClientConnection.this.close();
                }
            }
        });
    }

    private static enum ConnectionState {
        STARTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED;

    }
}

