/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.framing;

import com.apple.transporter.commlink.TCSResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;

public class TCSOutboundFrame {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte[] endContentBytes;
    private String contentType;
    private int contentLength;
    private ByteBuffer headerBuffer;
    private InputStream inputStream;
    private final ByteBuffer endContentBuffer;
    private Phase phase;
    private ByteBuffer currentBuffer;

    public TCSOutboundFrame(TCSResponse response, String contentType, int contentLength, InputStream inputStream) {
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.inputStream = inputStream;
        this.headerBuffer = this.computeHeaderBuffer(response.headers);
        this.endContentBuffer = ByteBuffer.wrap(endContentBytes);
        this.phase = Phase.RESPONSE;
        this.currentBuffer = ByteBuffer.wrap(response.response.bytes);
    }

    public int writeToByteBuffer(ByteBuffer outBuffer) throws IOException {
        int bytesWritten = 0;
        while (outBuffer.hasRemaining()) {
            if (this.phase == Phase.INPUT_STREAM) {
                bytesWritten += this.writeToByteBufferFromInputStream(outBuffer);
                continue;
            }
            if (this.currentBuffer != null && this.currentBuffer.hasRemaining()) {
                byte b = this.currentBuffer.get();
                outBuffer.put(b);
                ++bytesWritten;
                continue;
            }
            if (this.phase == Phase.RESPONSE) {
                this.phase = Phase.HEADER;
                this.currentBuffer = this.headerBuffer;
                continue;
            }
            if (this.phase == Phase.HEADER) {
                this.phase = Phase.INPUT_STREAM;
                this.currentBuffer = null;
                continue;
            }
            if (this.phase != Phase.END_CONTENT) continue;
            break;
        }
        return bytesWritten;
    }

    private void escapeString(String s, StringBuilder sb) {
        int length = s.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                }
                case ':': {
                    sb.append("\\c");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private ByteBuffer computeHeaderBuffer(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        if (this.contentLength > 0) {
            if (this.contentType != null) {
                sb.append("content-type");
                sb.append(':');
                this.escapeString(this.contentType, sb);
                sb.append("\r\n");
            }
            sb.append("content-length");
            sb.append(':');
            sb.append(this.contentLength);
            sb.append("\r\n");
        }
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            String key = headerEntry.getKey();
            this.escapeString(key, sb);
            sb.append(":");
            String value = headerEntry.getValue();
            if (null == value) {
                throw new IllegalArgumentException("a header value cannot be null for key: " + key);
            }
            this.escapeString(value, sb);
            sb.append("\r\n");
        }
        sb.append("\r\n");
        return ByteBuffer.wrap(sb.toString().getBytes(UTF8));
    }

    private int writeToByteBufferFromInputStream(ByteBuffer outBuffer) throws IOException {
        int bytesWritten = 0;
        if (null == this.inputStream) {
            this.phase = Phase.END_CONTENT;
            this.currentBuffer = this.endContentBuffer;
            return bytesWritten;
        }
        while (outBuffer.hasRemaining()) {
            int b = this.inputStream.read();
            if (b == -1) {
                this.phase = Phase.END_CONTENT;
                this.currentBuffer = this.endContentBuffer;
                this.inputStream.close();
                return bytesWritten;
            }
            outBuffer.put((byte)b);
            ++bytesWritten;
        }
        return bytesWritten;
    }

    static {
        byte[] b = new byte[]{0};
        endContentBytes = b;
    }

    private static enum Phase {
        RESPONSE,
        HEADER,
        INPUT_STREAM,
        END_CONTENT;

    }
}

