/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink.framing;

import com.apple.transporter.commlink.TCSError;
import com.apple.transporter.commlink.TCSException;
import com.apple.transporter.commlink.TCSRequest;
import com.apple.transporter.commlink.TCSRequestType;
import com.apple.transporter.commlink.framing.TCSFrameDecoderDelegate;
import com.apple.transporter.commlink.util.UTF8CharacterDecoder;
import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.Map;

public class TCSFrameDecoder {
    private final UTF8CharacterDecoder characterDecoder;
    private final WeakReference<TCSFrameDecoderDelegate> delegate;
    private Phase phase = Phase.COMMAND;
    private final StringBuilder pendingCommand = new StringBuilder();
    private TCSRequestType command = null;
    private final StringBuilder pendingHeaderKey = new StringBuilder();
    private final StringBuilder pendingHeaderValue = new StringBuilder();
    private StringBuilder currentHeaderBuilder;
    private Map<String, String> headers;
    private ByteArrayOutputStream baos;
    private TCSRequest request;

    public TCSFrameDecoder(TCSFrameDecoderDelegate delegate) {
        this.characterDecoder = new UTF8CharacterDecoder();
        this.delegate = new WeakReference<TCSFrameDecoderDelegate>(delegate);
        this.reset();
    }

    private void reset() {
        this.phase = Phase.COMMAND;
        this.pendingCommand.delete(0, Integer.MAX_VALUE);
        this.pendingHeaderKey.delete(0, Integer.MAX_VALUE);
        this.pendingHeaderValue.delete(0, Integer.MAX_VALUE);
        this.currentHeaderBuilder = this.pendingHeaderKey;
        this.headers = new HashMap<String, String>();
        this.headers.put("content-type", "application/json");
        this.headers.put("content-length", "0");
        this.baos = null;
        this.request = null;
    }

    public void decodeBytes(ByteBuffer readBuffer) throws TCSException {
        readBuffer.flip();
        try {
            while (readBuffer.hasRemaining()) {
                switch (this.phase) {
                    case COMMAND: {
                        this.handleCommandRead(readBuffer);
                        break;
                    }
                    case HEADER: {
                        this.handleHeaderRead(readBuffer);
                        break;
                    }
                    case EOL: {
                        this.handleEOLRead(readBuffer);
                        break;
                    }
                    case PAYLOAD: {
                        this.handlePayloadRead(readBuffer);
                    }
                }
                if (null == this.request) continue;
                TCSRequest savedFrame = this.request;
                this.reset();
                TCSFrameDecoderDelegate del = (TCSFrameDecoderDelegate)this.delegate.get();
                if (null == del) continue;
                del.decoderDidReceiveRequest(savedFrame);
            }
        }
        catch (BufferUnderflowException savedFrame) {
        }
        catch (CharacterCodingException ccx) {
            throw TCSError.UTF8_CHARACTER_CODING.makeException();
        }
        finally {
            if (readBuffer.hasRemaining()) {
                readBuffer.flip();
            } else {
                readBuffer.compact();
            }
        }
    }

    private void handleCommandRead(ByteBuffer readBuffer) throws CharacterCodingException, TCSException {
        while (true) {
            CharBuffer charBuffer;
            if (null == (charBuffer = this.characterDecoder.decode(readBuffer))) {
                return;
            }
            char c = charBuffer.get();
            if (c == '\n') {
                if (this.pendingCommand.length() <= 0) continue;
                String attemptedCommand = this.pendingCommand.toString();
                try {
                    this.command = TCSRequestType.valueOf(attemptedCommand);
                    break;
                }
                catch (IllegalArgumentException iax) {
                    throw TCSError.INVALID_COMMAND.makeException(iax);
                }
            }
            if (c == '\r') continue;
            this.pendingCommand.append(c);
        }
        this.phase = Phase.HEADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHeaderRead(ByteBuffer readBuffer) throws CharacterCodingException, TCSException {
        boolean escaping = false;
        while (true) {
            CharBuffer charBuffer;
            if (null == (charBuffer = this.characterDecoder.decode(readBuffer))) {
                return;
            }
            char c = charBuffer.get();
            if (c == '\n') {
                try {
                    String key = this.pendingHeaderKey.toString();
                    if (key.length() > 0) {
                        String value = this.pendingHeaderValue.toString();
                        if (value.length() > 0) {
                            this.headers.put(key, value);
                            continue;
                        }
                        throw TCSError.INVALID_HEADER_VALUE.makeException("no value specified for key: " + key);
                    }
                    if (this.currentHeaderBuilder.length() != 0) continue;
                    this.phase = Phase.PAYLOAD;
                    break;
                }
                finally {
                    this.currentHeaderBuilder = this.pendingHeaderKey;
                    this.pendingHeaderKey.delete(0, Integer.MAX_VALUE);
                    this.pendingHeaderValue.delete(0, Integer.MAX_VALUE);
                    continue;
                }
            }
            if (c == ':') {
                if (this.currentHeaderBuilder == this.pendingHeaderValue) {
                    throw TCSError.INVALID_HEADER_VALUE.makeException("cannot have an unescaped colon within a header value");
                }
                this.currentHeaderBuilder = this.pendingHeaderValue;
                continue;
            }
            if (c == '\r') continue;
            if (escaping) {
                char result = '\u0000';
                switch (c) {
                    case 'r': {
                        result = '\r';
                        break;
                    }
                    case 'n': {
                        result = '\n';
                        break;
                    }
                    case 'c': {
                        result = ':';
                        break;
                    }
                    case '\\': {
                        result = '\\';
                        break;
                    }
                    default: {
                        throw TCSError.INVALID_ESCAPE_SEQUENCE.makeException("\\" + String.valueOf(c) + "is not valid");
                    }
                }
                this.currentHeaderBuilder.append(result);
                escaping = false;
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            this.currentHeaderBuilder.append(c);
        }
    }

    private void handleEOLRead(ByteBuffer readBuffer) {
        if (readBuffer.remaining() > 1) {
            byte cr = readBuffer.get();
            byte nl = readBuffer.get();
            if (cr == 13 && nl == 10) {
                this.phase = Phase.PAYLOAD;
            }
        }
    }

    private void handlePayloadRead(ByteBuffer readBuffer) throws TCSException {
        byte b;
        int contentLength = 0;
        try {
            contentLength = Integer.valueOf(this.headers.get("content-length"));
        }
        catch (NumberFormatException nfe) {
            throw TCSError.INVALID_CONTENT_LENGTH.makeException(nfe);
        }
        if (contentLength < 0) {
            throw TCSError.INVALID_CONTENT_LENGTH.makeException("received a negative content length: " + contentLength);
        }
        if (contentLength == 0) {
            if (!readBuffer.hasRemaining()) {
                return;
            }
            byte b2 = readBuffer.get();
            if (b2 == 0) {
                this.phase = Phase.COMMAND;
                this.request = new TCSRequest(this.command, this.headers, null);
                return;
            }
            throw TCSError.END_OF_FRAME_NOT_FOUND.makeException();
        }
        if (null == this.baos) {
            this.baos = new ByteArrayOutputStream(contentLength);
        }
        while (readBuffer.hasRemaining() && ((b = readBuffer.get()) != 0 || this.baos.size() != contentLength)) {
            this.baos.write(b);
            if (this.baos.size() != contentLength) continue;
            byte endOfFrame = readBuffer.get();
            if (endOfFrame == 0) break;
            throw TCSError.END_OF_FRAME_NOT_FOUND.makeException();
        }
        if (this.baos.size() < contentLength) {
            return;
        }
        this.phase = Phase.COMMAND;
        this.request = new TCSRequest(this.command, this.headers, this.baos);
    }

    private static enum Phase {
        COMMAND,
        HEADER,
        EOL,
        PAYLOAD;

    }
}

