/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink;

import com.apple.transporter.commlink.TCSException;
import com.apple.transporter.commlink.TCSResponseType;
import java.util.HashMap;
import java.util.Map;

public class TCSResponse {
    public final TCSResponseType response;
    public final Object result;
    public final String contentType;
    public final boolean shouldDisconnect;
    public final Map<String, String> headers;

    public TCSResponse(TCSResponseType response, Object result, String contentType, boolean shouldDisconnect) {
        this.response = response;
        this.result = result;
        this.contentType = contentType;
        this.shouldDisconnect = shouldDisconnect;
        this.headers = new HashMap<String, String>();
        if (shouldDisconnect) {
            this.setHeaderForKey("close", "connection");
        }
    }

    public TCSResponse(TCSResponseType response, Object result, String contentType) {
        this(response, result, contentType, false);
    }

    public TCSResponse(TCSResponseType response, Object result) {
        this(response, result, null, false);
    }

    public TCSResponse(TCSResponseType response) {
        this(response, null, null, false);
    }

    public void setHeaderForKey(String value, String key) {
        this.headers.put(key, value);
    }

    public static TCSResponse okResponse() {
        return new TCSResponse(TCSResponseType.OK);
    }

    public static TCSResponse okCloseResponse() {
        return new TCSResponse(TCSResponseType.OK, null, null, true);
    }

    public static TCSResponse okResponse(Object obj, String contentType) {
        return new TCSResponse(TCSResponseType.OK, obj, contentType);
    }

    public static TCSResponse okResponse(Object obj) {
        return new TCSResponse(TCSResponseType.OK, obj);
    }

    public static TCSResponse errorResponse(TCSException exception) {
        TCSResponse response = new TCSResponse(TCSResponseType.ERROR, exception.toMap(), null, true);
        String identifier = exception.identifier;
        if (null != identifier) {
            response.setHeaderForKey(identifier, "id");
        }
        return response;
    }
}

