/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink;

import com.apple.transporter.commlink.TCSRequestType;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public class TCSRequest {
    public final TCSRequestType requestType;
    public final Map<String, String> headers;
    public final ByteArrayOutputStream payloadOutputStream;
    private Object payloadObject;

    public TCSRequest(TCSRequestType request, Map<String, String> headers, ByteArrayOutputStream payloadOutputStream) {
        this.requestType = request;
        this.headers = headers;
        this.payloadOutputStream = payloadOutputStream;
        this.payloadObject = null;
    }

    public int getContentLength() {
        String cl = this.headers.get("content-length");
        int l = 0;
        try {
            l = Integer.parseInt(cl);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public String getContentType() {
        return this.headers.get("content-type");
    }

    public String getIdentifier() {
        return this.headers.get("id");
    }

    public Object getPayloadObject() {
        return this.payloadObject;
    }

    public void setPayloadObject(Object payloadObject) {
        this.payloadObject = payloadObject;
    }
}

