/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.commlink;

import com.apple.transporter.commlink.TCSError;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class TCSException
extends Exception {
    private static final long serialVersionUID = 3105877809848193762L;
    public final TCSError errorType;
    public String identifier = null;

    TCSException(TCSError errorType, String message, Throwable cause) {
        super(message, cause);
        this.errorType = errorType;
    }

    TCSException(TCSError errorType, String message) {
        this(errorType, message, null);
    }

    TCSException(TCSError errorType, Throwable cause) {
        this(errorType, null, cause);
    }

    TCSException(TCSError errorType) {
        this(errorType, null, null);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        errorMap.put("code", this.errorType.ordinal());
        errorMap.put("domain", "iTMSTransporterConnectionDomain");
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        errorMap.put("userInfo", userInfo);
        userInfo.put("name", this.errorType.name());
        String message = this.getMessage();
        if (null != message) {
            userInfo.put("message", message);
        } else if (this.errorType.message != null) {
            userInfo.put("message", message);
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.printStackTrace(writer);
        writer.flush();
        userInfo.put("stackTrace", sw.toString());
        Throwable cause = this.getCause();
        if (cause != null) {
            HashMap<String, String> causeMap = new HashMap<String, String>();
            userInfo.put("cause", causeMap);
            causeMap.put("exceptionClass", cause.getClass().getName());
            causeMap.put("message", cause.getMessage());
        }
        return errorMap;
    }
}

