/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.epubcheck;

import com.apple.its.epubcheck.Report;
import com.apple.its.epubcheck.Severity;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class EpubCheckRunner {
    private static final String EPUBCHECK_MAIN_CLASS = "com.adobe.epubcheck.tool.Checker";
    private static final String EPUBCHECK_JAR = "epubcheck4itunes-4.0.2.jar";
    private static final String OFFLINE_MODE = "-Depubcheck.offline=true";
    private static final String OSGI_URI_PREFIX = "reference:file:";
    private static final String JAVA_EXECUTABLE = System.getProperty("os.name").toLowerCase().contains("windows") ? "javaw.exe" : "java";
    private static String extractedTempFolder = null;
    private final Report report;
    private final File epubFile;
    private final InputStream epubInputStream;
    private final String streamName;

    public EpubCheckRunner(@Nonnull File file, @Nonnull Report report) {
        this.report = report;
        this.epubFile = file;
        this.epubInputStream = null;
        this.streamName = file.getName();
    }

    public EpubCheckRunner(@Nonnull InputStream input, @Nonnull Report report, @Nonnull String uri) {
        this.report = report;
        this.epubFile = null;
        this.epubInputStream = input;
        this.streamName = uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate() {
        Path jsonPath;
        boolean issuesFound;
        block47: {
            boolean createdTempFile = false;
            issuesFound = false;
            Path epubPath = null;
            jsonPath = null;
            try {
                if (this.epubFile != null) {
                    if (EpubCheckRunner.hasEpubFileExtension(this.streamName)) {
                        epubPath = this.epubFile.toPath();
                    } else {
                        try {
                            epubPath = Files.createTempFile("", this.streamName + ".epub", new FileAttribute[0]);
                            createdTempFile = true;
                            Files.copy(this.epubFile.toPath(), epubPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Cannot create temp file", e);
                        }
                    }
                } else {
                    if (this.epubInputStream == null) throw new IllegalStateException("Both epubFile and epubInputStream are null");
                    try {
                        epubPath = Files.createTempFile("", EpubCheckRunner.hasEpubFileExtension(this.streamName) ? this.streamName : this.streamName + ".epub", new FileAttribute[0]);
                        createdTempFile = true;
                        Files.copy(this.epubInputStream, epubPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot create temp file", e);
                    }
                }
                Path classPath = new File(EpubCheckRunner.extractEpubCheck()).toPath().resolve(EPUBCHECK_JAR);
                File java = new File(System.getProperty("java.home")).toPath().resolve("bin").resolve(JAVA_EXECUTABLE).toFile();
                if (!java.exists()) {
                    throw new RuntimeException("Java executable does not exist @ " + java.getAbsolutePath());
                }
                jsonPath = Files.createTempFile(this.streamName, "output", new FileAttribute[0]);
                ProcessBuilder pb = EpubCheckRunner.getSelfClassPath().getFileName().endsWith(".jar") ? new ProcessBuilder(java.getAbsolutePath(), OFFLINE_MODE, "-jar", classPath.toString(), "-json", jsonPath.toAbsolutePath().toString(), epubPath.toAbsolutePath().toString()) : new ProcessBuilder(java.getAbsolutePath(), OFFLINE_MODE, "-classpath", classPath.toString(), EPUBCHECK_MAIN_CLASS, "-json", jsonPath.toAbsolutePath().toString(), epubPath.toAbsolutePath().toString());
                pb.redirectErrorStream(true);
                Process process = pb.start();
                int returnCode = process.waitFor();
                if (returnCode != 0) {
                    try (JsonReader jsonReader = Json.createReader((InputStream)new BufferedInputStream(new FileInputStream(jsonPath.toFile())));){
                        JsonObject jsonData = jsonReader.readObject();
                        JsonArray jsonMessages = jsonData.getJsonArray("messages");
                        if (jsonMessages != null) {
                            Pattern fileNameRegex = Pattern.compile(epubPath.getFileName().toString(), 16);
                            String fileNameReplacement = Matcher.quoteReplacement(this.streamName);
                            for (JsonValue jsonMessageValue : jsonMessages) {
                                assert (jsonMessageValue.getValueType() == JsonValue.ValueType.OBJECT) : "Json message must be an object";
                                JsonObject jsonMessage = (JsonObject)jsonMessageValue;
                                String code = jsonMessage.getString("ID");
                                Severity severity = Severity.valueOf(jsonMessage.getString("severity"));
                                if (!issuesFound) {
                                    switch (severity) {
                                        case WARNING: 
                                        case ERROR: 
                                        case FATAL: {
                                            issuesFound = true;
                                            break;
                                        }
                                    }
                                }
                                String message = jsonMessage.getString("message");
                                JsonArray jsonLocations = jsonMessage.getJsonArray("locations");
                                if (jsonLocations == null) continue;
                                for (JsonValue jsonLocationValue : jsonLocations) {
                                    assert (jsonLocationValue.getValueType() == JsonValue.ValueType.OBJECT) : "Json location must be an object";
                                    JsonObject jsonLocation = (JsonObject)jsonLocationValue;
                                    String fileName = fileNameRegex.matcher(jsonLocation.getString("path")).replaceAll(fileNameReplacement);
                                    int lineNum = jsonLocation.getInt("line", -1);
                                    int columnNum = jsonLocation.getInt("column", -1);
                                    String context = jsonLocation.getString("context", null);
                                    this.report.message(severity, code, message, fileName, lineNum, columnNum, context);
                                }
                            }
                        }
                    }
                }
                if (!createdTempFile) break block47;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Cannot run epubcheck-runner external process", e);
                }
                catch (Throwable throwable) {
                    if (createdTempFile) {
                        try {
                            Files.delete(epubPath);
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    if (jsonPath == null) throw throwable;
                    try {
                        Files.delete(jsonPath);
                        throw throwable;
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                Files.delete(epubPath);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (jsonPath != null) {
            try {
                Files.delete(jsonPath);
            }
            catch (IOException e) {}
        }
        if (issuesFound) return false;
        return true;
    }

    static boolean hasEpubFileExtension(@Nonnull String fileName) {
        return fileName.toLowerCase().endsWith(".epub");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private static String extractEpubCheck() throws Exception {
        if (extractedTempFolder != null) return extractedTempFolder;
        Class<EpubCheckRunner> clazz = EpubCheckRunner.class;
        synchronized (EpubCheckRunner.class) {
            if (extractedTempFolder != null) return extractedTempFolder;
            Path srcPath = EpubCheckRunner.getSelfClassPath();
            Path fileNamePath = srcPath.getFileName();
            if (fileNamePath.toString().endsWith(".jar")) {
                Path dstPath = Files.createTempDirectory(fileNamePath.toString(), new FileAttribute[0]);
                dstPath.toFile().deleteOnExit();
                try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(srcPath.toFile())));){
                    byte[] buf = new byte[4096];
                    ZipEntry entry = in.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory() && entry.getName().endsWith(".jar")) {
                            try (ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);){
                                int len;
                                while ((len = in.read(buf, 0, buf.length)) > 0) {
                                    bos.write(buf, 0, len);
                                }
                                Path dst = dstPath.resolve(entry.getName());
                                Path dstParent = dst.getParent();
                                if (!dstParent.toFile().exists()) {
                                    Files.createDirectories(dstParent, new FileAttribute[0]);
                                    dstParent.toFile().deleteOnExit();
                                }
                                Files.copy(new ByteArrayInputStream(bos.toByteArray()), dst, new CopyOption[0]);
                                dst.toFile().deleteOnExit();
                            }
                        }
                        entry = in.getNextEntry();
                    }
                }
                extractedTempFolder = dstPath.toString();
            } else {
                extractedTempFolder = srcPath.toString();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return extractedTempFolder;
        }
    }

    @Nonnull
    private static Path getSelfClassPath() throws URISyntaxException {
        File file;
        URL location = EpubCheckRunner.class.getProtectionDomain().getCodeSource().getLocation();
        String locationStr = location.toString();
        if (locationStr.startsWith(OSGI_URI_PREFIX)) {
            file = new File(locationStr.substring(OSGI_URI_PREFIX.length()));
        } else {
            URI uri = new URI(location.getProtocol(), location.getAuthority(), location.getPath(), location.getQuery(), null);
            file = new File(uri);
        }
        return file.toPath().toAbsolutePath();
    }
}

