/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.softwaresupport;

import com.apple.jingle.leghorn.fileformat.DescriptionWrapper;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.software.SoftwareSupportService;
import com.apple.jingle.leghorn.software.ToolInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.softwaresupport.DescriptionProcessTimedOutException;
import com.apple.transporter.stats.api.StatisticCollector;
import com.apple.transporter.streaming.StreamableDescriptionWrapper;
import com.apple.transporter.streaming.StreamableFile;
import com.apple.transporter.streaming.StreamingParameters;
import com.apple.transporter.streaming.api.StreamableContent;
import com.apple.transporter.streaming.api.StreamableContentKey;
import com.apple.transporter.util.ProcUtil;
import com.webobjects.foundation.NSPropertyListSerialization;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SoftwareSupportToolInvoker
implements ToolInvoker {
    private static final String SWINFO_ENCODING_OPTION = "--encoding";
    private static final String SWINFO_GZIP_ENCODING_VALUE = "gzip";
    private static final String SWINFO_OUTPUT_SUMMARY_INFO_OPTION = "--outputSummaryInfo";
    private final SoftwareSupportService.Tool tool;
    private final String toolPath;
    private final StatisticCollector statisticCollector;
    private String softwareFilePath;

    SoftwareSupportToolInvoker(SoftwareSupportService.Tool tool, String toolPath, StatisticCollector statisticCollector) {
        this.tool = tool;
        this.toolPath = toolPath;
        this.statisticCollector = statisticCollector;
    }

    public DescriptionWrapper invoke() throws Exception {
        switch (this.tool) {
            case SWINFO: {
                return this.invokeSwinfo();
            }
            case ProductUtil: {
                return this.invokeProductUtil();
            }
        }
        throw new IllegalArgumentException("Unsupported description tool: " + this.tool);
    }

    private DescriptionWrapper invokeWithArgs(long maxFileSize, final String ... args) throws DescriptionException {
        String[] headers;
        boolean isVersion = false;
        if (null != this.statisticCollector) {
            if (null != args) {
                for (int i = 0; i < args.length; ++i) {
                    if (!"-v".equals(args[i])) continue;
                    isVersion = true;
                    break;
                }
            }
            if (!isVersion) {
                this.statisticCollector.startOperationReturningPreviousStatistic(this.tool.name());
            }
        }
        String response = (String)ProcUtil.executeWithTimeout((ProcUtil.Executable)new ProcUtil.Executable<String>(){

            public String execute() {
                Process proc = null;
                try {
                    ProcessBuilder pb = new ProcessBuilder(args);
                    proc = pb.start();
                    InputStream stdout = proc.getInputStream();
                    InputStream stderr = proc.getErrorStream();
                    StreamConsumer out = new StreamConsumer(stdout);
                    StreamConsumer err = new StreamConsumer(stderr);
                    Thread outthread = new Thread(out);
                    Thread errthread = new Thread(err);
                    outthread.setDaemon(true);
                    errthread.setDaemon(true);
                    outthread.start();
                    errthread.start();
                    outthread.join();
                    String string = out.getContent();
                    return string;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("UTF-8 encoding is unsupported", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An error occurred executing: " + SoftwareSupportToolInvoker.this.toolPath, e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("An error occurred executing: " + SoftwareSupportToolInvoker.this.toolPath, e);
                }
                finally {
                    if (proc != null) {
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }, (long)this.executeTimeout());
        if (null != this.statisticCollector && !isVersion) {
            this.statisticCollector.stopCurrent();
        }
        if (response == null) {
            throw new DescriptionProcessTimedOutException("ERROR: Timed Out invoking command line tool: " + args[0]);
        }
        boolean shouldParseFileInfo = false;
        for (String arg : args) {
            if (!arg.equals(SWINFO_OUTPUT_SUMMARY_INFO_OPTION)) continue;
            shouldParseFileInfo = true;
            break;
        }
        if (!shouldParseFileInfo) {
            return new SwDescriptionWrapper(response);
        }
        StreamableFile streamableContent = new StreamableFile();
        streamableContent.setMaximumFileSize(maxFileSize);
        block15: for (String header : headers = response.split("\r\n")) {
            StreamableContentKey key;
            int index = header.indexOf(58);
            if (index <= 0 || null == (key = StreamableContentKey.toKey((String)header.substring(0, index).trim()))) continue;
            String value = header.substring(index + 1).trim();
            switch (key) {
                case CHECKSUM_ALGORITHM: {
                    streamableContent.setChecksumAlgorithm(value);
                    continue block15;
                }
                case CHECKSUM_MD5: {
                    streamableContent.setChecksumAlgorithm("MD5");
                    streamableContent.setChecksumValue(value);
                    continue block15;
                }
                case CHECKSUM_VALUE: {
                    streamableContent.setChecksumValue(value);
                    continue block15;
                }
                case CONTENT_ENCODING: {
                    streamableContent.setContentEncoding(value);
                    continue block15;
                }
                case CONTENT_LENGTH: {
                    continue block15;
                }
                case CONTENT_TRANSFER_ENCODING: {
                    streamableContent.setContentTransferEncoding(value);
                    continue block15;
                }
                case CONTENT_TYPE: {
                    streamableContent.setContentType(value);
                    continue block15;
                }
                case FILE_NAME: {
                    continue block15;
                }
                case FILE_PATH: {
                    streamableContent.setFile(new File(value));
                    continue block15;
                }
                case TIMING_INFO_FILE: {
                    this.processTimingFile(value);
                    continue block15;
                }
                case UNCOMPRESSED_CONTENT_LENGTH: {
                    Long v = Long.parseLong(value);
                    streamableContent.setUncompressedContentLength(v.longValue());
                }
            }
        }
        SwDescriptionWrapper wrapper = new SwDescriptionWrapper((StreamableContent)streamableContent);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimingFile(String timingInfoFileName) {
        if (null == timingInfoFileName) {
            return;
        }
        if (null == this.statisticCollector) {
            return;
        }
        try {
            File timingFile = new File(timingInfoFileName);
            try (FileInputStream is = new FileInputStream(timingFile);){
                Map timingInfo;
                List toolTimings;
                Object obj = NSPropertyListSerialization.propertyListFromStream((InputStream)is, (NSPropertyListSerialization.PListFormat)NSPropertyListSerialization.PListFormat.NSPropertyListBinaryFormat_v1_0, (String)"UTF-8");
                if (obj instanceof Map && null != (toolTimings = (List)(timingInfo = (Map)obj).get("tool-timings"))) {
                    toolTimings.forEach(map -> {
                        String name = (String)map.get("tool-name");
                        if (!name.startsWith(this.tool.name())) {
                            name = this.tool.name() + "." + name;
                        }
                        Double time = (Double)map.get("time");
                        Number count = (Number)map.get("count");
                        if (null == count) {
                            count = 1;
                        }
                        this.statisticCollector.addExternalTiming(name, time.doubleValue(), count.intValue());
                    });
                }
            }
            finally {
                if (!timingFile.delete()) {
                    timingFile.deleteOnExit();
                }
            }
        }
        catch (Exception ex) {
            Logger.error((String)"Could not process timing file.", (Throwable)ex);
        }
    }

    private DescriptionWrapper invokeSwinfo() throws DescriptionException {
        boolean useOutputFile = false;
        DescriptionWrapper versionWrapper = this.invokeWithArgs(Long.MAX_VALUE, this.toolPath, "-v");
        String versionXML = versionWrapper.serializeToString();
        Pattern pattern = Pattern.compile("<key>tool-version<\\/key>\\s*?<string>(.*?)<\\/string>");
        Matcher matcher = pattern.matcher(versionXML);
        if (matcher.find()) {
            String data = matcher.group(1);
            String[] split = data.split("\\.");
            int major = Integer.parseInt(split[0]);
            int minor = Integer.parseInt(split[1]);
            useOutputFile = major != 1 || minor >= 12;
        }
        Long maxFileSize = Long.MAX_VALUE;
        Map sizeThresholds = StreamingParameters.getSoftwareSizeThresholds();
        block2: for (Map.Entry e : sizeThresholds.entrySet()) {
            Map val = (Map)e.getValue();
            Object obj = val.get("extensions");
            if (!(obj instanceof Object[])) continue;
            for (Object ext : (Object[])obj) {
                if (!this.softwareFilePath.endsWith((String)ext)) continue;
                maxFileSize = ((Number)val.get("size")).longValue();
                break block2;
            }
        }
        try {
            boolean multipartUploadsEnabled = StreamingParameters.getMultipartUploadsEnabled();
            if (multipartUploadsEnabled && useOutputFile) {
                String plistFormat = StreamingParameters.getSwinfoPlistFormat();
                File tmpFile = File.createTempFile(UUID.randomUUID().toString(), ".swinfo.plist.gz");
                return this.invokeWithArgs(maxFileSize, this.toolPath, "-f", this.softwareFilePath, SWINFO_ENCODING_OPTION, SWINFO_GZIP_ENCODING_VALUE, "-o", tmpFile.getAbsolutePath(), "--plistFormat", plistFormat, SWINFO_OUTPUT_SUMMARY_INFO_OPTION);
            }
            return this.invokeWithArgs(Long.MAX_VALUE, this.toolPath, "-f", this.softwareFilePath);
        }
        catch (IOException iox) {
            throw new DescriptionException((Throwable)iox);
        }
    }

    private DescriptionWrapper invokeProductUtil() throws IOException, DescriptionException {
        File expandDirectory = this.createExpandDirectory();
        try {
            DescriptionWrapper descriptionWrapper = this.invokeWithArgs(Long.MAX_VALUE, this.toolPath, "--skip-attr-checks", "--package", this.softwareFilePath, "--expand", expandDirectory.getAbsolutePath(), "--extract-metadata", "--check-signature");
            return descriptionWrapper;
        }
        finally {
            FileUtils.deleteQuietly((File)expandDirectory);
        }
    }

    private File createExpandDirectory() throws IOException {
        File result = File.createTempFile("expand", "productutil", null);
        if (!result.delete()) {
            result.deleteOnExit();
        }
        result = new File(result.getParentFile(), result.getName() + "." + System.currentTimeMillis());
        return result;
    }

    public ToolInvoker addTargetFilePath(String softwareFilePath) {
        this.softwareFilePath = softwareFilePath;
        return this;
    }

    private long executeTimeout() {
        return Long.getLong("SoftwareSupportToolInvoker.executeTimeout", 600L) * 1000L;
    }

    private int readBufferSize() {
        return Integer.getInteger("SoftwareSupportToolInvoker.readBufferSize", 0x100000);
    }

    private static class SwDescriptionWrapper
    implements StreamableDescriptionWrapper {
        private final String description;
        private StreamableContent streamableContent;

        private SwDescriptionWrapper(String description) {
            this.description = description;
        }

        private SwDescriptionWrapper(StreamableContent streamableContent) {
            this.description = "";
            this.streamableContent = streamableContent;
        }

        public <T> T payload() {
            return (T)this.description;
        }

        public String serializeToString() {
            return this.description;
        }

        public StreamableContent getStreamableContent() {
            return this.streamableContent;
        }
    }

    private class StreamConsumer
    implements Runnable {
        private final InputStream in;
        private String streamContent;

        public StreamConsumer(InputStream in) {
            this.in = in;
        }

        public String getContent() {
            return this.streamContent;
        }

        @Override
        public void run() {
            try {
                int uncompressedCount = 0;
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);
                byte[] buf = new byte[SoftwareSupportToolInvoker.this.readBufferSize()];
                int i = this.in.read(buf);
                while (i != -1) {
                    gzipStream.write(buf, 0, i);
                    uncompressedCount += i;
                    i = this.in.read(buf);
                }
                gzipStream.flush();
                gzipStream.close();
                byteStream.flush();
                ByteArrayInputStream byteInput = new ByteArrayInputStream(byteStream.toByteArray());
                GZIPInputStream gzipIn = new GZIPInputStream(byteInput);
                ByteArrayOutputStream stringBytes = new ByteArrayOutputStream(uncompressedCount);
                IOUtils.copy((InputStream)gzipIn, (OutputStream)stringBytes);
                this.streamContent = stringBytes.toString("utf-8");
            }
            catch (IOException e) {
                Logger.error((String)("An error occurred executing: " + SoftwareSupportToolInvoker.this.toolPath), (Throwable)e);
            }
        }
    }
}

