/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.softwaresupport;

import com.apple.jingle.leghorn.fileformat.DescriptionWrapper;
import com.apple.jingle.leghorn.software.SoftwareSupportService;
import com.apple.jingle.leghorn.software.ToolInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.softwaresupport.SoftwareSupportToolInvoker;
import com.apple.transporter.stats.api.StatisticCollector;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.StringUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class SoftwareSupportServiceImpl
implements SoftwareSupportService,
ServiceFactory {
    private static StatisticCollector statisticCollector;
    private boolean hasSetup = false;
    private Properties props;

    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        return new SoftwareSupportServiceImpl();
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object o) {
    }

    private void setup() {
        if (!this.hasSetup) {
            this.hasSetup = true;
            try (InputStream propsStream = this.getClass().getClassLoader().getResourceAsStream("softwaresupport.properties");){
                String[] symlinks;
                String[] executables;
                this.props = new Properties();
                this.props.load(propsStream);
                propsStream.close();
                String binDirPath = this.getBinPath();
                File binDir = new File(binDirPath);
                binDir.mkdirs();
                if (!binDir.exists()) {
                    Logger.error((String)("Could not create path for software support: " + binDirPath));
                }
                String binPrefix = this.props.getProperty("bin.prefix");
                for (Object obj : this.props.keySet()) {
                    String[] key = (String[])obj;
                    if (!key.startsWith("MD5.")) continue;
                    String fileName = key.substring(4);
                    String fileResourcePath = binPrefix + "/" + fileName;
                    File targetFile = new File(binDir, fileName);
                    String fileChecksum = this.props.getProperty((String)key);
                    this.validateFileOnFileSystem(fileResourcePath, targetFile, fileChecksum);
                }
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
                for (String binFileName : executables = this.props.getProperty("bin.executables").split(",")) {
                    File binFile = new File(binDir, binFileName);
                    Files.setPosixFilePermissions(binFile.toPath(), perms);
                }
                HashSet<Pair> unprocessed = new HashSet<Pair>();
                for (String symlinkPair : symlinks = this.props.getProperty("bin.symlinks").split(",")) {
                    String[] symlinkParts = symlinkPair.split("=");
                    File symlink = new File(binDir, symlinkParts[1]);
                    File sourcePath = new File(binDir, symlinkParts[0]);
                    Pair pair = Pair.of((Object)symlink.toPath(), (Object)sourcePath.toPath());
                    unprocessed.add(pair);
                }
                int noneProcessedCounter = 0;
                HashSet<Pair> processed = new HashSet<Pair>();
                while (!unprocessed.isEmpty()) {
                    for (Pair pair : unprocessed) {
                        try {
                            this.validateSymlinkOnFileSystem((Path)pair.getLeft(), (Path)pair.getRight());
                            processed.add(pair);
                        }
                        catch (IOException iox) {
                            Logger.warn((String)iox.getMessage());
                        }
                    }
                    if (processed.size() == 0 && ++noneProcessedCounter > 3) {
                        for (Pair pair : unprocessed) {
                            Logger.error((String)("Unable to create a symbolic link: " + ((Path)pair.getLeft()).toString() + " -> " + ((Path)pair.getRight()).toString()));
                        }
                        throw new IOException("Could not create symbolic links.");
                    }
                    unprocessed.removeAll(processed);
                    processed.clear();
                }
            }
            catch (IOException e) {
                Logger.error((String)"Could not configure software support.", (Throwable)e);
            }
        }
    }

    private Path validateSymlinkOnFileSystem(Path symlink, Path sourcePath) throws IOException {
        File symlinkFile;
        if (Files.isSymbolicLink(symlink)) {
            Files.deleteIfExists(symlink);
        } else if (Files.exists(symlink, LinkOption.NOFOLLOW_LINKS) && !(symlinkFile = symlink.toFile()).delete() && !FileUtil.recursivelyDelete((File)symlinkFile)) {
            Logger.extreme((String)("unable to repair symlink:[" + symlink + "]"));
            symlinkFile.deleteOnExit();
            return null;
        }
        return Files.createSymbolicLink(symlink, sourcePath, new FileAttribute[0]);
    }

    private void validateFileOnFileSystem(String sourceFileResourcePath, File destinationFile, String expectedMD5) throws IOException {
        block30: {
            try {
                String actualMD5;
                if (destinationFile.exists() && !expectedMD5.equalsIgnoreCase(actualMD5 = FileUtil.md5Hex((File)destinationFile)) && !destinationFile.delete()) {
                    Logger.error((String)("Could not remove existing file: " + destinationFile));
                }
                if (destinationFile.exists()) break block30;
                if (!destinationFile.getParentFile().exists() && !destinationFile.getParentFile().mkdirs()) {
                    Logger.error((String)("Could not make parent directory for: " + destinationFile));
                }
                try (FileOutputStream fileStream = new FileOutputStream(destinationFile);
                     DigestOutputStream destFileStream = new DigestOutputStream(fileStream, MessageDigest.getInstance("MD5"));){
                    StreamUtil.copyStream((OutputStream)destFileStream, (InputStream)this.getClass().getClassLoader().getResourceAsStream(sourceFileResourcePath));
                    destFileStream.flush();
                    byte[] digest = destFileStream.getMessageDigest().digest();
                    String actualMD52 = StringUtil.byteArrayToHexString((byte[])digest);
                    if (!expectedMD5.equalsIgnoreCase(actualMD52)) {
                        Logger.error((String)("Could not successfully extract binary to path: " + destinationFile.getPath()));
                        if (!destinationFile.delete()) {
                            destinationFile.deleteOnExit();
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    private String getPathPrefix() {
        return FileUtil.localConfigHome() + File.separator + "softwaresupport" + File.separator;
    }

    private String getBinPath() {
        return this.getPathPrefix() + this.props.getProperty("bin.prefix");
    }

    public ToolInvoker getToolInvoker(SoftwareSupportService.Tool tool) {
        if (!TransportUtil.isOSMac()) {
            return new ToolInvoker(){

                public DescriptionWrapper invoke() throws Exception {
                    throw new UnsupportedOperationException("Uploads of Mac and iOS apps are only supported on OS X.");
                }

                public ToolInvoker addTargetFilePath(String softwareFilePath) {
                    return this;
                }
            };
        }
        return new SoftwareSupportToolInvoker(tool, this.getToolPath(tool), statisticCollector);
    }

    public String getToolPath(SoftwareSupportService.Tool tool) {
        if (!TransportUtil.isOSMac()) {
            return null;
        }
        String toolPath = System.getProperty("com.apple.transporter." + tool.name());
        if (toolPath != null) {
            return toolPath;
        }
        if (tool == SoftwareSupportService.Tool.ProductUtil) {
            return "/usr/libexec/productutil";
        }
        this.setup();
        return this.getBinPath() + File.separator + this.props.getProperty(tool.name());
    }

    public static void setStatisticCollector(StatisticCollector statisticCollector) {
        SoftwareSupportServiceImpl.statisticCollector = statisticCollector;
    }
}

