/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.softwaresupport;

import com.apple.jingle.leghorn.software.SoftwareSupportService;
import com.apple.transporter.softwaresupport.SoftwareSupportServiceImpl;
import com.apple.transporter.stats.api.StatisticCollector;
import com.apple.transporter.toolregistry.api.ToolRegistry;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class SoftwareSupportBundleActivator
implements BundleActivator {
    BundleContext bundleContext = null;
    ServiceListener statsCollectorListener = null;
    ServiceListener toolRegistryListener = null;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.registerService(bundleContext);
        this.setupStatisticsCollector();
        this.registerTools();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (null != this.statsCollectorListener) {
            bundleContext.removeServiceListener(this.statsCollectorListener);
        }
        if (null != this.toolRegistryListener) {
            bundleContext.removeServiceListener(this.toolRegistryListener);
        }
    }

    private void registerService(BundleContext bundleContext) {
        bundleContext.registerService(SoftwareSupportService.class.getName(), (Object)new SoftwareSupportServiceImpl(), new Hashtable());
    }

    private void setupStatisticsCollector() throws InvalidSyntaxException {
        ServiceReference svcRef = this.bundleContext.getServiceReference(StatisticCollector.class);
        if (null != svcRef) {
            this.setupStatisticsCollectorByReference(svcRef);
        } else {
            this.statsCollectorListener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    switch (event.getType()) {
                        case 1: {
                            SoftwareSupportBundleActivator.this.setupStatisticsCollectorByReference(event.getServiceReference());
                            break;
                        }
                    }
                }
            };
            String filter = "(objectClass=" + StatisticCollector.class.getName() + ")";
            this.bundleContext.addServiceListener(this.statsCollectorListener, filter);
        }
    }

    private void setupStatisticsCollectorByReference(ServiceReference svcRef) {
        StatisticCollector statsCollector = (StatisticCollector)this.bundleContext.getService(svcRef);
        if (null != statsCollector) {
            SoftwareSupportServiceImpl.setStatisticCollector(statsCollector);
            this.bundleContext.ungetService(svcRef);
        }
    }

    private void registerTools() throws InvalidSyntaxException {
        ServiceReference svcRef = this.bundleContext.getServiceReference(ToolRegistry.class);
        if (null != svcRef) {
            this.registerTools(svcRef);
        } else {
            this.toolRegistryListener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    switch (event.getType()) {
                        case 1: {
                            SoftwareSupportBundleActivator.this.registerTools(event.getServiceReference());
                            break;
                        }
                    }
                }
            };
            String filter = "(objectClass=" + ToolRegistry.class.getName() + ")";
            this.bundleContext.addServiceListener(this.toolRegistryListener, filter);
        }
    }

    private void registerTools(ServiceReference svcRef) {
        ToolRegistry registry = (ToolRegistry)this.bundleContext.getService(svcRef);
        if (null != registry) {
            registry.registerToolsInBundleFromProperties(this.bundleContext.getBundle(), "softwaresupport.tool.properties");
            this.bundleContext.ungetService(svcRef);
        }
    }
}

