/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.updater;

import com.apple.transporter.log.Logger;
import com.apple.transporter.updater.MaxVersionFinder;
import com.apple.transporter.util.ConfigurationUtil;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.ProcUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resource;

public class UpdaterService {
    private static final String RunAfterUpdateFileame = "RunAfterUpdate.txt";
    private static final String TimestampFormat = "%1$tY%1$tm%1$td%1$tH%1$tM%1$tS%1$tL";
    private static final int MAX_REMOTE_PULL_ATTEMPTS = 2;
    private static final String LOCK_FILE_NAME = "lock.pid";
    private BundleContext bundleContext;

    private void addRepository(RepositoryAdmin repositoryAdmin) throws Exception {
        String repositoryUrlOverride = System.getProperty("com.apple.transporter.updater.repository.url");
        if (repositoryUrlOverride != null) {
            repositoryAdmin.addRepository(new URL(repositoryUrlOverride));
            return;
        }
        String defaultURLPrefix = "https://contentdelivery.itunes.apple.com/transporter/";
        String runVersion = System.getProperty("com.apple.transporter.runVersion");
        if (null == runVersion) {
            runVersion = "latest";
        }
        int javaVersion = UpdaterService.getJavaMajorVersion();
        while (true) {
            try {
                String jse = this.getJavaEditionString(javaVersion);
                String repositoryUrl = defaultURLPrefix + "repositories/" + jse + "/" + runVersion + "/repository.xml";
                repositoryAdmin.addRepository(new URL(repositoryUrl));
                return;
            }
            catch (IOException iOException) {
                if (--javaVersion >= 5) continue;
                throw new Exception("Could not find version: " + runVersion + " of iTMSTransporter to download.");
            }
            break;
        }
    }

    private boolean updatesAreDisabled() {
        String p = System.getProperty("com.apple.transporter.updater.disable");
        return p != null && Boolean.parseBoolean(p);
    }

    private File hasRunAfterUpdateMarkerFile() {
        File localConfigHome = FileUtil.localConfigHome();
        return new File(localConfigHome, RunAfterUpdateFileame);
    }

    private boolean isFirstRunAfterUpdate() {
        return !this.hasRunAfterUpdateMarkerFile().exists();
    }

    private void configureFirstRunAfterUpdateFile() {
        try {
            String baseInstallVersion = ConfigurationUtil.getBaseInstallVersion();
            String fileContents = "This file is a marker to indicate transporter has run at least once after updating to version " + baseInstallVersion + ".\n";
            FileUtils.writeStringToFile((File)this.hasRunAfterUpdateMarkerFile(), (String)fileContents, (String)"UTF-8");
        }
        catch (Exception e) {
            Logger.info((String)"Transporter unable to write \"first run after update\" marker file.", (Throwable)e);
        }
    }

    public UpdaterService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public int run(String[] argv) throws Exception {
        try {
            return this.start(argv, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(String[] argv, String version) throws Exception {
        try {
            Logger.configureLogging();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.isFirstRunAfterUpdate()) {
            ConfigurationUtil.deleteDefaultsPropertiesFile();
            this.configureFirstRunAfterUpdateFile();
        }
        if (this.updatesAreDisabled()) {
            Logger.info((String)"Updated software component check disabled.");
            return 0;
        }
        if (!this.shouldRunUpdate()) {
            Logger.info((String)"Transporter is skipping bundle update check: Already checked recently.");
            return 0;
        }
        if (!UpdaterService.isJava18OrBetter()) {
            Logger.warn((String)("Transporter requires Java 1.8 or higher for the latest updates. You have: " + System.getProperty("java.version") + ". Please upgrade your Java VM to be able to receive the latest updates."));
        }
        ConfigurationUtil.checkConfigHomeFreeSpace();
        Logger.info((String)"Transporter is searching for updated software components.");
        ServiceReference repositoryServiceReference = this.bundleContext.getServiceReference(RepositoryAdmin.class.getName());
        if (repositoryServiceReference == null) {
            Logger.info((String)"The RepositoryAdmin software component could not be found; update will not be performed. Please download and use the latest Transporter installer from iTunes Connect.");
            return 1;
        }
        RepositoryAdmin repositoryAdmin = (RepositoryAdmin)this.bundleContext.getService(repositoryServiceReference);
        if (repositoryAdmin == null) {
            this.bundleContext.ungetService(repositoryServiceReference);
            repositoryServiceReference = null;
            Logger.info((String)"The RepositoryAdmin software component does not exist; update will not be performed. Please download and use the latest Transporter installer from iTunes Connect.");
            return 1;
        }
        try {
            Version remoteVersion;
            String baseInstallVersionString;
            Version baseInstallVersion;
            try {
                this.addRepository(repositoryAdmin);
            }
            catch (Exception ex) {
                Logger.warn((String)"Could not connect to the remote OSGi Repository: ");
                Logger.warn((String)ex.getMessage());
                Logger.info((String)"No updates found.");
                int n = 1;
                if (null != repositoryServiceReference) {
                    this.bundleContext.ungetService(repositoryServiceReference);
                }
                return n;
            }
            Resource[] resources = repositoryAdmin.discoverResources("(symbolicname=*)");
            String versionNumberFromRepo = null;
            Long lastModifiedFromRepo = null;
            Repository[] repos = repositoryAdmin.listRepositories();
            if (repos.length > 0) {
                Resource[] repo = repos[0];
                versionNumberFromRepo = repo.getName();
                lastModifiedFromRepo = repo.getLastModified();
            }
            if (null == versionNumberFromRepo || "Untitled".equals(versionNumberFromRepo)) {
                for (Resource resource : resources) {
                    String symName = resource.getSymbolicName();
                    if (!"com.apple.transporter".equals(symName)) continue;
                    versionNumberFromRepo = resource.getVersion().toString();
                    break;
                }
            }
            if (this.getBundlesDirPath(versionNumberFromRepo) == null) {
                Logger.info((String)"Transporter is skipping bundle update check: cannot write to home directory.");
                int repo = 1;
                return repo;
            }
            String runVersionString = System.getProperty("com.apple.transporter.runVersion");
            if ((null == runVersionString || runVersionString.trim().length() == 0) && (baseInstallVersion = new Version(baseInstallVersionString = ConfigurationUtil.getBaseInstallVersion())).compareTo(remoteVersion = new Version(versionNumberFromRepo)) > 0) {
                this.updateFinished(baseInstallVersionString);
                Logger.info((String)"No updates found.");
                int n = 0;
                return n;
            }
            if (this.updateBundles(versionNumberFromRepo, lastModifiedFromRepo, resources)) {
                this.updateFinished(versionNumberFromRepo);
            }
        }
        catch (FileNotFoundException e) {
            Logger.info((String)"No updates found.");
        }
        finally {
            if (null != repositoryServiceReference) {
                this.bundleContext.ungetService(repositoryServiceReference);
            }
        }
        return 0;
    }

    private void updateFinished(String versionNumberFromRepo) throws IOException {
        File[] updateFiles = this.existingUpdateCheckFiles();
        if (updateFiles != null) {
            for (File updateFile : updateFiles) {
                if (updateFile.delete()) continue;
                updateFile.deleteOnExit();
            }
        }
        File localConfigHome = FileUtil.localConfigHome();
        String now = String.format(TimestampFormat, System.currentTimeMillis());
        File updateCheckFile = new File(localConfigHome, "update_check." + now);
        updateCheckFile.createNewFile();
        if (versionNumberFromRepo != null) {
            FileUtils.writeStringToFile((File)updateCheckFile, (String)versionNumberFromRepo, (String)"UTF-8");
        }
    }

    private File[] existingUpdateCheckFiles() {
        File localConfigHome = FileUtil.localConfigHome();
        File[] updateFiles = localConfigHome.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith("update_check.");
            }
        });
        return updateFiles;
    }

    private boolean shouldRunUpdate() {
        String versionToCheckFor;
        File[] updateFiles = this.existingUpdateCheckFiles();
        long updateCheckDuration = this.updateCheckDuration();
        String suffix = String.format(TimestampFormat, System.currentTimeMillis() - updateCheckDuration);
        String threshold = "update_check." + suffix;
        if (updateFiles != null && (versionToCheckFor = this.versionToCheckFor()) != null) {
            try {
                for (File updateFile : updateFiles) {
                    if (threshold.compareToIgnoreCase(updateFile.getName()) >= 0 || !versionToCheckFor.equalsIgnoreCase(FileUtils.readFileToString((File)updateFile, (String)"UTF-8"))) continue;
                    return false;
                }
            }
            catch (IOException e) {
                Logger.debug((String)"Error reading the existing update_check file", (Throwable)e);
            }
        }
        return true;
    }

    private String versionToCheckFor() {
        String runVersion = System.getProperty("com.apple.transporter.runVersion");
        if (null != runVersion) {
            return runVersion;
        }
        MaxVersionFinder versionFinder = new MaxVersionFinder(FileUtil.localConfigHome());
        String maxVersionString = versionFinder.findMaxVersion();
        String installVersionString = ConfigurationUtil.getBaseInstallVersion();
        if (null == installVersionString || "Unknown".equals(installVersionString)) {
            return maxVersionString;
        }
        if (null == maxVersionString) {
            return installVersionString;
        }
        Version maxVersion = new Version(maxVersionString);
        Version installVersion = new Version(installVersionString);
        if (maxVersion.compareTo(installVersion) > 0) {
            return maxVersionString;
        }
        return installVersionString;
    }

    private long updateCheckDuration() {
        return Long.getLong("updateCheckDuration", 86400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBundles(String versionNumberFromRepo, Long lastModifiedFromRepo, Resource[] resources) {
        String now = String.format(TimestampFormat, lastModifiedFromRepo);
        File newBundleDir = new File(this.getBundlesDirPath(versionNumberFromRepo) + File.separator + "bundles." + now);
        if (newBundleDir.exists()) {
            Logger.info((String)"Transporter is up-to-date.");
            return true;
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        HashMap<String, Bundle> bundleMap = new HashMap<String, Bundle>(bundles.length + 1);
        Bundle systemFrameworkBundle = this.bundleContext.getBundle();
        if ("org.apache.felix.framework".equals(systemFrameworkBundle.getSymbolicName())) {
            String string = "org.apache.felix.main:" + systemFrameworkBundle.getVersion().toString();
            bundleMap.put(string, systemFrameworkBundle);
        }
        for (Bundle bundle : bundles) {
            String bundleKey = this.makeBundleKey(bundle);
            Bundle existingBundle = (Bundle)bundleMap.get(bundleKey);
            if (existingBundle != null) continue;
            bundleMap.put(bundleKey, bundle);
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>(resources.length);
        for (Resource resource : resources) {
            String resourceKey = this.makeBundleKey(resource);
            Bundle installedBundle = (Bundle)bundleMap.get(resourceKey);
            if (installedBundle != null) continue;
            arrayList.add(resource);
        }
        if (arrayList.size() > 0) {
            Logger.info((String)"Transporter has detected that new software components exist; updating.");
            if (this.lockScratchFolder(versionNumberFromRepo)) {
                try {
                    for (Resource resource : arrayList) {
                        if (this.updateBundle(versionNumberFromRepo, resource, (Bundle)bundleMap.get(this.makeBundleKey(resource)))) continue;
                        Logger.info((String)"One or more software components could not be updated. This may cause reduced functionality. Please download and use the latest Transporter installer from iTunes Connect.");
                        int n = 0;
                        return n != 0;
                    }
                    File scratchDir = new File(this.getScratchDirPath(versionNumberFromRepo));
                    scratchDir.renameTo(newBundleDir);
                    new File(newBundleDir.getPath() + File.separator + LOCK_FILE_NAME).delete();
                    ConfigurationUtil.deleteDefaultsPropertiesFile();
                    File markerFile = this.hasRunAfterUpdateMarkerFile();
                    if (markerFile.exists()) {
                        this.hasRunAfterUpdateMarkerFile().delete();
                    }
                    Logger.info((String)"Transporter has been successfully updated. The updated components will be available the next time Transporter runs.");
                }
                finally {
                    this.releaseScratchFolder(versionNumberFromRepo);
                }
            }
        } else {
            Logger.info((String)"Transporter is up-to-date.");
        }
        return true;
    }

    private String makeBundleKey(Resource resource) {
        return resource.getSymbolicName() + ":" + resource.getVersion().toString();
    }

    private String makeBundleKey(Bundle bundle) {
        return bundle.getSymbolicName() + ":" + bundle.getVersion().toString();
    }

    private boolean updateBundle(String versionNumberFromRepo, Resource resource, Bundle installedBundle) {
        String urlString = resource.getURL().toString();
        String filename = urlString.substring(urlString.lastIndexOf("/") + 1);
        String bundlePathInScratch = this.getScratchDirPath(versionNumberFromRepo) + File.separator + filename;
        File bundleInScratch = new File(bundlePathInScratch);
        String bundleMD5 = (String)resource.getProperties().get("md5");
        Logger.debug((String)("Analyzing remote bundle resource " + resource.getSymbolicName() + "..."));
        if (bundleInScratch.exists()) {
            if (this.compareChecksums(bundleInScratch, bundleMD5)) {
                Logger.debug((String)"  ... updated bundle already exists in download folder.");
                return true;
            }
            bundleInScratch.delete();
        }
        if (installedBundle != null && installedBundle.getVersion().equals((Object)resource.getVersion())) {
            try {
                String url = installedBundle.getLocation();
                if (this.bundleIsSystemBundle(url)) {
                    Logger.debug((String)"  ... resource is same as system bundle, skipping download.");
                    return true;
                }
                FileUtils.copyURLToFile((URL)new URL(url), (File)bundleInScratch);
                if (this.compareChecksums(bundleInScratch, bundleMD5)) {
                    Logger.debug((String)"  ... bundle copied from local source.");
                    return true;
                }
            }
            catch (IOException url) {
                // empty catch block
            }
            bundleInScratch.delete();
        }
        int attemptNumber = 0;
        while (attemptNumber++ < 2) {
            try {
                FileUtils.copyURLToFile((URL)resource.getURL(), (File)bundleInScratch);
                if (this.compareChecksums(bundleInScratch, bundleMD5)) {
                    Logger.debug((String)"  ... updated bundle successfully retrieved.");
                    return true;
                }
                Logger.info((String)"A downloaded software component is corrupted and will not be used.");
            }
            catch (IOException e) {
                Logger.info((String)"Unable to download a software component", (Throwable)e);
            }
            Logger.debug((String)(" ... update attempt failed" + (attemptNumber < 2 ? ", attempting retry." : ", aborting.")));
        }
        return false;
    }

    private boolean bundleIsSystemBundle(String url) {
        if (url.indexOf("/share/OSGi-Bundles/") != -1) {
            return true;
        }
        return url.indexOf("iTMSTransporter.woa") != -1;
    }

    private boolean compareChecksums(File target, String expectedMD5) {
        try {
            try {
                String md5 = FileUtil.md5Hex((File)target);
                if (expectedMD5.equalsIgnoreCase(md5)) {
                    return true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean lockScratchFolder(String versionNumberFromRepo) {
        File lockFile = this.getLockFile(versionNumberFromRepo);
        if (lockFile.exists()) {
            try {
                String pid = FileUtils.readFileToString((File)lockFile);
                if (ProcUtil.processExists((int)Integer.parseInt(pid))) {
                    Logger.debug((String)("Another Transporter process is actively updating, pid " + pid + "; aborting update process."));
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        lockFile.delete();
        try {
            FileUtils.writeStringToFile((File)lockFile, (String)String.valueOf(ProcUtil.getPid()));
            return true;
        }
        catch (IOException iOException) {
            Logger.debug((String)"Failed to obtain scratch folder lock, cannot update.");
            return false;
        }
    }

    private void releaseScratchFolder(String versionNumberFromRepo) {
        this.getLockFile(versionNumberFromRepo).delete();
    }

    private File getLockFile(String versionNumberFromRepo) {
        String scratchDirPath = this.getScratchDirPath(versionNumberFromRepo);
        new File(scratchDirPath).mkdirs();
        File lockFile = new File(scratchDirPath + File.separator + LOCK_FILE_NAME);
        return lockFile;
    }

    private String getBundlesDirPath(String versionNumberFromRepo) {
        File localConfigHome = FileUtil.localConfigHome();
        if (localConfigHome == null) {
            return null;
        }
        String baseInstallVersion = null != versionNumberFromRepo ? versionNumberFromRepo : ConfigurationUtil.getBaseInstallVersion();
        return localConfigHome.getPath() + File.separator + baseInstallVersion + File.separator + this.getBundlesString();
    }

    private String getScratchDirPath(String versionNumberFromRepo) {
        return this.getBundlesDirPath(versionNumberFromRepo) + File.separator + "scratch";
    }

    private static boolean isJava16OrBetter() {
        return UpdaterService.isJavaMajorVersionGreaterThanOrEqualTo(6);
    }

    private static boolean isJava17OrBetter() {
        return UpdaterService.isJavaMajorVersionGreaterThanOrEqualTo(7);
    }

    private static boolean isJava18OrBetter() {
        return UpdaterService.isJavaMajorVersionGreaterThanOrEqualTo(8);
    }

    private static boolean isJava9OrBetter() {
        return UpdaterService.isJavaMajorVersionGreaterThanOrEqualTo(9);
    }

    private static boolean isJavaMajorVersionGreaterThanOrEqualTo(int majorVersionToCheckAgainst) {
        int javaMajorVersion = UpdaterService.getJavaMajorVersion();
        return javaMajorVersion >= majorVersionToCheckAgainst;
    }

    private static int getJavaMajorVersion() {
        int defaultResult = 5;
        String javaVersion = System.getProperty("java.version");
        try {
            Version v = Version.parseVersion((String)javaVersion);
            return v.getMajor();
        }
        catch (IllegalArgumentException v) {
            String[] fragments = javaVersion.split("\\.");
            if (!fragments[0].equals("1")) {
                return 5;
            }
            if (fragments.length < 2) {
                return 5;
            }
            try {
                int minorVers = Integer.parseInt(fragments[1]);
                return minorVers;
            }
            catch (NumberFormatException numberFormatException) {
                return 5;
            }
        }
    }

    private String getJavaEditionString(int javaVersion) {
        switch (javaVersion) {
            case 9: {
                return "jse9";
            }
            case 8: {
                return "j2se8";
            }
            case 7: {
                return "j2se7";
            }
            case 6: {
                return "j2se6";
            }
        }
        return "j2se5";
    }

    private String getBundlesString() {
        switch (UpdaterService.getJavaMajorVersion()) {
            case 9: {
                return "bundles-9";
            }
            case 8: {
                return "bundles-1.8";
            }
            case 7: {
                return "bundles-1.7";
            }
            case 6: {
                return "bundles-1.6";
            }
        }
        return "bundles";
    }
}

