/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.updater;

import com.apple.transporter.toolregistry.api.ToolRegistry;
import com.apple.transporter.updater.UpdaterService;
import com.apple.transporter.updater.UpdaterServiceFactory;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class UpdaterBundleActivator
implements BundleActivator {
    BundleContext bundleContext = null;
    ServiceListener toolRegistryListener = null;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.registerService(bundleContext);
        this.registerTools();
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    private void registerService(BundleContext bundleContext) {
        bundleContext.registerService(UpdaterService.class, (ServiceFactory)new UpdaterServiceFactory(), new Hashtable());
    }

    private void registerTools() throws InvalidSyntaxException {
        ServiceReference svcRef = this.bundleContext.getServiceReference(ToolRegistry.class);
        if (null != svcRef) {
            this.registerTools(svcRef);
        } else {
            this.toolRegistryListener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    switch (event.getType()) {
                        case 1: {
                            UpdaterBundleActivator.this.registerTools(event.getServiceReference());
                            break;
                        }
                    }
                }
            };
            String filter = "(objectClass=" + ToolRegistry.class.getName() + ")";
            this.bundleContext.addServiceListener(this.toolRegistryListener, filter);
        }
    }

    private void registerTools(ServiceReference svcRef) {
        ToolRegistry registry = (ToolRegistry)this.bundleContext.getService(svcRef);
        if (null != registry) {
            registry.registerToolsInBundleFromProperties(this.bundleContext.getBundle(), "updater.tool.properties");
            this.bundleContext.ungetService(svcRef);
        }
    }
}

