/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.updater;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class MaxVersionFinder {
    protected final File rootPath;
    protected final Pattern versionPattern;

    public MaxVersionFinder(File rootPath) {
        this.rootPath = rootPath;
        this.versionPattern = Pattern.compile("\\d+\\.\\d+\\.\\d+(\\..*)?");
    }

    public String findMaxVersion() {
        Version maxVersion = new Version("0");
        String result = null;
        for (File f : this.rootPath.listFiles()) {
            Version v;
            String name;
            Matcher matcher;
            if (!f.isDirectory() || !(matcher = this.versionPattern.matcher(name = f.getName())).matches() || (v = new Version(name)).compareTo(maxVersion) <= 0) continue;
            maxVersion = v;
            result = name;
        }
        return result;
    }
}

