/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.json;

import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.json.JsonBase;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

public class Size
extends JsonBase {
    public final int width;
    public final int height;

    @JsonCreator
    public Size(@JsonProperty(value="width") int width, @JsonProperty(value="height") int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Size) {
            Size that = (Size)o;
            return Objects.equal((Object)this.width, (Object)that.width) && Objects.equal((Object)this.height, (Object)that.height);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.width, this.height});
    }

    public boolean isLargerThan(Size that) {
        return this.width > that.width || this.height > that.height;
    }

    @Override
    public void validate() throws LSRException {
        if (this.width < 1) {
            this.fail("invalid Size.width");
        }
        if (this.height < 1) {
            this.fail("invalid Size.height");
        }
    }

    @JsonIgnore
    public String toShortString() {
        return this.width + "x" + this.height;
    }

    @JsonIgnore
    public boolean encloses(Size that) {
        return this.width >= that.width && this.height >= that.height;
    }
}

