/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.json;

import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.json.JsonBase;
import com.apple.its.asset.lsr.json.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Point
extends JsonBase {
    private static final MathContext MATH_CONTEXT = new MathContext(0, RoundingMode.HALF_UP);
    public final BigDecimal x;
    public final BigDecimal y;

    @JsonCreator
    public Point(@JsonProperty(value="x") String x, @JsonProperty(value="y") String y) {
        this.x = new BigDecimal(x, MATH_CONTEXT);
        this.y = new BigDecimal(y, MATH_CONTEXT);
    }

    public Point(double x, double y) {
        this.x = new BigDecimal(x, MATH_CONTEXT);
        this.y = new BigDecimal(y, MATH_CONTEXT);
    }

    public Point(int x, int y) {
        this.x = new BigDecimal(x, MATH_CONTEXT);
        this.y = new BigDecimal(y, MATH_CONTEXT);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Point) {
            Point that = (Point)o;
            return 0 == this.x.compareTo(that.x) && 0 == this.y.compareTo(that.y) && this.x.signum() == that.x.signum() && this.y.signum() == that.y.signum();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y});
    }

    @Override
    public void validate() throws LSRException {
    }

    @JsonIgnore
    public Size shift(Size size) {
        BigDecimal two = new BigDecimal(2);
        int width = (this.x.multiply(two).intValue() + size.width) / 2;
        int height = (this.y.multiply(two).intValue() + size.height) / 2;
        return new Size(width, height);
    }
}

