/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.json;

import com.apple.its.asset.lsr.LSRException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public abstract class JsonBase {
    private static final boolean USE_PRETTY_JASON = Boolean.getBoolean("images.LSR.usePrettyJson");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }

    public static <T extends JsonBase> T of(String s, Class<T> cls) {
        try {
            return (T)((JsonBase)JsonBase.objectMapper().readValue(s, cls));
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static <T extends JsonBase> T of(File file, Class<T> cls) {
        try {
            return (T)((JsonBase)JsonBase.objectMapper().readValue(file, cls));
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @JsonIgnore
    public String toJSON() {
        try {
            return JsonBase.objectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnore
    public String toPrettyJSON() {
        try {
            return JsonBase.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.toString().equals(o.toString());
    }

    public String toString() {
        return USE_PRETTY_JASON ? this.toPrettyJSON() : this.toJSON();
    }

    public abstract void validate() throws LSRException;

    protected void fail(String msg) throws LSRException {
        throw new LSRException(msg);
    }

    protected static <T extends JsonBase> void validate(Collection<T> c) {
        if (c != null) {
            for (JsonBase e : c) {
                if (e == null) continue;
                e.validate();
            }
        }
    }

    protected static <T extends JsonBase> void validate(T one) {
        if (one != null) {
            one.validate();
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return "{}".equals(this.toString());
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

