/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.json;

import com.apple.its.asset.lsr.DisplayGamut;
import com.apple.its.asset.lsr.Idiom;
import com.apple.its.asset.lsr.ImageScale;
import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.LSRFile;
import com.apple.its.asset.lsr.json.JsonBase;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.text.Normalizer;

public class Image
extends JsonBase {
    public final Idiom idiom;
    public final String filename;
    public final ImageScale scale;
    @JsonProperty(value="display-gamut")
    public final DisplayGamut displayGamut;

    @JsonCreator
    public Image(@JsonProperty(value="idiom") String idiom, @JsonProperty(value="filename") String filename, @JsonProperty(value="scale") String scale, @JsonProperty(value="display-gamut") String displayGamut) {
        this(Idiom.valueOf(idiom), filename, ImageScale.of(scale), DisplayGamut.of(displayGamut));
    }

    public Image(Idiom idiom, String filename, ImageScale scale) {
        this(idiom, filename, scale, DisplayGamut.srgb);
    }

    public Image(Idiom idiom, String filename, ImageScale scale, DisplayGamut displayGamut) {
        this.idiom = (Idiom)((Object)Preconditions.checkNotNull((Object)((Object)idiom)));
        this.filename = Normalizer.normalize((CharSequence)Preconditions.checkNotNull((Object)filename), Normalizer.Form.NFC);
        this.scale = (ImageScale)((Object)Preconditions.checkNotNull((Object)((Object)scale)));
        this.displayGamut = displayGamut;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image that = (Image)o;
        return Objects.equal((Object)((Object)this.idiom), (Object)((Object)that.idiom)) && Objects.equal((Object)this.filename, (Object)that.filename) && Objects.equal((Object)((Object)this.scale), (Object)((Object)that.scale)) && Objects.equal((Object)((Object)this.displayGamut), (Object)((Object)that.displayGamut));
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.idiom, this.filename, this.scale, this.displayGamut});
    }

    @Override
    public void validate() throws LSRException {
        LSRFile.validateFilename(this.filename);
    }
}

