/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.json;

import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.json.Image;
import com.apple.its.asset.lsr.json.Info;
import com.apple.its.asset.lsr.json.JsonBase;
import com.apple.its.asset.lsr.json.Layer;
import com.apple.its.asset.lsr.json.Properties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class Contents
extends JsonBase {
    public Info info;
    public List<Layer> layers;
    public List<Image> images;
    public Properties properties;

    public static Contents from(InputStream inputStream) throws IOException {
        return (Contents)Contents.objectMapper().readValue(inputStream, Contents.class);
    }

    @Override
    public void validate() throws LSRException {
        if (this.info == null) {
            this.fail("missing Info in Contents.json");
        }
        Contents.validate(this.layers);
        Contents.validate(this.images);
        if (this.properties != null) {
            this.properties.validate();
        }
    }

    @JsonIgnore
    public void toFile(File file) throws IOException {
        try (Closer closer = Closer.create();){
            this.outputTo((OutputStream)closer.register((Closeable)new FileOutputStream(file)));
        }
    }

    @JsonIgnore
    public void outputTo(OutputStream out) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.toString().getBytes());
        ByteStreams.copy((InputStream)in, (OutputStream)out);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.info, this.layers, this.images, this.properties});
    }
}

