/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.json;

import com.apple.its.asset.lsr.Idiom;
import com.apple.its.asset.lsr.ImageScale;
import com.apple.its.asset.lsr.ImageSet;
import com.apple.its.asset.lsr.ImageStackLayer;
import com.apple.its.asset.lsr.io.ImageBuffer;
import com.apple.its.asset.lsr.json.Contents;
import com.apple.its.asset.lsr.json.Image;
import com.apple.its.asset.lsr.json.Info;
import com.apple.its.asset.lsr.json.Layer;
import com.apple.its.asset.lsr.json.Point;
import com.apple.its.asset.lsr.json.Properties;
import com.apple.its.asset.lsr.json.Size;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;

public abstract class Builders {

    public static class ImageSetBuilder
    implements Builder<ImageSet> {
        private final ImageSet is = new ImageSet();

        public static ImageSetBuilder create() {
            return new ImageSetBuilder();
        }

        public ImageSetBuilder image(File file, String scale, Idiom idiom) {
            try {
                this.is.add(file, ImageScale.of(scale), idiom);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public ImageSetBuilder image(ImageBuffer imageBuffer, String name, String scale, String idiom, String displayGamut) {
            this.is.add(new Image(idiom, name, scale, displayGamut), ImageBuffer.create(name, imageBuffer.toBytes()));
            return this;
        }

        @Override
        public ImageSet build() {
            return this.is;
        }
    }

    public static class ImageStackLayerBuilder
    implements Builder<ImageStackLayer> {
        private ImageStackLayer layer;

        public ImageStackLayerBuilder(String name) {
            this.layer = new ImageStackLayer(name);
        }

        public ImageStackLayerBuilder properties(Properties properties) {
            this.layer.setProperties(properties);
            return this;
        }

        public ImageStackLayerBuilder imageSet(ImageSet imageSet) {
            this.layer.setImageSet(imageSet);
            return this;
        }

        @Override
        public ImageStackLayer build() {
            return this.layer;
        }
    }

    public static class PropertiesBuilder
    implements Builder<Properties> {
        private final Properties p = new Properties();

        public static PropertiesBuilder create() {
            return new PropertiesBuilder();
        }

        public PropertiesBuilder canvasSize(Size size) {
            this.p.canvasSize = size;
            return this;
        }

        public PropertiesBuilder canvasSize(int width, int height) {
            this.p.canvasSize = new Size(width, height);
            return this;
        }

        public PropertiesBuilder frameSize(Size size) {
            this.p.frameSize = size;
            return this;
        }

        public PropertiesBuilder frameSize(int width, int height) {
            this.p.frameSize = new Size(width, height);
            return this;
        }

        public PropertiesBuilder frameCenter(Point center) {
            this.p.frameCenter = center;
            return this;
        }

        public PropertiesBuilder frameCenter(int x, int y) {
            this.p.frameCenter = new Point(x, y);
            return this;
        }

        @Override
        public Properties build() {
            this.p.validate();
            return this.p;
        }
    }

    public static class ContentsBuilder
    implements Builder<Contents> {
        private final Contents c = new Contents();

        public static ContentsBuilder create() {
            return new ContentsBuilder();
        }

        public ContentsBuilder info(Info info) {
            this.c.info = info;
            return this;
        }

        public ContentsBuilder properties(Properties p) {
            this.c.properties = p;
            return this;
        }

        public ContentsBuilder layers(Layer ... layers) {
            this.c.layers = Lists.newArrayList((Object[])layers);
            return this;
        }

        public ContentsBuilder layers(Iterable<Layer> layers) {
            this.c.layers = Lists.newArrayList(layers);
            return this;
        }

        public ContentsBuilder images(Image ... images) {
            this.c.images = Lists.newArrayList((Object[])images);
            return this;
        }

        public ContentsBuilder images(Iterable<Image> images) {
            this.c.images = Lists.newArrayList(images);
            return this;
        }

        @Override
        public Contents build() {
            return this.c;
        }
    }

    static interface Builder<T> {
        public T build();
    }
}

