/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.io;

import com.apple.its.asset.lsr.io.FileImageBuffer;
import com.apple.its.asset.lsr.io.HeapImageBuffer;
import com.apple.its.asset.lsr.io.NullImageBuffer;
import com.google.common.base.Objects;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class ImageBuffer {
    protected final String name;
    protected final long size;

    public static ImageBuffer create(String name, byte[] bytes) {
        return new HeapImageBuffer(name, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageBuffer create(Strategy strategy, String name, InputStream in, long size) throws IOException {
        switch (strategy) {
            case heap: {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                long copied = ByteStreams.copy((InputStream)in, (OutputStream)out);
                if (size != -1L && copied != size) {
                    throw new IOException("copy failed, size mismatched");
                }
                return new HeapImageBuffer(name, out.toByteArray());
            }
            case file: {
                File outputFile = File.createTempFile("FileImageBuffer-", "-" + name);
                outputFile.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(outputFile);){
                    long copied = ByteStreams.copy((InputStream)in, (OutputStream)out);
                    if (size != -1L && copied != size) {
                        throw new IOException("copy failed, size mismatched");
                    }
                    FileImageBuffer fileImageBuffer = new FileImageBuffer(name, outputFile);
                    return fileImageBuffer;
                }
            }
            case none: {
                return new NullImageBuffer(name, size);
            }
        }
        throw new IllegalStateException("unsupported strategy");
    }

    protected ImageBuffer(String name, long size) {
        this.name = name;
        this.size = size;
    }

    public String name() {
        return this.name;
    }

    public long size() {
        return this.size;
    }

    public abstract boolean readable();

    public abstract InputStream asInputStream() throws IOException;

    public abstract byte[] toBytes();

    public void copyTo(OutputStream out) throws IOException {
        ByteStreams.copy((InputStream)this.asInputStream(), (OutputStream)out);
    }

    public void copyTo(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("can't create parent directory: " + parent);
        }
        this.copyTo(new FileOutputStream(file));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.size, this.readable() ? Arrays.hashCode(this.toBytes()) : 0});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImageBuffer) {
            ImageBuffer that = (ImageBuffer)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.size, (Object)that.size) && !this.readable() && !that.readable() || Arrays.equals(this.toBytes(), that.toBytes());
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("size", this.size).toString();
    }

    public static enum Strategy {
        heap,
        file,
        none;

    }
}

