/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr.io;

import com.apple.its.asset.lsr.io.ImageBuffer;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileImageBuffer
extends ImageBuffer {
    private final File file;

    public FileImageBuffer(String name, File file) {
        super(name, file.length());
        this.file = file;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean readable() {
        return this.file.canRead();
    }

    @Override
    public InputStream asInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toBytes() {
        try (Closer closer = Closer.create();){
            ByteArrayOutputStream out = new ByteArrayOutputStream((int)this.size);
            InputStream from = (InputStream)closer.register((Closeable)this.asInputStream());
            ByteStreams.copy((InputStream)from, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

