/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr;

import com.apple.its.asset.lsr.AssetBundleScheme;
import com.apple.its.asset.lsr.AuthoringTool;
import com.apple.its.asset.lsr.DefaultLSRConfig;
import com.apple.its.asset.lsr.DisplayGamut;
import com.apple.its.asset.lsr.ImageScale;
import com.apple.its.asset.lsr.ImageSet;
import com.apple.its.asset.lsr.ImageStackLayer;
import com.apple.its.asset.lsr.LSRConfig;
import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.io.ImageBuffer;
import com.apple.its.asset.lsr.json.Contents;
import com.apple.its.asset.lsr.json.Image;
import com.apple.its.asset.lsr.json.Layer;
import com.apple.its.asset.lsr.json.Point;
import com.apple.its.asset.lsr.json.Properties;
import com.apple.its.asset.lsr.json.Size;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class LSRFile
extends AbstractList<ImageStackLayer> {
    static final String JSON_FILENAME = "Contents.json";
    static final String IMAGESTACKLAYER_EXT = ".imagestacklayer";
    static final String IMAGESET_EXT = ".imageset/";
    static final Pattern LSR_FILENAME_PATTERN = Pattern.compile(".*\\.lsr", 2);
    static final LSRConfig config = new DefaultLSRConfig();
    public static final int MAX_FILENAME_LEN = 255;
    private final List<ImageStackLayer> backing = Lists.newArrayList();
    private Size canvasSize;
    private Set<String> tracked = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
    Contents root = null;
    static final Pattern FLATTEN_OUTPUT_PATTERN = Pattern.compile(".*\\.(jp[e]g|png)", 2);

    static void checkFileName(String s) throws LSRException {
        int nameMaxLength = 255;
        if (s == null || s.isEmpty()) {
            LSRFile.fail("filename not set");
        }
        if (s.length() > 255) {
            LSRFile.fail("filename exceeds %d characters: %s", 255, s);
        }
        if (s.contains("\\")) {
            LSRFile.fail("filename contains \\ (backslash): %s", s);
        }
        for (String p : s.split("/")) {
            if (!p.startsWith(".")) continue;
            LSRFile.fail("filename starts with . (dot): %s", s);
        }
    }

    public LSRFile() {
    }

    public LSRFile(File file) throws IOException {
        this(file, ImageBuffer.Strategy.heap);
    }

    public LSRFile(File file, ImageBuffer.Strategy strategy) throws IOException {
        this.open(file, strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LSRFile(InputStream in, ImageBuffer.Strategy strategy) throws IOException {
        File file = File.createTempFile("LSRFile-", ".lsr");
        try {
            try (FileOutputStream out = new FileOutputStream(file);){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
            this.open(file, strategy);
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LSRFile(byte[] bytes, ImageBuffer.Strategy strategy) throws IOException {
        File file = File.createTempFile("LSRFile-", ".lsr");
        try {
            try (FileOutputStream out = new FileOutputStream(file);){
                ByteStreams.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)out);
            }
            this.open(file, strategy);
        }
        finally {
            file.delete();
        }
    }

    static void ensureUnique(Map<String, String> map, String layer, String imageSet) {
        String previous;
        if (layer != null && imageSet != null && (previous = map.put(layer, imageSet)) != null && String.CASE_INSENSITIVE_ORDER.compare(previous, imageSet) != 0) {
            LSRFile.fail("duplicate image set for layer %s", layer);
        }
    }

    String track(String s) {
        this.tracked.add(s);
        return s;
    }

    void open(File file, ImageBuffer.Strategy strategy) throws IOException {
        TreeMap jsonFiles = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        TreeMap imageBuffers = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        TreeMap imageSetMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        ZipFile zipFile = new ZipFile(file);
        try {
            block11: for (ZipArchiveEntry ze : Collections.list(zipFile.getEntries())) {
                FileType type;
                String name = Normalizer.normalize(ze.getName(), Normalizer.Form.NFC);
                if (ze.isUnixSymlink()) {
                    LSRFile.fail("symlink is not supported");
                }
                FileType fileType = type = ze.isDirectory() ? FileType.directory : FileType.of(name);
                if (type != FileType.ignore) {
                    LSRFile.checkFileName(name);
                }
                this.checkCRC(zipFile, ze);
                switch (type) {
                    case image: {
                        Matcher matcher = FileType.image.pattern.matcher(name);
                        if (matcher.matches()) {
                            LSRFile.ensureUnique(imageSetMap, matcher.group(1), matcher.group(2));
                            String filename = matcher.group(3);
                            if (null == imageBuffers.put(name, ImageBuffer.create(strategy, filename, zipFile.getInputStream(ze), ze.getSize()))) continue block11;
                            LSRFile.fail("duplicate image named: %s", name);
                            break;
                        }
                        LSRFile.fail("invalid image filename %s", name);
                        break;
                    }
                    case json: {
                        Matcher matcher = FileType.json.pattern.matcher(name);
                        if (matcher.matches()) {
                            LSRFile.ensureUnique(imageSetMap, matcher.group(2), matcher.group(4));
                            Contents contents = Contents.from(zipFile.getInputStream(ze));
                            if (contents.info == null) {
                                LSRFile.fail("missing Info in %s", name);
                            }
                            if (!this.isSupported(contents.info.version)) {
                                LSRFile.fail("version not supported: %d", contents.info.version);
                            }
                            contents.validate();
                            if (null == jsonFiles.put(name, contents)) continue block11;
                            LSRFile.fail("duplicate file: %s", name);
                            break;
                        }
                        LSRFile.fail("invalid json filename %s", name);
                        break;
                    }
                    case ignore: 
                    case directory: {
                        break;
                    }
                    case reject: {
                        LSRFile.fail("file not supported: %s", name);
                        break;
                    }
                    default: {
                        LSRFile.fail("unknown file type for %s", name);
                    }
                }
            }
        }
        catch (JsonMappingException e) {
            throw new LSRException("Your media file does not meet expected guidelines. Please refer to LSR Guidelines to troubleshoot", e);
        }
        finally {
            ZipFile.closeQuietly((ZipFile)zipFile);
        }
        this.root = (Contents)jsonFiles.get(this.track(JSON_FILENAME));
        if (this.root == null) {
            LSRFile.fail("missing %s", JSON_FILENAME);
        }
        if (this.root.properties == null) {
            LSRFile.fail("missing Properties in %s", JSON_FILENAME);
        }
        if (this.root.properties.canvasSize == null) {
            LSRFile.fail("missing Properties.canvasSize in %s", JSON_FILENAME);
        }
        this.canvasSize = this.root.properties.canvasSize;
        if (this.root.layers == null || this.root.layers.isEmpty()) {
            throw new LSRException("no layer defined in Contents.json");
        }
        int id = 0;
        for (Layer layer : this.root.layers) {
            String jsonFileName;
            Contents layerJson;
            if (layer.filename == null) {
                LSRFile.fail("no filename for layer[%d]", id);
            }
            if ((layerJson = (Contents)jsonFiles.get(this.track(jsonFileName = layer.filename + "/" + JSON_FILENAME))) == null) {
                LSRFile.fail("missing %s", jsonFileName);
            }
            String layerName = layer.filename.replaceFirst("([^/]*)\\.imagestacklayer", "$1");
            String setName = (String)imageSetMap.get(layerName);
            String imageSetDir = layer.filename + "/" + setName + IMAGESET_EXT;
            Contents imageSetJson = (Contents)jsonFiles.get(this.track(imageSetDir + JSON_FILENAME));
            ImageStackLayer imageStackLayer = new ImageStackLayer(layerName);
            imageStackLayer.setInfo(layerJson.info);
            if (imageSetJson == null) {
                LSRFile.fail("No %s found for layer [%s] imageset", JSON_FILENAME, layerName);
            }
            if (imageSetJson.images == null || imageSetJson.isEmpty()) {
                LSRFile.fail("no image for image set in layer %s", layerName);
            }
            ImageSet imageSet = new ImageSet(setName);
            for (Image image : imageSetJson.images) {
                String imageFilename = imageSetDir + image.filename;
                ImageBuffer imageBuffer = (ImageBuffer)imageBuffers.get(this.track(imageFilename));
                if (imageBuffer == null) {
                    LSRFile.fail("no image found: %s", imageFilename);
                }
                imageSet.add(image, imageBuffer);
                if (layerJson.properties == null) continue;
                if (layerJson.properties.frameCenter == null) {
                    layerJson.properties.frameCenter = new Point(this.canvasSize.width / 2, this.canvasSize.height / 2);
                }
                imageStackLayer.setProperties(layerJson.properties);
            }
            imageStackLayer.setImageSet(imageSet);
            this.backing.add(imageStackLayer);
            ++id;
        }
        this.checkForUnreferenced((Set<String>)Sets.union(jsonFiles.keySet(), imageBuffers.keySet()));
    }

    public AuthoringTool authoringTool() {
        return AuthoringTool.of(this.root.info.author);
    }

    public DisplayGamut bestDisplayGamut() {
        return this.get(0).getImageSet().bestDisplayGamut();
    }

    public ImageScale bestScale() {
        return this.get(0).getImageSet().bestScale();
    }

    public AssetBundleScheme assetBundleScheme() {
        return this.get(0).getImageSet().assetBundleScheme();
    }

    void checkForUnreferenced(Set<String> set) {
        TreeSet unused = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        unused.addAll(set);
        unused.removeAll(this.tracked);
        if (!unused.isEmpty()) {
            LSRFile.fail("unreferenced files: %s", Joiner.on((String)" ").join((Iterable)unused));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCRC(ZipFile zipFile, ZipArchiveEntry ze) throws IOException {
        ze.getCrc();
        CRC32 crc32 = new CRC32();
        byte[] bytes = new byte[10240];
        try (InputStream in = zipFile.getInputStream(ze);){
            int n;
            while ((n = in.read(bytes)) > 0) {
                crc32.update(bytes, 0, n);
            }
        }
        if (crc32.getValue() != ze.getCrc()) {
            LSRFile.fail(String.format("CRC mismatch for %s, expect=%08x actual=%08x", ze, ze.getCrc(), crc32.getValue()));
        }
    }

    private boolean isSupported(int version) {
        return version == 1;
    }

    static void fail(String msg) throws LSRException {
        throw new LSRException(msg);
    }

    static void fail(String format, Object ... args) throws LSRException {
        throw new LSRException(String.format(format, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(File file) throws IOException, LSRException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((boolean)LSRFile.matches(LSR_FILENAME_PATTERN, file.getName()), (Object)"output file must have lsr extension");
        this.validate();
        this.root = this.createJson();
        try (ZipArchiveOutputStream zip = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(file));){
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(JSON_FILENAME);
            zip.putArchiveEntry((ArchiveEntry)zipEntry);
            this.root.outputTo((OutputStream)zip);
            zip.closeArchiveEntry();
            for (ImageStackLayer isl : this) {
                isl.outputTo(zip);
            }
        }
    }

    public void validate() throws LSRException {
        if (this.isEmpty()) {
            LSRFile.fail("no layer defined");
        }
        if (this.canvasSize == null) {
            LSRFile.fail("canvasSize not set");
        }
        this.canvasSize.validate();
        Integer scaleCount_1x = 0;
        Integer scaleCount_2x = 0;
        HashSet nameSet = Sets.newHashSet();
        for (ImageStackLayer layer : this) {
            if (!nameSet.add(layer.name())) {
                LSRFile.fail("duplicate layer name: %s", layer.name());
            }
            layer.validate();
            if (layer.getProperties() != null) {
                Point center = layer.getProperties().frameCenter;
                Size size = layer.getProperties().frameSize;
                if (size == null) {
                    LSRFile.fail("frame-size is missing - layer " + layer.name());
                }
            }
            ImageSet imageSet = layer.getImageSet();
            for (ImageSet.Entry e : imageSet) {
                Integer n;
                Integer n2;
                if (e.scale().equals((Object)ImageScale._1x)) {
                    n2 = scaleCount_1x;
                    n = scaleCount_1x = Integer.valueOf(scaleCount_1x + 1);
                }
                if (!e.scale().equals((Object)ImageScale._2x)) continue;
                n2 = scaleCount_2x;
                n = scaleCount_2x = Integer.valueOf(scaleCount_2x + 1);
            }
        }
        if (!scaleCount_1x.equals(scaleCount_2x) && scaleCount_1x > 0 && scaleCount_2x > 0) {
            LSRFile.fail("ImageSet Entry mismatch");
        }
    }

    static String formatFrame(Point c, Size s, Dimension canvas, String name) {
        Rectangle r = LSRFile.frameRect(c, s, canvas, name);
        return r.width + "x" + r.height + "+" + r.width + "+" + r.height;
    }

    public void afterModify() {
        this.root = null;
    }

    @Override
    public boolean add(ImageStackLayer layer) {
        if (this.backing.add(layer)) {
            this.afterModify();
            return true;
        }
        return false;
    }

    @Override
    public ImageStackLayer get(int index) {
        return this.backing.get(index);
    }

    @Override
    public ImageStackLayer set(int index, ImageStackLayer element) {
        ImageStackLayer previous = this.backing.set(index, element);
        this.afterModify();
        return previous;
    }

    @Override
    public void add(int index, ImageStackLayer element) {
        this.backing.add(index, element);
        this.afterModify();
    }

    @Override
    public ImageStackLayer remove(int index) {
        ImageStackLayer e = this.backing.remove(index);
        this.afterModify();
        return e;
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    public Size canvasSize() {
        return this.canvasSize;
    }

    public void setCanvasSize(Size cs) {
        this.canvasSize = cs;
        this.afterModify();
    }

    public void setCanvasSize(int width, int height) {
        this.setCanvasSize(new Size(width, height));
    }

    public static String joinPath(String ... parts) {
        return Joiner.on((String)"/").skipNulls().join((Object[])parts);
    }

    public Contents getRootContents() {
        return this.root == null ? this.createJson() : this.root;
    }

    public Contents createJson() {
        Contents json = new Contents();
        json.info = config.defaultInfo();
        json.properties = new Properties();
        json.properties.canvasSize = this.canvasSize;
        json.layers = Lists.newArrayList((Iterable)Iterables.transform((Iterable)this, (Function)new Function<ImageStackLayer, Layer>(){

            public Layer apply(ImageStackLayer layer) {
                return new Layer(layer.name() + LSRFile.IMAGESTACKLAYER_EXT);
            }
        }));
        return json;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LSRFile) {
            LSRFile that = (LSRFile)o;
            return Objects.equal((Object)this.canvasSize, (Object)that.canvasSize) && Objects.equal(this.backing, that.backing);
        }
        return false;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("canvasSize", (Object)(this.canvasSize == null ? "?" : this.canvasSize.toShortString())).addValue((Object)super.toString()).toString();
    }

    static boolean matches(Pattern p, String s) {
        return s != null && p.matcher(s).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flatten(File output) throws IOException {
        Matcher matcher = FLATTEN_OUTPUT_PATTERN.matcher(output.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unsupported format, use only png or jpg file extension");
        }
        String format = matcher.group(1).equalsIgnoreCase("png") ? "PNG" : "JPG";
        int width = this.canvasSize().width;
        int height = this.canvasSize().height;
        Dimension canvasDimension = new Dimension(width, height);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        try {
            DisplayGamut bestGamut = this.bestDisplayGamut();
            ImageScale bestScale = this.bestScale();
            for (ImageStackLayer layer : Lists.reverse((List)this)) {
                if (layer.getProperties() == null) {
                    throw new IllegalStateException("missing properties in layer " + layer.name());
                }
                for (ImageSet.Entry e : layer.getImageSet()) {
                    if (e.displayGamut() != bestGamut || e.scale() != bestScale) continue;
                    Rectangle frame = LSRFile.frameRect(layer.getProperties().frameCenter, layer.getProperties().frameSize, canvasDimension, layer.name());
                    BufferedImage img = ImageIO.read(e.imageBuffer().asInputStream());
                    g.drawImage((java.awt.Image)img, frame.x, frame.y, null);
                }
            }
        }
        finally {
            g.dispose();
        }
        ImageIO.write((RenderedImage)image, format, output);
    }

    public static Rectangle frameRect(Point center, Size size, Dimension canvas, String name) {
        if (center != null && size != null) {
            return new Rectangle(LSRFile.round(center.x.doubleValue() - (double)size.width / 2.0), LSRFile.round(center.y.doubleValue() - (double)size.height / 2.0), size.width, size.height);
        }
        if (center == null) {
            return new Rectangle((canvas.width - size.width) / 2, (canvas.height - size.height) / 2, size.width, size.height);
        }
        throw new IllegalStateException("no frameSize - layer " + name);
    }

    static int round(double d) {
        return (int)d;
    }

    public static void validateFilename(String filename) {
        if (filename == null || filename.isEmpty()) {
            LSRFile.fail("filename is null or empty");
        }
        if (filename.length() > 255) {
            LSRFile.fail("filename must be 255 characters or less");
        }
        if (filename.startsWith(".")) {
            LSRFile.fail("filename must not start with .");
        }
    }

    static enum FileType {
        reject("__MACOSX"),
        image("([^/]*)\\.imagestacklayer/([^/]*)\\.imageset/([^/]+\\.(png|jpeg|jpg))"),
        json("(([^/]*)\\.imagestacklayer/)?(([^/]*)\\.imageset/)?Contents.json"),
        directory(".*/"),
        ignore("((.*/)?\\..*)|(META-INF/.*)"),
        other("");

        public final Pattern pattern;

        private FileType(String regex) {
            this.pattern = Pattern.compile(regex, 2);
        }

        public static FileType of(String path) {
            for (FileType type : FileType.values()) {
                if (!type.pattern.matcher(path).matches()) continue;
                return type;
            }
            return other;
        }
    }
}

