/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr;

import com.apple.its.asset.lsr.ImageSet;
import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.LSRFile;
import com.apple.its.asset.lsr.json.Builders;
import com.apple.its.asset.lsr.json.Contents;
import com.apple.its.asset.lsr.json.Info;
import com.apple.its.asset.lsr.json.Properties;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ImageStackLayer {
    private final String name;
    private Info info;
    private Properties properties;
    private ImageSet imageSet;

    public ImageStackLayer(String name) {
        this.name = name;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ImageSet getImageSet() {
        return this.imageSet;
    }

    public void setImageSet(ImageSet imageSet) {
        this.imageSet = imageSet;
    }

    public void outputTo(ZipArchiveOutputStream zip) throws IOException {
        zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(this.dir() + "/" + "Contents.json"));
        this.createJSON().outputTo((OutputStream)zip);
        zip.closeArchiveEntry();
        this.imageSet.outputTo(this.dir() + "/" + this.imageSet.name() + ".imageset", zip);
    }

    public Contents createJSON() {
        this.info = LSRFile.config.defaultInfo();
        return new Builders.ContentsBuilder().info(this.info).properties(this.properties).build();
    }

    public void validate() throws LSRException {
        if (this.properties != null) {
            this.properties.validate();
        }
        if (this.imageSet == null) {
            LSRFile.fail("no image set for layer %s", this.name);
        }
        this.imageSet.validate(this);
    }

    public String name() {
        return this.name;
    }

    public String dir() {
        return this.name + ".imagestacklayer";
    }

    public boolean isEditorial() {
        return this.properties != null && (Boolean)Objects.firstNonNull((Object)this.properties.fixedFrame, (Object)false) != false;
    }

    public void setEditorial(boolean b) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.fixedFrame = b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImageStackLayer) {
            ImageStackLayer that = (ImageStackLayer)o;
            return Objects.equal((Object)this.imageSet, (Object)that.imageSet) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.info, (Object)that.info) && Objects.equal((Object)this.properties, (Object)that.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.info, this.properties, this.imageSet});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("imageSet", (Object)this.imageSet).toString();
    }
}

